/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.action.ExportToCsvUtil;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.FileField;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.SelectableList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportConfigurationPanel {
    private KnowledgeBase kb;
    private JPanel configPanel;
    private JCheckBox exportTypesCheckBox;
    private JCheckBox exportHeaderCheckBox;
    private JCheckBox exportBrowserTextCheckBox;
    private JCheckBox exportMetadataCheckBox;
    private JCheckBox exportSuperclassesCheckBox;
    private FileField fileField;
    private JTextField slotDelimiterTextField;
    private JTextField slotValuesDelimiterTextField;
    private Collection<Slot> slots = new LinkedHashSet<Slot>();
    private Collection<Slot> possibleSlots = new LinkedHashSet<Slot>();
    private Collection<Cls> clses = new LinkedHashSet<Cls>();
    private String metadataString = "";
    private boolean showExportSuperclasses = false;
    private boolean showExportClasses = false;
    private static HashMap<String, String> replaceChars = new HashMap();

    public ExportConfigurationPanel(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
    }

    public JPanel getConfigPanel() {
        LabeledComponent labeledComponent;
        this.configPanel = new JPanel();
        this.configPanel.setLayout(new BoxLayout(this.configPanel, 1));
        this.fileField = new FileField("Exported file", this.getExportedFileName(), "csv", "Exported result files");
        this.configPanel.add(this.fileField);
        if (this.showExportClasses) {
            labeledComponent = this.getClsesListComponent();
            this.configPanel.add(labeledComponent);
        }
        labeledComponent = this.getSlotsListComponent();
        this.configPanel.add(labeledComponent);
        this.configPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel jPanel = new JPanel(new GridLayout(2, 2));
        jPanel.add(new JLabel("Slot delimiter"));
        this.slotDelimiterTextField = new JTextField(ExportToCsvUtil.getSlotsDelimiter(), 10);
        jPanel.add(this.slotDelimiterTextField);
        jPanel.add(new JLabel("Slot values delimiter"));
        this.slotValuesDelimiterTextField = new JTextField(ExportToCsvUtil.getSlotValuesDelimiter(), 10);
        jPanel.add(this.slotValuesDelimiterTextField);
        this.configPanel.add(jPanel);
        this.configPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel jPanel2 = new JPanel(new GridLayout(this.showExportSuperclasses ? 5 : 4, 1));
        this.exportHeaderCheckBox = ComponentFactory.createCheckBox("Export slots name as first line in the file");
        this.exportHeaderCheckBox.setAlignmentX(0.0f);
        this.exportHeaderCheckBox.setSelected(true);
        jPanel2.add(this.exportHeaderCheckBox);
        this.exportTypesCheckBox = ComponentFactory.createCheckBox("Export instance type(s)");
        this.exportTypesCheckBox.setAlignmentX(0.0f);
        this.exportTypesCheckBox.setSelected(false);
        jPanel2.add(this.exportTypesCheckBox);
        this.exportBrowserTextCheckBox = ComponentFactory.createCheckBox("Export browser text (instead of name)");
        this.exportBrowserTextCheckBox.setAlignmentX(0.0f);
        this.exportBrowserTextCheckBox.setSelected(ExportToCsvUtil.isExportBrowserTextEnabled());
        jPanel2.add(this.exportBrowserTextCheckBox);
        if (this.showExportSuperclasses) {
            this.exportSuperclassesCheckBox = ComponentFactory.createCheckBox("Export superclasses");
            this.exportSuperclassesCheckBox.setAlignmentX(0.0f);
            this.exportSuperclassesCheckBox.setSelected(ExportToCsvUtil.isExportSuperclass());
            jPanel2.add(this.exportSuperclassesCheckBox);
        }
        jPanel2.add(this.getExportMetadataComponent());
        this.configPanel.add(jPanel2);
        return this.configPanel;
    }

    private JComponent getExportMetadataComponent() {
        boolean bl = ExportToCsvUtil.isExportMetadata();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.exportMetadataCheckBox = ComponentFactory.createCheckBox("Export additional text as last line in the file");
        this.exportMetadataCheckBox.setAlignmentX(0.0f);
        this.exportMetadataCheckBox.setSelected(bl);
        jPanel.add(this.exportMetadataCheckBox);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        final JButton jButton = new JButton("Edit text");
        jButton.setEnabled(bl);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExportConfigurationPanel.this.onEditText();
            }
        });
        this.exportMetadataCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ExportConfigurationPanel.this.exportMetadataCheckBox.isSelected();
                jButton.setEnabled(bl);
                ExportToCsvUtil.setExportMetadata(bl);
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    protected void onEditText() {
        JTextArea jTextArea = ComponentFactory.createTextArea();
        jTextArea.setPreferredSize(new Dimension(300, 150));
        jTextArea.setText(this.getExportMetadataText());
        LabeledComponent labeledComponent = new LabeledComponent("Information to be exported in the last line", new JScrollPane(jTextArea));
        int n = ModalDialog.showDialog(this.configPanel, labeledComponent, "Export information", 11);
        if (n == 1) {
            this.setExportMetadata(jTextArea.getText());
        }
    }

    private LabeledComponent getSlotsListComponent() {
        final SelectableList selectableList = ComponentFactory.createSelectableList(null);
        selectableList.setCellRenderer(FrameRenderer.createInstance());
        ComponentUtilities.addListValues(selectableList, this.slots);
        LabeledComponent labeledComponent = new LabeledComponent("Slots to export", new JScrollPane(selectableList), true);
        labeledComponent.addHeaderButton(new AllowableAction("Add slots", Icons.getAddSlotIcon(), null){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object2;
                HashSet<Slot> hashSet = new HashSet<Slot>();
                for (Object object2 : ExportConfigurationPanel.this.kb.getSlots()) {
                    if (object2.isSystem()) continue;
                    hashSet.add((Slot)object2);
                }
                hashSet.add(ExportConfigurationPanel.this.kb.getNameSlot());
                hashSet.addAll(ExportConfigurationPanel.this.possibleSlots);
                object2 = new ArrayList(hashSet);
                Collections.sort(object2, new FrameComparator());
                Collection collection = DisplayUtilities.pickSlots(ExportConfigurationPanel.this.configPanel, (Collection)object2, "Select slots to export (multiple selection)");
                ExportConfigurationPanel.this.slots.addAll(collection);
                ComponentUtilities.clearListValues(selectableList);
                ComponentUtilities.addListValues(selectableList, ExportConfigurationPanel.this.slots);
            }
        });
        labeledComponent.addHeaderButton(new AllowableAction("Remove slot", Icons.getRemoveSlotIcon(), selectableList){

            public void actionPerformed(ActionEvent actionEvent) {
                Collection collection = this.getSelection();
                if (collection != null) {
                    ExportConfigurationPanel.this.slots.removeAll(collection);
                }
                ComponentUtilities.clearListValues(selectableList);
                ComponentUtilities.addListValues(selectableList, ExportConfigurationPanel.this.slots);
            }
        });
        return labeledComponent;
    }

    private LabeledComponent getClsesListComponent() {
        final SelectableList selectableList = ComponentFactory.createSelectableList(null);
        selectableList.setCellRenderer(FrameRenderer.createInstance());
        ComponentUtilities.setListValues(selectableList, this.clses);
        LabeledComponent labeledComponent = new LabeledComponent("Classes to export", new JScrollPane(selectableList), true);
        labeledComponent.addHeaderButton(new AllowableAction("Add classes", Icons.getAddClsIcon(), null){

            public void actionPerformed(ActionEvent actionEvent) {
                HashSet hashSet = new HashSet();
                ArrayList arrayList = new ArrayList(hashSet);
                Collections.sort(arrayList, new FrameComparator());
                Collection collection = DisplayUtilities.pickClses((Component)ExportConfigurationPanel.this.configPanel, ExportConfigurationPanel.this.kb, ExportConfigurationPanel.this.kb.getRootClses());
                ExportConfigurationPanel.this.clses.addAll(collection);
                ComponentUtilities.clearListValues(selectableList);
                ComponentUtilities.addListValues(selectableList, ExportConfigurationPanel.this.clses);
            }
        });
        labeledComponent.addHeaderButton(new AllowableAction("Remove cls", Icons.getRemoveClsIcon(), selectableList){

            public void actionPerformed(ActionEvent actionEvent) {
                Collection collection = this.getSelection();
                if (collection != null) {
                    ExportConfigurationPanel.this.clses.removeAll(collection);
                }
                ComponentUtilities.clearListValues(selectableList);
                ComponentUtilities.addListValues(selectableList, ExportConfigurationPanel.this.clses);
            }
        });
        return labeledComponent;
    }

    private String getExportedFileName() {
        String string = this.kb.getProject().getProjectFilePath();
        String string2 = this.kb.getProject().getProjectName();
        if (this.kb.getProject().isMultiUserClient()) {
            string = ApplicationProperties.getApplicationDirectory().getAbsolutePath();
            string2 = "query";
        }
        String string3 = FileUtilities.replaceFileName(string, string2 + "_exported");
        string3 = string3 + "." + "csv";
        return string3;
    }

    public boolean isExportTypesEnabled() {
        return this.exportTypesCheckBox.isSelected();
    }

    public Collection<Slot> getExportedSlots() {
        return this.slots;
    }

    public File getExportedFile() {
        return this.fileField.getFilePath();
    }

    public boolean isExportHeaderEnabled() {
        return this.exportHeaderCheckBox.isSelected();
    }

    public boolean isExportBrowserTextEnabled() {
        return this.exportBrowserTextCheckBox.isSelected();
    }

    public boolean isExportSuperclassEnabled() {
        return this.exportSuperclassesCheckBox != null && this.exportSuperclassesCheckBox.isSelected();
    }

    public boolean isExportMetadataEnabled() {
        return this.exportMetadataCheckBox.isSelected();
    }

    public String getSlotDelimiter() {
        return this.getDelimiterString(this.slotDelimiterTextField.getText());
    }

    public String getSlotValuesDelimiter() {
        return this.getDelimiterString(this.slotValuesDelimiterTextField.getText());
    }

    private String getDelimiterString(String string) {
        String string2 = new String(string);
        Iterator<String> iterator = replaceChars.keySet().iterator();
        while (iterator.hasNext()) {
            String string3;
            String string4 = string3 = iterator.next();
            string2 = string2.replace(string4, replaceChars.get(string4));
        }
        return string2;
    }

    public Collection<Slot> getPossibleSlots() {
        return this.possibleSlots;
    }

    public void setPossibleSlots(Collection<Slot> collection) {
        this.possibleSlots = collection;
    }

    public void setInitialExportClasses(Collection<Cls> collection) {
        this.clses.clear();
        this.clses.addAll(collection);
    }

    public Collection<Cls> getExportedClassesInPanel() {
        return this.clses;
    }

    public String getExportMetadataText() {
        return this.metadataString;
    }

    public void setExportMetadata(String string) {
        this.metadataString = string;
    }

    public void setShowExportSuperclasses(boolean bl) {
        this.showExportSuperclasses = bl;
    }

    public void setShowExportedClasses(boolean bl) {
        this.showExportClasses = bl;
    }

    static {
        replaceChars.put("\\t", "\t");
        replaceChars.put("\\b", "\b");
        replaceChars.put("\\n", "\n");
        replaceChars.put("\\f", "\f");
        replaceChars.put("\\r", "\r");
    }
}

