/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.framestore.SimpleTestCase;
import edu.stanford.smi.protege.util.CacheMap;
import edu.stanford.smi.protege.util.Log;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CacheMap_Test
extends SimpleTestCase {
    private static final Logger log = Log.getLogger(CacheMap_Test.class);

    public void testSizeLimit() {
        int n = 15;
        int n2 = 10;
        CacheMap<String, Integer> cacheMap = new CacheMap<String, Integer>(n);
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < n2 * n; ++i) {
            String string = this.makeKey(i);
            cacheMap.put(string, i);
            hashSet.add(string);
            if (log.isLoggable(Level.FINE)) {
                log.fine("After adding " + (i + 1) + " entries the map size is " + cacheMap.size());
            }
            if (i > n) {
                CacheMap_Test.assertTrue((cacheMap.size() <= n && cacheMap.size() >= 4 * n / 5 ? 1 : 0) != 0);
            }
            int n3 = 0;
            for (String string2 : cacheMap.keySet()) {
                ++n3;
                CacheMap_Test.assertTrue((boolean)string2.equals(this.makeKey((Integer)cacheMap.get(string2))));
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("found " + string2 + " -> " + cacheMap.get(string2));
            }
            if (i <= n) continue;
            CacheMap_Test.assertTrue((n3 <= n && n3 >= 4 * n / 5 ? 1 : 0) != 0);
        }
    }

    private String makeKey(int n) {
        return "Entry at " + n;
    }
}

