/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.action;

import com.catalysoft.swing.unicode.UnicodeChooser;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.StandardAction;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;

public class InsertUnicodeCharacterAction
extends TextAction {
    private static final long serialVersionUID = 738458294463754734L;
    private UnicodeChooser chooser;

    public InsertUnicodeCharacterAction() {
        super(null);
        StandardAction.initialize(this, ResourceKey.INSERT_UNICODE_ACTION, false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        final JTextComponent jTextComponent = this.getTextComponent(actionEvent);
        if (jTextComponent != null) {
            if (this.chooser == null) {
                Window window = SwingUtilities.windowForComponent(jTextComponent);
                if (window == null) {
                    Log.getLogger().warning("no window for unicode panel");
                }
                try {
                    this.chooser = UnicodeChooser.instance((Component)window);
                }
                catch (RuntimeException runtimeException) {
                    Log.getLogger().warning(runtimeException.getMessage());
                }
            }
            this.chooser.setVisible(true);
            this.chooser.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Character c;
                    if ("InsertCharacter".equals(propertyChangeEvent.getPropertyName()) && (c = (Character)propertyChangeEvent.getNewValue()) != null) {
                        try {
                            jTextComponent.getDocument().insertString(jTextComponent.getCaretPosition(), c.toString(), null);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }
}

