/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.socket;

import edu.stanford.smi.protege.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MonitoringInputStream
extends InputStream {
    static Logger log = Log.getLogger(MonitoringInputStream.class);
    private static int KB = 1024;
    private static int counter = 0;
    private InputStream is;
    private int id;
    private int bytesRead = 0;
    private boolean readingNotified = false;

    public MonitoringInputStream(InputStream inputStream) throws IOException {
        this.is = inputStream;
        this.id = counter++;
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.logPrefix() + " opened.");
        }
    }

    public int read() throws IOException {
        int n = -1;
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.logPrefix() + "requesting byte");
            }
            n = this.is.read();
            this.showRead(n);
            if (n != -1) {
                this.countRead(1);
            }
        }
        catch (Throwable throwable) {
            this.rethrow(throwable);
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = -1;
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.logPrefix() + "requesting " + n2 + " bytes");
            }
            n3 = this.is.read(byArray, n, n2);
            this.showRead(byArray, n, n2, n3);
            if (n3 > 0) {
                this.countRead(n3);
            }
        }
        catch (Throwable throwable) {
            this.rethrow(throwable);
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2 = -1L;
        try {
            l2 = this.is.skip(l);
            if (l2 > 0L) {
                this.countRead((int)l2);
            }
        }
        catch (Throwable throwable) {
            this.rethrow(throwable);
        }
        return l2;
    }

    public void close() throws IOException {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.logPrefix() + "closing");
            }
            this.readingNotified = false;
            this.is.close();
        }
        catch (Throwable throwable) {
            this.rethrow(throwable);
        }
    }

    private void showRead(byte[] byArray, int n, int n2, int n3) {
        if (log.isLoggable(Level.FINER) && n2 != n3) {
            log.finer(this.logPrefix() + "asked for " + n2 + " bytes and received " + n3);
        }
        if (log.isLoggable(Level.FINEST)) {
            StringBuffer stringBuffer = new StringBuffer(this.logPrefix());
            stringBuffer.append("bytes read: ");
            for (int i = n; i < n + n3; ++i) {
                stringBuffer.append(byArray[i]);
                stringBuffer.append(" ");
            }
            log.finest(stringBuffer.toString());
        }
    }

    private void showRead(int n) {
        if (log.isLoggable(Level.FINE) && n < 0) {
            log.fine(this.logPrefix() + "End of Stream read");
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this.logPrefix() + " byte read " + (byte)n + " : " + n);
        }
    }

    private synchronized void countRead(int n) {
        int n2;
        if (log.isLoggable(Level.FINER) && !this.readingNotified) {
            log.finer(this.logPrefix() + "reading");
            this.readingNotified = true;
        }
        int n3 = this.bytesRead / (KB * KB);
        this.bytesRead += n;
        if (log.isLoggable(Level.FINE) && (n2 = this.bytesRead / (KB * KB)) > n3) {
            log.fine(this.logPrefix() + n2 + " megabytes read");
        }
    }

    private String logPrefix() {
        return "InputStream " + this.id + ": ";
    }

    private void rethrow(Throwable throwable) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Exception caught", throwable);
        }
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        IOException iOException = new IOException(throwable.getMessage());
        iOException.initCause(throwable);
        throw iOException;
    }
}

