/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.exception.ProtegeError;
import edu.stanford.smi.protege.exception.TransactionException;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.storage.database.DatabaseFrameDb;
import edu.stanford.smi.protege.storage.database.RobustConnection;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractDatabaseFrameDb
implements DatabaseFrameDb {
    public static Logger log = Log.getLogger(AbstractDatabaseFrameDb.class);
    public static final String SLOW_QUERY_PROPERTY = "slow.jdbc.query.milliseconds";
    private static final int slowQueryTime = ApplicationProperties.getIntegerProperty("slow.jdbc.query.milliseconds", 15000);
    private static int traceCount = 0;
    protected final Map<RemoteSession, RobustConnection> _connections = new HashMap<RemoteSession, RobustConnection>();
    protected String _driver;
    protected FrameFactory _frameFactory;
    protected boolean _isInclude;
    protected String _password;
    protected String _table;
    protected String _url;
    protected String _user;
    private String frameDbName;
    private TransactionMonitor transactionMonitor;

    private static void traceUpdate(PreparedStatement preparedStatement, Level level) {
        AbstractDatabaseFrameDb.traceUpdate(preparedStatement, "", level);
    }

    private static void traceUpdate(PreparedStatement preparedStatement, String string, Level level) {
        if (log.isLoggable(level)) {
            AbstractDatabaseFrameDb.trace(preparedStatement, string, level);
        }
    }

    private static void traceQuery(PreparedStatement preparedStatement, Level level) {
        if (log.isLoggable(level)) {
            AbstractDatabaseFrameDb.trace(preparedStatement, "", level);
        }
    }

    private static void trace(PreparedStatement preparedStatement, String string, Level level) {
        if (log.isLoggable(level)) {
            int n;
            String string2 = preparedStatement.toString();
            if (string2.indexOf("PreparedStatement") != -1 && (n = string2.indexOf(32)) != -1) {
                string2 = string2.substring(n);
            }
            AbstractDatabaseFrameDb.trace(string2 + string, level);
        }
    }

    private static void trace(String string, Level level) {
        if (log.isLoggable(level)) {
            log.log(level, ++traceCount + " SQL: " + string);
        }
    }

    private static void traceQuery(String string, Level level) {
        if (log.isLoggable(level)) {
            AbstractDatabaseFrameDb.trace(string, level);
        }
    }

    private static void traceUpdate(String string, Level level) {
        if (log.isLoggable(level)) {
            AbstractDatabaseFrameDb.trace(string, level);
        }
    }

    protected static ResultSet executeQuery(PreparedStatement preparedStatement) throws SQLException {
        Level level = Level.FINER;
        AbstractDatabaseFrameDb.traceQuery(preparedStatement, level);
        long l = System.nanoTime();
        ResultSet resultSet = preparedStatement.executeQuery();
        double d = (double)(System.nanoTime() - l) / 1000000.0;
        if (d > (double)slowQueryTime) {
            if (!log.isLoggable(level)) {
                AbstractDatabaseFrameDb.traceQuery(preparedStatement, Level.INFO);
            }
            log.info("*** SLOW QUERY: " + d + " msec ***");
        } else if (log.isLoggable(level)) {
            log.log(level, "Query took " + d + " milliseconds (more or less)");
        }
        return resultSet;
    }

    protected static int executeUpdate(PreparedStatement preparedStatement) throws SQLException {
        Level level = Level.FINE;
        AbstractDatabaseFrameDb.traceUpdate(preparedStatement, level);
        long l = System.nanoTime();
        int n = preparedStatement.executeUpdate();
        double d = (double)(System.nanoTime() - l) / 1000000.0;
        if (d > (double)slowQueryTime) {
            if (!log.isLoggable(level)) {
                AbstractDatabaseFrameDb.traceQuery(preparedStatement, Level.INFO);
            }
            log.info("*** SLOW QUERY: " + d + " msec ***");
        } else if (log.isLoggable(level)) {
            log.log(level, "Query took " + d + " milliseconds (more or less)");
        }
        return n;
    }

    private static boolean isDead(RemoteSession remoteSession) {
        return remoteSession != null && !Server.getInstance().isActive(remoteSession);
    }

    protected static boolean isNullValue(Object object) {
        boolean bl;
        boolean bl2 = bl = object == null;
        if (object instanceof String) {
            String string = (String)object;
            bl = string.trim().length() == 0;
        }
        return bl;
    }

    public boolean beginTransaction(String string) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("begin transaction " + string);
        }
        try {
            boolean bl = this.getCurrentConnection().beginTransaction();
            return bl;
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    private void clearDeadConnections() throws SQLException {
        Iterator<Map.Entry<RemoteSession, RobustConnection>> iterator = this._connections.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<RemoteSession, RobustConnection> entry = iterator.next();
            RemoteSession remoteSession = entry.getKey();
            if (!AbstractDatabaseFrameDb.isDead(remoteSession)) continue;
            RobustConnection robustConnection = entry.getValue();
            robustConnection.dispose();
            iterator.remove();
        }
    }

    public void close() {
        this._frameFactory = null;
        try {
            for (Map.Entry<RemoteSession, RobustConnection> entry : this._connections.entrySet()) {
                RemoteSession remoteSession = entry.getKey();
                RobustConnection robustConnection = entry.getValue();
                robustConnection.dispose();
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("Closed DB connection for session: " + remoteSession);
            }
            this._connections.clear();
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    public boolean commitTransaction() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("commit transaction");
        }
        try {
            return this.getCurrentConnection().commitTransaction();
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    protected RobustConnection createConnection() throws SQLException {
        this.clearDeadConnections();
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        RobustConnection robustConnection = new RobustConnection(this._driver, this._url, this._user, this._password, this.getTransactionStatusMonitor(), remoteSession);
        this._connections.put(remoteSession, robustConnection);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Created connection for " + remoteSession);
        }
        return robustConnection;
    }

    protected RuntimeException createRuntimeException(SQLException sQLException) {
        try {
            if (this.getCurrentConnection() != null) {
                this.getCurrentConnection().checkConnection();
            }
        }
        catch (SQLException sQLException2) {
            // empty catch block
        }
        log.info(Log.toString(sQLException));
        RuntimeException runtimeException = new RuntimeException(sQLException.getMessage());
        runtimeException.initCause(sQLException);
        return runtimeException;
    }

    public RobustConnection getCurrentConnection() throws SQLException {
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        RobustConnection robustConnection = this._connections.get(remoteSession);
        if (robustConnection == null) {
            robustConnection = this.createConnection();
            this._connections.put(remoteSession, robustConnection);
        }
        return robustConnection;
    }

    public FrameFactory getFrameFactory() {
        return this._frameFactory;
    }

    public String getName() {
        return this.frameDbName;
    }

    public TransactionMonitor getTransactionStatusMonitor() {
        if (this.transactionMonitor == null) {
            this.transactionMonitor = new TransactionMonitor(){

                public TransactionIsolationLevel getTransationIsolationLevel() throws TransactionException {
                    int n = 0;
                    RobustConnection robustConnection = null;
                    try {
                        robustConnection = AbstractDatabaseFrameDb.this.getCurrentConnection();
                        n = robustConnection.getTransactionIsolationLevel();
                    }
                    catch (SQLException sQLException) {
                        throw new TransactionException(sQLException);
                    }
                    finally {
                        robustConnection.setIdle(true);
                    }
                    return TransactionIsolationLevel.getTransactionLevel(n);
                }

                public void setTransactionIsolationLevel(TransactionIsolationLevel transactionIsolationLevel) throws TransactionException {
                    int n = transactionIsolationLevel.getJdbcLevel();
                    RobustConnection robustConnection = null;
                    try {
                        robustConnection = AbstractDatabaseFrameDb.this.getCurrentConnection();
                        if (robustConnection != null) {
                            robustConnection.setTransactionIsolationLevel(n);
                        }
                    }
                    catch (SQLException sQLException) {
                        throw new TransactionException(sQLException);
                    }
                    finally {
                        robustConnection.setIdle(true);
                    }
                }
            };
        }
        return this.transactionMonitor;
    }

    public void initialize(FrameFactory frameFactory, String string, String string2, String string3, String string4, String string5, boolean bl) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Constructing database frame narrow frame store for " + string + " " + string2 + " " + string5);
            log.fine("No delegates");
        }
        this._isInclude = bl;
        this._table = string5;
        this._frameFactory = frameFactory;
        this._driver = string;
        this._url = string2;
        this._user = string3;
        this._password = string4;
        try {
            this.createConnection();
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    public boolean rollbackTransaction() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("roll back transaction");
        }
        try {
            return this.getCurrentConnection().rollbackTransaction();
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    public void setName(String string) {
        this.frameDbName = string;
    }

    public String getTableName() {
        return this._table;
    }

    protected ResultSet executeQuery(String string) throws SQLException {
        return this.executeQuery(string, 0);
    }

    protected ResultSet executeQuery(String string, int n) throws SQLException {
        Level level = Level.FINER;
        AbstractDatabaseFrameDb.traceQuery(string, level);
        Statement statement = this.getCurrentConnection().getStatement();
        long l = System.nanoTime();
        ResultSet resultSet = statement.executeQuery(string);
        double d = (double)(System.nanoTime() - l) / 1000000.0;
        if (d > (double)slowQueryTime) {
            if (!log.isLoggable(level)) {
                AbstractDatabaseFrameDb.traceQuery(string, Level.INFO);
            }
            log.info("*** SLOW QUERY: " + d + " msec ***");
        } else if (log.isLoggable(level)) {
            log.log(level, "Query took " + d + " milliseconds (more or less)");
        }
        return resultSet;
    }

    protected int executeUpdate(String string) throws SQLException {
        Level level = Level.FINE;
        AbstractDatabaseFrameDb.traceUpdate(string, level);
        long l = System.nanoTime();
        int n = this.getCurrentConnection().getStatement().executeUpdate(string);
        double d = (double)(System.nanoTime() - l) / 1000000.0;
        if (log.isLoggable(level)) {
            log.log(level, "Query took " + d + " milliseconds (more or less)");
        }
        return n;
    }

    public void executeQuery(Query query, final QueryCallback queryCallback) {
        new Thread(new Runnable(){

            public void run() {
                queryCallback.handleError(new ProtegeError("Not implemented yet"));
            }
        }, "Vacuous Callback Results Thread");
    }
}

