/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.FrameSlotCombination;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.Log;
import java.util.Collection;
import javax.swing.Icon;

public class SlotPairRenderer
extends DefaultRenderer
implements Cloneable {
    private static final long serialVersionUID = -4381654272891062203L;
    private static SlotPairRenderer _prototypeInstance = new SlotPairRenderer();

    public static SlotPairRenderer createInstance() {
        SlotPairRenderer slotPairRenderer;
        try {
            slotPairRenderer = (SlotPairRenderer)_prototypeInstance.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Log.getLogger().warning(cloneNotSupportedException.toString());
            slotPairRenderer = _prototypeInstance;
        }
        return slotPairRenderer;
    }

    public void load(Object object) {
        FrameSlotCombination frameSlotCombination = (FrameSlotCombination)object;
        Cls cls = (Cls)frameSlotCombination.getFrame();
        Slot slot = frameSlotCombination.getSlot();
        String string = slot.getBrowserText();
        boolean bl = !cls.hasDirectTemplateSlot(slot);
        boolean bl2 = !cls.isEditable() || !slot.isEditable();
        boolean bl3 = cls.hasDirectlyOverriddenTemplateSlot(slot);
        boolean bl4 = !slot.isVisible();
        Icon icon = Icons.getSlotIcon(bl, bl3, bl2, bl4);
        this.setMainText(string);
        this.setMainIcon(icon);
        this.setBackgroundSelectionColor(Colors.getSlotSelectionColor());
    }

    public String getToolTipText() {
        FrameSlotCombination frameSlotCombination = (FrameSlotCombination)this.getValue();
        Cls cls = (Cls)frameSlotCombination.getFrame();
        Slot slot = frameSlotCombination.getSlot();
        StringBuffer stringBuffer = new StringBuffer();
        SlotPairRenderer.appendInheritanceInformation(cls, slot, stringBuffer);
        SlotPairRenderer.appendFacetOverrideInformation(cls, slot, stringBuffer);
        String string = stringBuffer.length() == 0 ? null : "<html>" + stringBuffer.toString() + "</html>";
        return string;
    }

    private static void appendInheritanceInformation(Cls cls, Slot slot, StringBuffer stringBuffer) {
        if (!cls.hasDirectTemplateSlot(slot)) {
            stringBuffer.append("<b>");
            stringBuffer.append(slot.getBrowserText());
            stringBuffer.append("</b> is inherited from ");
            boolean bl = true;
            for (Cls cls2 : cls.getSuperclasses()) {
                if (!cls2.hasDirectTemplateSlot(slot)) continue;
                if (!bl) {
                    stringBuffer.append(" and ");
                }
                stringBuffer.append("<b>");
                stringBuffer.append(cls2.getBrowserText());
                stringBuffer.append("</b>");
                bl = false;
            }
        }
    }

    private static void appendFacetOverrideInformation(Cls cls, Slot slot, StringBuffer stringBuffer) {
        Collection collection = cls.getDirectlyOverriddenTemplateFacets(slot);
        if (!collection.isEmpty()) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append("<br>");
            }
            for (Facet facet : collection) {
                stringBuffer.append("<b>");
                stringBuffer.append(facet.getBrowserText());
                stringBuffer.append("</b> is directly overridden");
                stringBuffer.append("</br>");
            }
        }
    }

    public static void setPrototypeInstance(SlotPairRenderer slotPairRenderer) {
        _prototypeInstance = slotPairRenderer;
    }
}

