/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.exception.ProtegeException;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.ServerProject;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MultiplexingClassLoader;
import edu.stanford.smi.protege.util.RemoteJob;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ProtegeJob
extends RemoteJob
implements Localizable,
Serializable {
    private static final long serialVersionUID = -3178401391384077767L;
    private static transient Logger log = Log.getLogger(ProtegeJob.class);
    private transient KnowledgeBase kb;
    private transient RemoteClientFrameStore clientFrameStore = null;

    public ProtegeJob(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
        DefaultKnowledgeBase defaultKnowledgeBase = (DefaultKnowledgeBase)knowledgeBase;
        FrameStore frameStore = defaultKnowledgeBase.getTerminalFrameStore();
        if (frameStore instanceof RemoteClientFrameStore) {
            this.clientFrameStore = (RemoteClientFrameStore)frameStore;
        }
    }

    public Object execute() throws ProtegeException {
        if (this.clientFrameStore == null) {
            return this.run();
        }
        return this.clientFrameStore.executeProtegeJob(this);
    }

    public KnowledgeBase getKnowledgeBase() {
        return this.kb;
    }

    public void fixLoader() {
        ClassLoader classLoader;
        ClassLoader classLoader2;
        ClassLoader classLoader3 = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader4 = this.getClass().getClassLoader();
        if (classLoader4 == (classLoader2 = this.kb.getClass().getClassLoader())) {
            classLoader = classLoader4;
        } else {
            ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>();
            arrayList.add(classLoader2);
            arrayList.add(classLoader4);
            classLoader = new MultiplexingClassLoader(arrayList);
        }
        if (classLoader3 != classLoader) {
            if (log.isLoggable(Level.FINEST)) {
                Log.getLogger().finest("Changing loader from " + classLoader3 + " to " + classLoader);
            }
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public ProjectInstance getMetaProjectInstance() {
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        ServerProject serverProject = Server.getInstance().getServerProject(this.getKnowledgeBase().getProject());
        ServerFrameStore serverFrameStore = (ServerFrameStore)serverProject.getDomainKbFrameStore(remoteSession);
        return serverFrameStore.getMetaProjectInstance();
    }

    public boolean serverSideCheckOperationAllowed(Operation operation) {
        return this.serverSideCheckOperationAllowed(operation, this.getMetaProjectInstance());
    }

    public void localize(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
    }
}

