/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.AbstractFacetConstraint;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.CollectionUtilities;
import java.util.Collection;
import java.util.Iterator;

public class NumericMaximumConstraint
extends AbstractFacetConstraint {
    private static final long serialVersionUID = 8433560444246377129L;

    public String getInvalidValuesText(Frame frame, Slot slot, Collection collection, Collection collection2) {
        String string = null;
        Number number = (Number)CollectionUtilities.getFirstItem(collection2);
        if (number != null) {
            double d = number.doubleValue();
            Iterator iterator = collection.iterator();
            while (string == null && iterator.hasNext()) {
                Object e = iterator.next();
                string = NumericMaximumConstraint.getInvalidValueText(d, e);
            }
        }
        return string;
    }

    private static String getInvalidValueText(double d, Object object) {
        Number number;
        String string = null;
        if (object instanceof Number && (number = (Number)object).doubleValue() > d) {
            string = "The maximum value is " + d;
        }
        return string;
    }

    public String getInvalidValueText(Frame frame, Slot slot, Object object, Collection collection) {
        String string = null;
        Number number = (Number)CollectionUtilities.getFirstItem(collection);
        if (number != null) {
            double d = number.doubleValue();
            string = NumericMaximumConstraint.getInvalidValueText(d, object);
        }
        return string;
    }

    public Collection resolve(Collection collection, Collection collection2) {
        double d;
        double d2 = NumericMaximumConstraint.getValue(collection);
        return d2 < (d = NumericMaximumConstraint.getValue(collection2)) ? collection : collection2;
    }

    private static double getValue(Collection collection) {
        Number number = (Number)CollectionUtilities.getFirstItem(collection);
        return number == null ? Double.MAX_VALUE : number.doubleValue();
    }
}

