/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.EventGeneratorFrameStore;
import edu.stanford.smi.protege.model.framestore.EventSinkFrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStoreManager;
import edu.stanford.smi.protege.model.framestore.FrameStore_Test;
import edu.stanford.smi.protege.model.framestore.InMemoryFrameStore;
import edu.stanford.smi.protege.util.AbstractEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventGeneratorFrameStore_Test
extends FrameStore_Test {
    private KnowledgeBase _kb;
    private int nameCounter = 0;

    @Override
    protected FrameStore createFrameStore(DefaultKnowledgeBase defaultKnowledgeBase) {
        this._kb = defaultKnowledgeBase;
        EventGeneratorFrameStore eventGeneratorFrameStore = new EventGeneratorFrameStore(defaultKnowledgeBase);
        eventGeneratorFrameStore.setDelegate(new InMemoryFrameStore(defaultKnowledgeBase));
        return eventGeneratorFrameStore;
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this._kb = null;
    }

    private boolean containsSimilarEvent(List<EventObject> list, AbstractEvent abstractEvent) {
        for (EventObject eventObject : list) {
            if (eventObject instanceof AbstractEvent) {
                abstractEvent.setTimeStamp(((AbstractEvent)eventObject).getTimeStamp());
            }
            if (!eventObject.equals(abstractEvent)) continue;
            return true;
        }
        return false;
    }

    private boolean isSimilarEvent(EventObject eventObject, AbstractEvent abstractEvent) {
        if (eventObject instanceof AbstractEvent) {
            abstractEvent.setTimeStamp(((AbstractEvent)eventObject).getTimeStamp());
        }
        return eventObject.equals(abstractEvent);
    }

    public String createName() {
        return "frameName" + this.nameCounter++;
    }

    public void testCreateClsEvent() {
        Cls cls = this._kb.getRootCls();
        Cls cls2 = this._kb.getCls(":STANDARD-CLASS");
        Slot slot = this._kb.getSlot(":DIRECT-SUBCLASSES");
        Slot slot2 = this._kb.getSlot(":DIRECT-INSTANCES");
        Cls cls3 = this.createCls();
        List<EventObject> list = this.getTestFrameStore().getEvents();
        EventGeneratorFrameStore_Test.assertTrue((boolean)this.containsSimilarEvent(list, new KnowledgeBaseEvent(this._kb, 601, cls3)));
        EventGeneratorFrameStore_Test.assertTrue((boolean)this.containsSimilarEvent(list, new ClsEvent(cls, 303, (Object)cls3)));
        EventGeneratorFrameStore_Test.assertTrue((boolean)this.containsSimilarEvent(list, new FrameEvent(cls, 110, (Object)slot)));
        EventGeneratorFrameStore_Test.assertTrue((boolean)this.containsSimilarEvent(list, new ClsEvent(cls2, 305, (Object)cls3)));
        EventGeneratorFrameStore_Test.assertTrue((boolean)this.containsSimilarEvent(list, new FrameEvent(cls2, 110, (Object)slot2, null)));
    }

    public void testAddSuperclassEvent() {
        Cls cls = this.createCls();
        Cls cls2 = this.createCls();
        this.getTestFrameStore().getEvents();
        this.getTestFrameStore().addDirectSuperclass(cls, cls2);
        List<AbstractEvent> list = this.getTestFrameStore().getEvents();
        ClsEvent clsEvent = new ClsEvent(cls, 301, (Object)cls2);
        ClsEvent clsEvent2 = new ClsEvent(cls2, 303, (Object)cls);
        EventGeneratorFrameStore_Test.assertTrue((String)"kb event", (boolean)this.isSimilarEvent(list.get(0), clsEvent));
        EventGeneratorFrameStore_Test.assertTrue((String)"kb event", (boolean)this.isSimilarEvent(list.get(1), clsEvent2));
    }

    public void testDeleteClsEvents() {
        Cls cls = this.createCls();
        KnowledgeBaseEvent knowledgeBaseEvent = new KnowledgeBaseEvent(this._kb, 602, cls, (Object)cls.getName());
        this.getTestFrameStore().getEvents();
        this.getTestFrameStore().deleteCls(cls);
        List<EventObject> list = this.getTestFrameStore().getEvents();
        EventGeneratorFrameStore_Test.assertTrue((boolean)this.containsSimilarEvent(list, knowledgeBaseEvent));
    }

    public void testProperlyConfigured() {
        ArrayList arrayList = new ArrayList();
        Project project = new Project("junit/pprj/metaproject.pprj", arrayList);
        EventGeneratorFrameStore_Test.assertTrue((boolean)arrayList.isEmpty());
        EventGeneratorFrameStore_Test.assertFalse((boolean)project.isMultiUserClient());
        EventGeneratorFrameStore_Test.assertFalse((boolean)project.isMultiUserServer());
        FrameStoreManager frameStoreManager = project.getKnowledgeBase().getFrameStoreManager();
        EventGeneratorFrameStore_Test.assertNotNull((Object)frameStoreManager.getFrameStoreFromClass(EventGeneratorFrameStore.class));
        EventGeneratorFrameStore_Test.assertNull((Object)frameStoreManager.getFrameStoreFromClass(EventSinkFrameStore.class));
        project.dispose();
    }
}

