/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.SystemFrames;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.util.AbstractEvent;
import edu.stanford.smi.protege.util.CacheMap;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SimpleStringMatcher;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFrameStore
implements FrameStore {
    private KnowledgeBase _kb;
    private SystemFrames _systemFrames;
    private NarrowFrameStore _helper;
    private Set<Slot> _inheritedSuperslotSlots = new HashSet<Slot>();
    private CacheMap<String, Frame> nameToFrameMap = new CacheMap();

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    public SimpleFrameStore(KnowledgeBase knowledgeBase, NarrowFrameStore narrowFrameStore) {
        this.setHelper(narrowFrameStore);
        if (knowledgeBase != null) {
            this._kb = knowledgeBase;
            this._systemFrames = knowledgeBase.getSystemFrames();
            this.loadInheritedSuperslotSlots();
        }
    }

    private void loadInheritedSuperslotSlots() {
        this._inheritedSuperslotSlots.add(this._systemFrames.getDirectDomainSlot());
        this._inheritedSuperslotSlots.add(this._systemFrames.getValueTypeSlot());
        this._inheritedSuperslotSlots.add(this._systemFrames.getMaximumCardinalitySlot());
        this._inheritedSuperslotSlots.add(this._systemFrames.getMinimumValueSlot());
        this._inheritedSuperslotSlots.add(this._systemFrames.getMaximumValueSlot());
    }

    @Override
    public void reinitialize() {
        this.nameToFrameMap.clear();
        this._helper.reinitialize();
    }

    public void setHelper(NarrowFrameStore narrowFrameStore) {
        this._helper = narrowFrameStore;
    }

    public NarrowFrameStore getHelper() {
        return this._helper;
    }

    @Override
    public void executeQuery(Query query, QueryCallback queryCallback) {
        this._helper.executeQuery(query, queryCallback);
    }

    @Override
    public void deleteCls(Cls cls) {
        this.deleteFrame(cls);
    }

    public static Collection<Cls> getClsesToBeDeleted(Cls cls, FrameStore frameStore) {
        Set<Cls> set = frameStore.getSubclasses(cls);
        HashSet<Cls> hashSet = new HashSet<Cls>(set);
        hashSet.add(cls);
        for (Cls cls2 : set) {
            if (cls2.equals(cls) || !SimpleFrameStore.reachableByAnotherRoute(cls2, hashSet, frameStore)) continue;
            hashSet.remove(cls2);
            HashSet<Cls> hashSet2 = new HashSet<Cls>(frameStore.getSubclasses(cls2));
            hashSet2.remove(cls);
            hashSet.removeAll(hashSet2);
        }
        return hashSet;
    }

    private static boolean reachableByAnotherRoute(Cls cls, Collection collection, FrameStore frameStore) {
        boolean bl = false;
        List<Cls> list = frameStore.getDirectSuperclasses(cls);
        if (list.size() > 1) {
            for (Cls cls2 : list) {
                if (collection.contains(cls2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    @Override
    public void deleteSlot(Slot slot) {
        this.deleteFrame(slot);
    }

    @Override
    public void deleteFacet(Facet facet) {
        this.deleteFrame(facet);
    }

    @Override
    public void deleteSimpleInstance(SimpleInstance simpleInstance) {
        this.deleteFrame(simpleInstance);
    }

    private void deleteFrame(Frame frame) {
        this.nameToFrameMap.remove(this.getFrameName(frame));
        this._helper.deleteFrame(frame);
    }

    @Override
    public Set<Reference> getReferences(Object object) {
        Set<Reference> set = this._helper.getReferences(object);
        return SimpleFrameStore.unmodifiableSet(set);
    }

    @Override
    public void close() {
        this._kb = null;
        this._systemFrames = null;
        this._helper.close();
        this._helper = null;
    }

    @Override
    public Set<Reference> getMatchingReferences(String string, int n) {
        return this._helper.getMatchingReferences(string, n);
    }

    @Override
    public Set<Cls> getClsesWithMatchingBrowserText(String string, Collection collection, int n) {
        SimpleStringMatcher simpleStringMatcher = new SimpleStringMatcher(string);
        HashSet<Cls> hashSet = new HashSet<Cls>();
        Set<Reference> set = this._helper.getMatchingReferences(string, -1);
        for (Reference reference : set) {
            Cls cls;
            Frame frame = reference.getFrame();
            if (!(frame instanceof Cls) || !simpleStringMatcher.isMatch((cls = (Cls)frame).getBrowserText()) || !SimpleFrameStore.isSubclassMatch(cls, collection)) continue;
            hashSet.add(cls);
            if (n == -1 || hashSet.size() != n) continue;
            break;
        }
        return hashSet;
    }

    private static boolean isSubclassMatch(Cls cls, Collection collection) {
        boolean bl = true;
        if (!collection.isEmpty()) {
            HashSet hashSet = new HashSet(cls.getSuperclasses());
            bl = hashSet.removeAll(collection);
        }
        return bl;
    }

    private FrameFactory getFrameFactory() {
        return this._kb.getFrameFactory();
    }

    @Override
    public int getClsCount() {
        return this._helper.getClsCount();
    }

    @Override
    public int getSlotCount() {
        return this._helper.getSlotCount();
    }

    @Override
    public int getFacetCount() {
        return this._helper.getFacetCount();
    }

    @Override
    public int getSimpleInstanceCount() {
        return this._helper.getSimpleInstanceCount();
    }

    @Override
    public int getFrameCount() {
        return this._helper.getFrameCount();
    }

    @Override
    public Set<Cls> getClses() {
        return this.getInstances(this._systemFrames.getRootClsMetaCls());
    }

    @Override
    public Set<Slot> getSlots() {
        return this.getInstances(this._systemFrames.getRootSlotMetaCls());
    }

    @Override
    public Set<Facet> getFacets() {
        return this.getInstances(this._systemFrames.getRootFacetMetaCls());
    }

    @Override
    public Set<Frame> getFrames() {
        return this._helper.getFrames();
    }

    @Override
    public List getDirectTemplateSlots(Cls cls) {
        return this.getDirectOwnSlotValues(cls, this._systemFrames.getDirectTemplateSlotsSlot());
    }

    @Override
    public List<Cls> getDirectSuperclasses(Cls cls) {
        return this.getDirectOwnSlotValues(cls, this._systemFrames.getDirectSuperclassesSlot());
    }

    @Override
    public List getDirectSuperslots(Slot slot) {
        return this.getDirectOwnSlotValues(slot, this._systemFrames.getDirectSuperslotsSlot());
    }

    @Override
    public List getDirectSubslots(Slot slot) {
        return this.getDirectOwnSlotValues(slot, this._systemFrames.getDirectSubslotsSlot());
    }

    @Override
    public Set getSuperslots(Slot slot) {
        return this.getDirectOwnSlotValuesClosure(slot, this._systemFrames.getDirectSuperslotsSlot());
    }

    @Override
    public Set getSubslots(Slot slot) {
        return this.getDirectOwnSlotValuesClosure(slot, this._systemFrames.getDirectSubslotsSlot());
    }

    @Override
    public Set getSuperclasses(Cls cls) {
        return this.getDirectOwnSlotValuesClosure(cls, this._systemFrames.getDirectSuperclassesSlot());
    }

    @Override
    public List<Cls> getDirectSubclasses(Cls cls) {
        return this.getDirectOwnSlotValues(cls, this._systemFrames.getDirectSubclassesSlot());
    }

    @Override
    public Set<Cls> getSubclasses(Cls cls) {
        return this.getDirectOwnSlotValuesClosure(cls, this._systemFrames.getDirectSubclassesSlot());
    }

    @Override
    public Set<Facet> getTemplateFacets(Cls cls, Slot slot) {
        Set<Slot> set = this.getOwnSlots(slot);
        Set set2 = this.collectOwnSlotValues(set, this._systemFrames.getAssociatedFacetSlot());
        return SimpleFrameStore.unmodifiableSet(set2);
    }

    @Override
    public Collection getTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        Collection collection;
        Instance instance2;
        Collection collection2 = new ArrayList(this.getDirectTemplateFacetValues(cls, slot, facet));
        for (Instance instance2 : this.getSuperclasses(cls)) {
            collection = this.getDirectTemplateFacetValues((Cls)instance2, slot, facet);
            collection2 = SimpleFrameStore.resolveValues(collection2, collection, facet);
        }
        instance2 = (Slot)this.getDirectOwnSlotValue(facet, this._systemFrames.getAssociatedSlotSlot());
        if (instance2 != null) {
            collection = this.getOwnSlotValues(slot, (Slot)instance2);
            collection2 = SimpleFrameStore.resolveValues(collection2, collection, facet);
        }
        return SimpleFrameStore.unmodifiableCollection(collection2);
    }

    private static Collection resolveValues(Collection arrayList, Collection collection, Facet facet) {
        if (!collection.isEmpty()) {
            if (arrayList.isEmpty()) {
                arrayList.addAll(collection);
            } else if ((arrayList = facet.resolveValues(arrayList, collection)) == collection) {
                arrayList = new ArrayList(arrayList);
            }
        }
        return arrayList;
    }

    @Override
    public Collection getTemplateSlotValues(Cls cls, Slot slot) {
        return this.getTemplateFacetValues(cls, slot, this._systemFrames.getValuesFacet());
    }

    @Override
    public Set getDirectOwnSlotValuesClosure(Frame frame, Slot slot) {
        Set set = this.getValuesClosure(frame, slot, null, false);
        return SimpleFrameStore.unmodifiableSet(set);
    }

    private Set getValuesClosure(Frame frame, Slot slot, Facet facet, boolean bl) {
        return this.getValuesClosure(frame, slot, facet, bl, slot);
    }

    private Set getValuesClosure(Frame frame, Slot slot, Facet facet, boolean bl, Slot slot2) {
        HashSet hashSet;
        HashSet hashSet2 = this._helper.getClosure(frame, slot2, null, false);
        if (SimpleFrameStore.equals(slot, slot2) && facet == null && !bl) {
            hashSet = hashSet2;
        } else {
            hashSet = new HashSet(this.getValues(frame, slot, facet, bl));
            for (Frame frame2 : hashSet2) {
                hashSet.addAll(this.getValues(frame2, slot, facet, bl));
            }
        }
        return hashSet;
    }

    public static boolean equals(Object object, Object object2) {
        return SystemUtilities.equals(object, object2);
    }

    @Override
    public List getDirectTypes(Instance instance) {
        return this.getDirectOwnSlotValues(instance, this._systemFrames.getDirectTypesSlot());
    }

    @Override
    public List<Instance> getDirectInstances(Cls cls) {
        return this.getDirectOwnSlotValues(cls, this._systemFrames.getDirectInstancesSlot());
    }

    @Override
    public Set<Instance> getInstances(Cls cls) {
        LinkedHashSet<Cls> linkedHashSet = new LinkedHashSet<Cls>(this.getSubclasses(cls));
        linkedHashSet.add(cls);
        return this.collectOwnSlotValues(linkedHashSet, this._systemFrames.getDirectInstancesSlot());
    }

    @Override
    public Set getTypes(Instance instance) {
        List list = this.getDirectTypes(instance);
        LinkedHashSet linkedHashSet = new LinkedHashSet(list);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Cls cls = (Cls)list.get(i);
            linkedHashSet.addAll(this.getSuperclasses(cls));
        }
        return SimpleFrameStore.unmodifiableSet(linkedHashSet);
    }

    private static <X> Set<X> unmodifiableSet(Set<X> set) {
        return set == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(set);
    }

    private static List unmodifiableList(List list) {
        return list == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(list);
    }

    private static Collection unmodifiableCollection(Collection collection) {
        return collection == null ? Collections.EMPTY_LIST : Collections.unmodifiableCollection(collection);
    }

    private Set collectOwnSlotValues(Collection collection, Slot slot) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Object[] objectArray = collection.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Frame frame = (Frame)objectArray[i];
            linkedHashSet.addAll(this.getDirectOwnSlotValues(frame, slot));
        }
        return linkedHashSet;
    }

    @Override
    public Frame getFrame(String string) {
        Frame frame = (Frame)this.nameToFrameMap.get(string);
        if (frame == null && (frame = this.getFrame(new FrameID(string))) != null) {
            this.nameToFrameMap.put(string, frame);
        }
        return frame;
    }

    @Override
    public Frame getFrame(FrameID frameID) {
        return this._helper.getFrame(frameID);
    }

    @Override
    public Set<Slot> getOwnSlots(Frame frame) {
        Set set = this.getTypes((Instance)frame);
        Set set2 = this.collectOwnSlotValues(set, this._systemFrames.getDirectTemplateSlotsSlot());
        HashSet hashSet = new HashSet();
        for (Slot slot : set2) {
            Slot slot2;
            Set set3;
            if (!(slot instanceof Slot) || (set3 = this.getSubslots(slot2 = slot)) == null) continue;
            hashSet.addAll(set3);
        }
        set2.addAll(hashSet);
        set2.add(this._systemFrames.getNameSlot());
        set2.add(this._systemFrames.getDirectTypesSlot());
        return set2;
    }

    @Override
    public Set getTemplateSlots(Cls cls) {
        LinkedHashSet<Cls> linkedHashSet = new LinkedHashSet<Cls>(this.getSuperclasses(cls));
        linkedHashSet.add(cls);
        Set set = this.collectOwnSlotValues(linkedHashSet, this._systemFrames.getDirectTemplateSlotsSlot());
        this.addSubslotsInDomain(set, cls);
        return SimpleFrameStore.unmodifiableSet(set);
    }

    private void addSubslotsInDomain(Collection collection, Cls cls) {
        for (Slot slot : new HashSet(collection)) {
            this.addSubslotsInDomain(slot, cls, collection);
        }
    }

    private void addSubslotsInDomain(Slot slot, Cls cls, Collection collection) {
        for (Slot slot2 : this.getSubslots(slot)) {
            if (!this.isInDomain(slot2, cls)) continue;
            collection.add(slot2);
        }
    }

    private boolean isInDomain(Slot slot, Cls cls) {
        List list = this.getDirectDomain(slot);
        boolean bl = list.isEmpty();
        for (Cls cls2 : list) {
            if (!this.getSuperclasses(cls).contains(cls2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public Set getDomain(Slot slot) {
        Set set = this.getClosure(this.getDirectDomain(slot), this._systemFrames.getDirectSubclassesSlot());
        if (set.isEmpty()) {
            this.addSuperslotsDomain(slot, set);
        }
        return set;
    }

    private void addSuperslotsDomain(Slot slot, Set set) {
        for (Slot slot2 : this.getDirectSuperslots(slot)) {
            set.addAll(this.getDomain(slot2));
        }
    }

    private Set getClosure(Collection collection, Slot slot) {
        HashSet hashSet = new HashSet(collection);
        for (Object e : collection) {
            if (!(e instanceof Instance)) continue;
            Instance instance = (Instance)e;
            hashSet.addAll(this.getDirectOwnSlotValuesClosure(instance, slot));
        }
        return hashSet;
    }

    @Override
    public List getDirectDomain(Slot slot) {
        return this.getDirectOwnSlotValues(slot, this._systemFrames.getDirectDomainSlot());
    }

    @Override
    public void addDirectSuperclass(Cls cls, Cls cls2) {
        this.addDirectOwnSlotValuePair(cls, this._systemFrames.getDirectSuperclassesSlot(), this._systemFrames.getDirectSubclassesSlot(), cls2);
    }

    @Override
    public void removeDirectSuperclass(Cls cls, Cls cls2) {
        this.removeDirectOwnSlotValuePair(cls, this._systemFrames.getDirectSuperclassesSlot(), this._systemFrames.getDirectSubclassesSlot(), cls2);
    }

    @Override
    public void addDirectSuperslot(Slot slot, Slot slot2) {
        this.addDirectOwnSlotValuePair(slot, this._systemFrames.getDirectSuperslotsSlot(), this._systemFrames.getDirectSubslotsSlot(), slot2);
    }

    @Override
    public void removeDirectSuperslot(Slot slot, Slot slot2) {
        this.removeDirectOwnSlotValuePair(slot, this._systemFrames.getDirectSuperslotsSlot(), this._systemFrames.getDirectSubslotsSlot(), slot2);
    }

    @Override
    public void addDirectType(Instance instance, Cls cls) {
        this.addDirectOwnSlotValuePair(instance, this._systemFrames.getDirectTypesSlot(), this._systemFrames.getDirectInstancesSlot(), cls);
        this.swizzleInstance(instance);
    }

    public void swizzleInstance(Instance instance) {
        boolean bl;
        FrameFactory frameFactory = this.getFrameFactory();
        List list = this.getDirectTypes(instance);
        FrameID frameID = instance.getFrameID();
        Class clazz = this.getFrameInterface(list);
        boolean bl2 = bl = clazz == null || clazz.isInstance(instance);
        if (!(bl &= frameFactory.isCorrectJavaImplementationClass(frameID, list, instance.getClass()))) {
            Instance instance2 = clazz.equals(Cls.class) ? frameFactory.createCls(frameID, list) : (clazz.equals(Slot.class) ? frameFactory.createSlot(frameID, list) : (clazz.equals(Facet.class) ? frameFactory.createFacet(frameID, list) : frameFactory.createSimpleInstance(frameID, list)));
            SimpleFrameStore.updateNewInstance(instance2, instance);
            this._helper.replaceFrame(instance2);
            this.nameToFrameMap.put(this.getFrameName(instance2), instance2);
        }
    }

    private Class getFrameInterface(Collection collection) {
        Set set = this.getTypes(collection);
        Class clazz = set.isEmpty() ? null : (set.contains(this._systemFrames.getRootClsMetaCls()) ? Cls.class : (set.contains(this._systemFrames.getRootSlotMetaCls()) ? Slot.class : (set.contains(this._systemFrames.getRootFacetMetaCls()) ? Facet.class : SimpleInstance.class)));
        return clazz;
    }

    private Set getTypes(Collection collection) {
        HashSet hashSet = new HashSet(collection);
        for (Cls cls : collection) {
            hashSet.addAll(this.getSuperclasses(cls));
        }
        return hashSet;
    }

    private static void updateNewInstance(Instance instance, Instance instance2) {
        instance.setEditable(instance2.isEditable());
        instance.setIncluded(instance2.isIncluded());
    }

    private void addDirectOwnSlotValuePair(Frame frame, Slot slot, Slot slot2, Frame frame2) {
        this.addDirectOwnSlotValue(frame, slot, frame2);
        this.addDirectOwnSlotValue(frame2, slot2, frame);
    }

    private void removeDirectOwnSlotValuePair(Frame frame, Slot slot, Slot slot2, Frame frame2) {
        this.removeDirectOwnSlotValue(frame, slot, frame2);
        this.removeDirectOwnSlotValue(frame2, slot2, frame);
    }

    @Override
    public void removeDirectType(Instance instance, Cls cls) {
        this.removeDirectOwnSlotValuePair(instance, this._systemFrames.getDirectTypesSlot(), this._systemFrames.getDirectInstancesSlot(), cls);
        this.swizzleInstance(instance);
    }

    @Override
    public void moveDirectType(Instance instance, Cls cls, int n) {
        int n2 = this.getDirectTypes(instance).indexOf(cls);
        this.moveDirectOwnSlotValue(instance, this._systemFrames.getDirectTypesSlot(), n2, n);
    }

    @Override
    public void moveDirectSubclass(Cls cls, Cls cls2, int n) {
        int n2 = this.getDirectSubclasses(cls).indexOf(cls2);
        this.moveDirectOwnSlotValue(cls, this._systemFrames.getDirectSubclassesSlot(), n2, n);
    }

    @Override
    public void moveDirectSubslot(Slot slot, Slot slot2, int n) {
        int n2 = this.getDirectSubslots(slot).indexOf(slot2);
        this.moveDirectOwnSlotValue(slot, this._systemFrames.getDirectSubslotsSlot(), n2, n);
    }

    @Override
    public void addDirectTemplateSlot(Cls cls, Slot slot) {
        this.addDirectOwnSlotValuePair(cls, this._systemFrames.getDirectTemplateSlotsSlot(), this._systemFrames.getDirectDomainSlot(), slot);
    }

    @Override
    public void moveDirectTemplateSlot(Cls cls, Slot slot, int n) {
        int n2 = this.getDirectTemplateSlots(cls).indexOf(slot);
        this.moveDirectOwnSlotValue(cls, this._systemFrames.getDirectTemplateSlotsSlot(), n2, n);
    }

    @Override
    public void removeDirectTemplateSlot(Cls cls, Slot slot) {
        this.removeDirectOwnSlotValuePair(cls, this._systemFrames.getDirectTemplateSlotsSlot(), this._systemFrames.getDirectDomainSlot(), slot);
    }

    public void addDirectOwnSlotValue(Frame frame, Slot slot, Object object) {
        this.addDirectOwnSlotValues(frame, slot, Collections.singleton(object));
    }

    public void removeDirectOwnSlotValue(Frame frame, Slot slot, Object object) {
        this._helper.removeValue(frame, slot, null, false, object);
    }

    @Override
    public void moveDirectOwnSlotValue(Frame frame, Slot slot, int n, int n2) {
        this._helper.moveValue(frame, slot, null, false, n, n2);
    }

    public void addDirectOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        this.addValues(frame, slot, null, false, collection);
    }

    private void addValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        this._helper.addValues(frame, slot, facet, bl, collection);
    }

    @Override
    public Cls createCls(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        Cls cls = this.createCls(frameID, collection);
        this.addCls(cls, collection, collection2, bl);
        this.assertFrameName(cls);
        return cls;
    }

    @Override
    public Slot createSlot(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        Slot slot = this.createSlot(frameID, collection);
        this.addSlot(slot, collection, collection2, bl);
        this.assertFrameName(slot);
        return slot;
    }

    @Override
    public SimpleInstance createSimpleInstance(FrameID frameID, Collection collection, boolean bl) {
        SimpleInstance simpleInstance = this.createSimpleInstance(frameID, collection);
        this.addSimpleInstance(simpleInstance, collection, bl);
        this.assertFrameName(simpleInstance);
        return simpleInstance;
    }

    @Override
    public Facet createFacet(FrameID frameID, Collection collection, boolean bl) {
        Facet facet = this.createFacet(frameID, collection);
        this.addFacet(facet, collection, bl);
        this.assertFrameName(facet);
        return facet;
    }

    private void assertFrameName(Frame frame) {
        this._helper.setValues(frame, this._systemFrames.getNameSlot(), null, false, Collections.singleton(frame.getName()));
    }

    private void addSimpleInstance(SimpleInstance simpleInstance, Collection collection, boolean bl) {
        this.addInstance(simpleInstance, collection, bl);
    }

    protected void addCls(Cls cls, Collection collection, Collection collection2, boolean bl) {
        this.addInstance(cls, collection, bl);
        this.addDirectOwnSlotValuePairs(cls, this._systemFrames.getDirectSuperclassesSlot(), this._systemFrames.getDirectSubclassesSlot(), collection2);
    }

    protected void addSlot(Slot slot, Collection collection, Collection collection2, boolean bl) {
        if (!collection2.isEmpty()) {
            bl = false;
        }
        this.addInstance(slot, collection, bl);
        if (!collection2.isEmpty()) {
            this.addDirectOwnSlotValuePairs(slot, this._systemFrames.getDirectSuperslotsSlot(), this._systemFrames.getDirectSubslotsSlot(), collection2);
        }
    }

    private void addDirectOwnSlotValuePairs(Frame frame, Slot slot, Slot slot2, Collection collection) {
        this.addDirectOwnSlotValues(frame, slot, collection);
        for (Frame frame2 : collection) {
            this.addDirectOwnSlotValue(frame2, slot2, frame);
        }
    }

    private void addFacet(Facet facet, Collection collection, boolean bl) {
        this.addInstance(facet, collection, bl);
    }

    private void addInstance(Instance instance, Collection collection, boolean bl) {
        this.addDirectOwnSlotValuePairs(instance, this._systemFrames.getDirectTypesSlot(), this._systemFrames.getDirectInstancesSlot(), collection);
        if (bl) {
            this.addDefaults(instance, collection);
        }
    }

    private Slot getInverseSlot(Slot slot) {
        return (Slot)this.getDirectOwnSlotValue(slot, this._systemFrames.getInverseSlotSlot());
    }

    @Override
    public Collection getOwnSlotValues(Frame frame, Slot slot) {
        ArrayList arrayList = new ArrayList();
        this.addOwnSlotValues(frame, slot, arrayList);
        return SimpleFrameStore.unmodifiableCollection(arrayList);
    }

    private void addOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        collection.addAll(this.getDirectOwnSlotValues(frame, slot));
        this.addInheritedTemplateSlotValues(frame, slot, collection);
        this.addSubslotValues(frame, slot, collection);
        this.addInferredInverseSlotValues(frame, slot, collection);
        if (frame instanceof Slot && collection.isEmpty() && this.isInheritedSuperslotSlot(slot)) {
            this.addInheritedSuperslotValues((Slot)frame, slot, collection);
        }
    }

    private void addInferredInverseSlotValues(Frame frame, Slot slot, Collection collection) {
        Slot slot2 = this.getInverseSlot(slot);
        if (slot2 != null) {
            Collection collection2 = this.getTemplateSlotValuesReferences(frame, slot2);
            for (Cls cls : collection2) {
                collection.addAll(this.getInstances(cls));
            }
        }
    }

    private Collection getTemplateSlotValuesReferences(Frame frame, Slot slot) {
        HashSet<Frame> hashSet = new HashSet<Frame>();
        hashSet.addAll(this._helper.getFrames(slot, this._systemFrames.getValuesFacet(), true, frame));
        return hashSet;
    }

    private boolean isInheritedSuperslotSlot(Slot slot) {
        return this._inheritedSuperslotSlots.contains(slot);
    }

    private void addInheritedSuperslotValues(Slot slot, Slot slot2, Collection collection) {
        Facet facet = (Facet)this.getDirectOwnSlotValue(slot2, this._systemFrames.getAssociatedFacetSlot());
        for (Slot slot3 : this.getSuperslots(slot)) {
            List list = this.getDirectOwnSlotValues(slot3, slot2);
            if (facet == null) {
                collection.addAll(list);
                continue;
            }
            Collection collection2 = facet.resolveValues(collection, list);
            if (((Object)collection2).equals(collection)) continue;
            collection.clear();
            collection.addAll(collection2);
        }
    }

    private void addInheritedTemplateSlotValues(Frame frame, Slot slot, Collection collection) {
        if (frame instanceof Instance) {
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            Instance instance = (Instance)frame;
            for (Cls cls : this.getTypes(instance)) {
                linkedHashSet.addAll(this.getDirectTemplateSlotValues(cls, slot));
            }
            linkedHashSet.addAll(this.getDirectOwnSlotValues(slot, this._systemFrames.getValuesSlot()));
            collection.addAll(linkedHashSet);
        }
    }

    private void addSubslotValues(Frame frame, Slot slot, Collection collection) {
        for (Slot slot2 : this.getSubslots(slot)) {
            collection.addAll(this.getDirectOwnSlotValues(frame, slot2));
        }
    }

    @Override
    public List getDirectOwnSlotValues(Frame frame, Slot slot) {
        List list = this.getValues(frame, slot, null, false);
        return SimpleFrameStore.unmodifiableList(list);
    }

    @Override
    public int getDirectOwnSlotValuesCount(Frame frame, Slot slot) {
        return this._helper.getValuesCount(frame, slot, null, false);
    }

    private List getValues(Frame frame, Slot slot, Facet facet, boolean bl) {
        return this._helper.getValues(frame, slot, facet, bl);
    }

    private Object getValue(Frame frame, Slot slot, Facet facet, boolean bl) {
        List list = this._helper.getValues(frame, slot, facet, bl);
        return list.isEmpty() ? null : list.get(0);
    }

    private void setValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        this._helper.setValues(frame, slot, facet, bl, collection);
    }

    @Override
    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        Slot slot2 = this.getInverseSlot(slot);
        if (slot2 != null) {
            this.removeInverseLinksFromCurrentValues(frame, slot, slot2);
            if (collection != null && !collection.isEmpty()) {
                this.addLinksFromNewValues(frame, slot, collection, slot2);
            }
        }
        this._helper.setValues(frame, slot, null, false, collection);
    }

    private boolean hasOwnSlot(Frame frame, Slot slot) {
        return this.getOwnSlots(frame).contains(slot);
    }

    private void addLinksFromNewValues(Frame frame, Slot slot, Collection collection, Slot slot2) {
        boolean bl = this.isCardinalitySingle(slot2);
        for (Object e : collection) {
            Frame frame2;
            Object object;
            Frame frame3;
            if (!(e instanceof Frame) || !this.hasOwnSlot(frame3 = (Frame)e, slot2)) continue;
            if (bl && (object = this.getDirectOwnSlotValue(frame3, slot2)) instanceof Frame && (frame2 = (Frame)object) != null && !frame2.equals(frame)) {
                this.removeDirectOwnSlotValue(frame2, slot, frame3);
                this.removeDirectOwnSlotValue(frame3, slot2, frame2);
            }
            if (this.getDirectOwnSlotValues(frame3, slot2).contains(frame)) continue;
            this.addDirectOwnSlotValue(frame3, slot2, frame);
        }
    }

    private boolean isCardinalitySingle(Slot slot) {
        Number number = (Number)this.getDirectOwnSlotValue(slot, this._systemFrames.getMaximumCardinalitySlot());
        return number != null && number.intValue() == 1;
    }

    private void removeInverseLinksFromCurrentValues(Frame frame, Slot slot, Slot slot2) {
        List list = this.getDirectOwnSlotValues(frame, slot);
        if (!list.isEmpty()) {
            for (Object e : new ArrayList(list)) {
                if (!(e instanceof Frame)) continue;
                Frame frame2 = (Frame)e;
                this.removeDirectOwnSlotValue(frame2, slot2, frame);
            }
        }
    }

    @Override
    public List getDirectTemplateSlotValues(Cls cls, Slot slot) {
        return this.getValues(cls, slot, this._systemFrames.getValuesFacet(), true);
    }

    @Override
    public void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection collection) {
        this.setValues(cls, slot, this._systemFrames.getValuesFacet(), true, collection);
    }

    @Override
    public List getDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        return this.getValues(cls, slot, facet, true);
    }

    private Slot getAssociatedSlot(Facet facet) {
        List list = this.getDirectOwnSlotValues(facet, this._systemFrames.getAssociatedSlotSlot());
        return (Slot)CollectionUtilities.getFirstItem(list);
    }

    @Override
    public void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection collection) {
        List list;
        Slot slot2 = this.getAssociatedSlot(facet);
        if (slot2 != null && CollectionUtilities.equalsList(list = this.getDirectOwnSlotValues(slot, slot2), collection)) {
            collection = Collections.EMPTY_LIST;
        }
        this.setValues(cls, slot, facet, true, collection);
    }

    @Override
    public Set<Frame> getFramesWithDirectOwnSlotValue(Slot slot, Object object) {
        return this._helper.getFrames(slot, null, false, object);
    }

    @Override
    public Set<Frame> getFramesWithAnyDirectOwnSlotValue(Slot slot) {
        return this._helper.getFramesWithAnyValue(slot, null, false);
    }

    @Override
    public Set getClsesWithDirectTemplateSlotValue(Slot slot, Object object) {
        return this._helper.getFrames(slot, this._systemFrames.getValuesFacet(), true, object);
    }

    @Override
    public Set<Cls> getClsesWithAnyDirectTemplateSlotValue(Slot slot) {
        return this._helper.getFramesWithAnyValue(slot, this._systemFrames.getValuesFacet(), true);
    }

    @Override
    public Set getClsesWithDirectTemplateFacetValue(Slot slot, Facet facet, Object object) {
        return this._helper.getFrames(slot, facet, true, object);
    }

    @Override
    public Set<Frame> getFramesWithMatchingDirectOwnSlotValue(Slot slot, String string, int n) {
        return this._helper.getMatchingFrames(slot, null, false, string, n);
    }

    @Override
    public Set getClsesWithMatchingDirectTemplateSlotValue(Slot slot, String string, int n) {
        return this._helper.getMatchingFrames(slot, null, true, string, n);
    }

    @Override
    public Set getClsesWithMatchingDirectTemplateFacetValue(Slot slot, Facet facet, String string, int n) {
        return this._helper.getMatchingFrames(slot, facet, true, string, n);
    }

    private Object getDirectOwnSlotValue(Frame frame, Slot slot) {
        return this.getValue(frame, slot, null, false);
    }

    @Override
    public String getFrameName(Frame frame) {
        String string = (String)this.getDirectOwnSlotValue(frame, this._systemFrames.getNameSlot());
        if (string == null) {
            string = "<<missing frame name for " + frame.getFrameID() + ">>";
        }
        return string;
    }

    protected void addSystemFrames() {
        this._systemFrames.addSystemFrames(this);
    }

    protected Cls createCls(FrameID frameID, Collection collection) {
        return this.getFrameFactory().createCls(frameID, collection);
    }

    protected Slot createSlot(FrameID frameID, Collection collection) {
        return this.getFrameFactory().createSlot(frameID, collection);
    }

    protected Facet createFacet(FrameID frameID, Collection collection) {
        return this.getFrameFactory().createFacet(frameID, collection);
    }

    protected SimpleInstance createSimpleInstance(FrameID frameID, Collection collection) {
        return this.getFrameFactory().createSimpleInstance(frameID, collection);
    }

    private void addDefaults(Instance instance, Collection collection) {
        for (Cls cls : collection) {
            this.addDefaults(instance, cls);
        }
    }

    private void addDefaults(Instance instance, Cls cls) {
        for (Slot slot : this.getTemplateSlots(cls)) {
            this.addDefault(instance, cls, slot);
        }
    }

    private void addDefault(Instance instance, Cls cls, Slot slot) {
        Collection collection = this.getTemplateFacetValues(cls, slot, this._systemFrames.getDefaultValuesFacet());
        if (!collection.isEmpty()) {
            Slot slot2 = slot.getInverseSlot();
            if (slot2 == null) {
                this.addDirectOwnSlotValues(instance, slot, collection);
            } else {
                for (Frame frame : collection) {
                    this.addDirectOwnSlotValuePair(instance, slot, slot2, frame);
                }
            }
        }
    }

    @Override
    public Set getOwnFacets(Frame frame, Slot slot) {
        HashSet<Facet> hashSet = new HashSet<Facet>();
        for (Slot slot2 : this.getOwnSlots(slot)) {
            Facet facet = (Facet)this.getDirectOwnSlotValue(slot2, this._systemFrames.getAssociatedFacetSlot());
            if (facet == null) continue;
            hashSet.add(facet);
        }
        return hashSet;
    }

    @Override
    public Collection getOwnFacetValues(Frame frame, Slot slot, Facet facet) {
        Collection collection = new ArrayList();
        for (Cls cls : this.getDirectTypes((Instance)frame)) {
            Collection collection2 = this.getTemplateFacetValues(cls, slot, facet);
            collection = SimpleFrameStore.resolveValues(collection, collection2, facet);
        }
        return collection;
    }

    @Override
    public Set getOverriddenTemplateSlots(Cls cls) {
        LinkedHashSet linkedHashSet = new LinkedHashSet(this.getTemplateSlots(cls));
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            Slot slot = (Slot)iterator.next();
            if (this.isOverridden(cls, slot)) continue;
            iterator.remove();
        }
        return linkedHashSet;
    }

    @Override
    public Set getDirectlyOverriddenTemplateSlots(Cls cls) {
        LinkedHashSet linkedHashSet = new LinkedHashSet(this.getTemplateSlots(cls));
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            Slot slot = (Slot)iterator.next();
            if (this.isDirectlyOverridden(cls, slot)) continue;
            iterator.remove();
        }
        return linkedHashSet;
    }

    @Override
    public Set getOverriddenTemplateFacets(Cls cls, Slot slot) {
        LinkedHashSet<Facet> linkedHashSet = new LinkedHashSet<Facet>(this.getTemplateFacets(cls, slot));
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            Facet facet = (Facet)iterator.next();
            if (this.isOverridden(cls, slot, facet)) continue;
            iterator.remove();
        }
        return linkedHashSet;
    }

    @Override
    public Set getDirectlyOverriddenTemplateFacets(Cls cls, Slot slot) {
        LinkedHashSet<Facet> linkedHashSet = new LinkedHashSet<Facet>(this.getTemplateFacets(cls, slot));
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            Facet facet = (Facet)iterator.next();
            if (this.isDirectlyOverridden(cls, slot, facet)) continue;
            iterator.remove();
        }
        return linkedHashSet;
    }

    private boolean isDirectlyOverridden(Cls cls, Slot slot) {
        return !this.getDirectlyOverriddenTemplateFacets(cls, slot).isEmpty();
    }

    private boolean isOverridden(Cls cls, Slot slot) {
        return !this.getOverriddenTemplateFacets(cls, slot).isEmpty();
    }

    private boolean isDirectlyOverridden(Cls cls, Slot slot, Facet facet) {
        return !this.getDirectTemplateFacetValues(cls, slot, facet).isEmpty();
    }

    private boolean isOverridden(Cls cls, Slot slot, Facet facet) {
        List list;
        HashSet hashSet = new HashSet(this.getTemplateFacetValues(cls, slot, facet));
        return !CollectionUtilities.equalsSet(hashSet, list = this.getDirectOwnSlotValues(slot, facet.getAssociatedSlot()));
    }

    @Override
    public void removeDirectTemplateFacetOverrides(Cls cls, Slot slot) {
        Set<Facet> set = this.getTemplateFacets(cls, slot);
        for (Facet facet : set) {
            this.setDirectTemplateFacetValues(cls, slot, facet, Collections.EMPTY_LIST);
        }
    }

    @Override
    public boolean beginTransaction(String string) {
        return this._helper.beginTransaction(string);
    }

    @Override
    public boolean commitTransaction() {
        return this._helper.commitTransaction();
    }

    @Override
    public boolean rollbackTransaction() {
        return this._helper.rollbackTransaction();
    }

    @Override
    public TransactionMonitor getTransactionStatusMonitor() {
        return this._helper.getTransactionStatusMonitor();
    }

    @Override
    public List<AbstractEvent> getEvents() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void setDelegate(FrameStore frameStore) {
        Log.getLogger().severe("Unable to set delegate: " + frameStore.getName());
    }

    @Override
    public FrameStore getDelegate() {
        return null;
    }

    public String toString() {
        return StringUtilities.getClassName(this);
    }

    @Override
    public void replaceFrame(Frame frame, Frame frame2) {
        this.nameToFrameMap.remove(frame.getFrameID().getName());
        this._helper.replaceFrame(frame, frame2);
    }
}

