/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore;

import edu.stanford.smi.protege.exception.OntologyException;
import edu.stanford.smi.protege.exception.ProtegeError;
import edu.stanford.smi.protege.exception.ProtegeIOException;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.framestore.AbstractFrameStoreInvocationHandler;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.ServerProperties;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculator;
import edu.stanford.smi.protege.server.metaproject.MetaProject;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.server.metaproject.User;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class LastUsageInvocationHandler
extends AbstractFrameStoreInvocationHandler {
    private final MetaProject metaproject;
    private final Map<String, Date> lastAccessTimeMap = new HashMap<String, Date>();
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "Update MetaProject Thread");
            thread.setDaemon(true);
            return thread;
        }
    });
    private FrameCalculator frameCalculator;

    public LastUsageInvocationHandler(ProjectInstance projectInstance, FrameCalculator frameCalculator) {
        this.frameCalculator = frameCalculator;
        this.metaproject = projectInstance.getMetaProject();
        long l = ServerProperties.getMetaProjectLastAccessTimeUpdateFrequency();
        this.executor.scheduleWithFixedDelay(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HashMap hashMap;
                Map map = LastUsageInvocationHandler.this.lastAccessTimeMap;
                synchronized (map) {
                    hashMap = new HashMap(LastUsageInvocationHandler.this.lastAccessTimeMap);
                    LastUsageInvocationHandler.this.lastAccessTimeMap.clear();
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    String string = (String)entry.getKey();
                    Date date = (Date)entry.getValue();
                    User user = LastUsageInvocationHandler.this.metaproject.getUser(string);
                    user.setLastAccess(date);
                }
            }
        }, l, l, TimeUnit.MILLISECONDS);
    }

    protected void executeQuery(Query query, final QueryCallback queryCallback) {
        this.updateLastAccessTime();
        QueryCallback queryCallback2 = new QueryCallback(){

            @Override
            public void provideQueryResults(Collection<Frame> collection) {
                LastUsageInvocationHandler.this.updateLastAccessTime();
                queryCallback.provideQueryResults(collection);
            }

            @Override
            public void handleError(ProtegeError protegeError) {
                LastUsageInvocationHandler.this.updateLastAccessTime();
                queryCallback.handleError(protegeError);
            }

            @Override
            public void handleError(ProtegeIOException protegeIOException) {
                LastUsageInvocationHandler.this.updateLastAccessTime();
                queryCallback.handleError(protegeIOException);
            }

            @Override
            public void handleError(OntologyException ontologyException) {
                LastUsageInvocationHandler.this.updateLastAccessTime();
                queryCallback.handleError(ontologyException);
            }
        };
        this.getDelegate().executeQuery(query, queryCallback2);
    }

    protected Object handleInvoke(Method method, Object[] objectArray) {
        if (!method.getName().equals("getEvents")) {
            this.updateLastAccessTime();
        }
        return this.invoke(method, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLastAccessTime() {
        if (this.frameCalculator != null && this.frameCalculator.inFrameCalculatorThread()) {
            return;
        }
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        if (remoteSession == null) {
            return;
        }
        Date date = new Date();
        String string = remoteSession.getUserName();
        Map<String, Date> map = this.lastAccessTimeMap;
        synchronized (map) {
            this.lastAccessTimeMap.put(string, date);
        }
    }
}

