/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.socket;

import edu.stanford.smi.protege.server.socket.DebufferingInputStream;
import edu.stanford.smi.protege.server.socket.deflate.CompressingInputStream;
import edu.stanford.smi.protege.server.socket.deflate.CompressingOutputStream;
import edu.stanford.smi.protege.server.socket.deflate.HybridCompressingInputStream;
import edu.stanford.smi.protege.server.socket.deflate.HybridCompressingOutputStream;
import edu.stanford.smi.protege.util.Log;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;

public class Socket_Test
extends TestCase {
    private static Logger log = Log.getLogger(Socket_Test.class);
    private Random r = new Random();

    public void testReadWrite() throws IOException, InterruptedException {
        PipedInputStream pipedInputStream = new PipedInputStream();
        PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
        CompressingInputStream compressingInputStream = new CompressingInputStream(pipedInputStream);
        CompressingOutputStream compressingOutputStream = new CompressingOutputStream(pipedOutputStream);
        for (int i = 0; i < 3; ++i) {
            this.doReadWriteAndCheck(compressingInputStream, compressingOutputStream, this.createTestBuffer(368));
        }
        this.cleanup(compressingInputStream, compressingOutputStream);
    }

    public void testNegativeSize() throws IOException, InterruptedException {
        int n;
        PipedInputStream pipedInputStream = new PipedInputStream();
        PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
        CompressingInputStream compressingInputStream = new CompressingInputStream(pipedInputStream);
        CompressingOutputStream compressingOutputStream = new CompressingOutputStream(pipedOutputStream);
        for (n = 0; n < 4; ++n) {
            this.doReadWriteAndCheck(compressingInputStream, compressingOutputStream, this.createTestBuffer(250));
        }
        for (n = 0; n < 4; ++n) {
            this.doReadWriteAndCheck(compressingInputStream, compressingOutputStream, this.createTestBuffer(255));
        }
        for (n = 0; n < 4; ++n) {
            this.doReadWriteAndCheck(compressingInputStream, compressingOutputStream, this.createTestBuffer(762));
        }
        this.cleanup(compressingInputStream, compressingOutputStream);
    }

    public void testParticular() throws IOException, InterruptedException {
        PipedInputStream pipedInputStream = new PipedInputStream();
        PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
        CompressingInputStream compressingInputStream = new CompressingInputStream(pipedInputStream);
        CompressingOutputStream compressingOutputStream = new CompressingOutputStream(pipedOutputStream);
        for (int i = 0; i < 3; ++i) {
            byte[] byArray = new byte[]{78, 0, 13, 49, 55, 49, 46, 54, 53, 46, 51, 50, 46, 49, 49, 49, 0, 0, -27, -85};
            this.doReadWriteAndCheck(compressingInputStream, compressingOutputStream, byArray);
        }
        this.cleanup(compressingInputStream, compressingOutputStream);
    }

    public void testUnbuffered() throws IOException, InterruptedException {
        PipedInputStream pipedInputStream = new PipedInputStream();
        PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
        DebufferingInputStream debufferingInputStream = new DebufferingInputStream(pipedInputStream);
        CompressingInputStream compressingInputStream = new CompressingInputStream(debufferingInputStream);
        CompressingOutputStream compressingOutputStream = new CompressingOutputStream(pipedOutputStream);
        for (int i = 0; i < 3; ++i) {
            this.doReadWriteAndCheck(compressingInputStream, compressingOutputStream, this.createTestBuffer(368));
        }
        this.cleanup(compressingInputStream, compressingOutputStream);
    }

    public void badTestHybrid() throws IOException, InterruptedException {
        int[] nArray;
        PipedInputStream pipedInputStream = new PipedInputStream();
        PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
        HybridCompressingInputStream hybridCompressingInputStream = new HybridCompressingInputStream(pipedInputStream);
        HybridCompressingOutputStream hybridCompressingOutputStream = new HybridCompressingOutputStream(pipedOutputStream);
        for (int n : nArray = new int[]{HybridCompressingOutputStream.TOO_SMALL_TO_COMPRESS / 2, HybridCompressingOutputStream.TOO_SMALL_TO_COMPRESS - 2, HybridCompressingOutputStream.TOO_SMALL_TO_COMPRESS - 1, HybridCompressingOutputStream.TOO_SMALL_TO_COMPRESS, HybridCompressingOutputStream.TOO_SMALL_TO_COMPRESS + 1, HybridCompressingOutputStream.TOO_SMALL_TO_COMPRESS + 2, 2 * HybridCompressingOutputStream.TOO_SMALL_TO_COMPRESS}) {
            for (int i = 0; i < 3; ++i) {
                this.doReadWriteAndCheck(hybridCompressingInputStream, hybridCompressingOutputStream, this.createTestBuffer(n));
            }
        }
        this.cleanup(hybridCompressingInputStream, hybridCompressingOutputStream);
    }

    public void badTestHybridUnbuffered() throws IOException, InterruptedException {
        int[] nArray;
        PipedInputStream pipedInputStream = new PipedInputStream();
        PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
        DebufferingInputStream debufferingInputStream = new DebufferingInputStream(pipedInputStream);
        HybridCompressingInputStream hybridCompressingInputStream = new HybridCompressingInputStream(debufferingInputStream);
        HybridCompressingOutputStream hybridCompressingOutputStream = new HybridCompressingOutputStream(pipedOutputStream);
        for (int n : nArray = new int[]{HybridCompressingOutputStream.TOO_SMALL_TO_COMPRESS / 2, HybridCompressingOutputStream.TOO_SMALL_TO_COMPRESS - 2, HybridCompressingOutputStream.TOO_SMALL_TO_COMPRESS - 1, HybridCompressingOutputStream.TOO_SMALL_TO_COMPRESS, HybridCompressingOutputStream.TOO_SMALL_TO_COMPRESS + 1, HybridCompressingOutputStream.TOO_SMALL_TO_COMPRESS + 2, 2 * HybridCompressingOutputStream.TOO_SMALL_TO_COMPRESS}) {
            for (int i = 0; i < 3; ++i) {
                this.doReadWriteAndCheck(hybridCompressingInputStream, hybridCompressingOutputStream, this.createTestBuffer(n));
            }
        }
        this.cleanup(hybridCompressingInputStream, hybridCompressingOutputStream);
    }

    public void doReadWriteAndCheck(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException, InterruptedException {
        try {
            byte[] byArray2 = new byte[byArray.length];
            ReadRunnable readRunnable = new ReadRunnable(inputStream, byArray2);
            Thread thread = new Thread((Runnable)readRunnable, "Read Test Thread");
            thread.start();
            Thread.sleep(1000L);
            outputStream.write(byArray);
            outputStream.flush();
            thread.join(7000L);
            Socket_Test.assertTrue((boolean)readRunnable.isDone());
            if (readRunnable.getError() != null) {
                log.log(Level.WARNING, "Exception caught in other thread", readRunnable.getError());
                Socket_Test.fail();
            }
            for (int i = 0; i < byArray.length; ++i) {
                Socket_Test.assertTrue((byArray[i] == byArray2[i] ? 1 : 0) != 0);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            log.log(Level.WARNING, "Junit test failed because of exception thrown", throwable);
        }
    }

    public void debug() {
        Log.setLoggingLevel(CompressingInputStream.class, Level.FINEST);
        Log.setLoggingLevel(CompressingOutputStream.class, Level.FINEST);
    }

    private byte[] createTestBuffer(int n) {
        byte[] byArray = new byte[n];
        this.r.nextBytes(byArray);
        return byArray;
    }

    private void cleanup(InputStream inputStream, OutputStream outputStream) {
        try {
            outputStream.close();
        }
        catch (Throwable throwable) {
            log.log(Level.FINE, "Exception caught closing output stream", throwable);
        }
        try {
            inputStream.close();
        }
        catch (Throwable throwable) {
            log.log(Level.FINE, "Exception caught closing input stream", throwable);
        }
    }

    public static class ReadRunnable
    implements Runnable {
        private Throwable error;
        private boolean done = false;
        private byte[] buffer;
        private InputStream is;

        public ReadRunnable(InputStream inputStream, byte[] byArray) {
            this.is = inputStream;
            this.buffer = byArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int n;
                int n2 = this.buffer.length;
                for (int i = 0; i < n2; i += n) {
                    n = this.is.read(this.buffer, i, n2 - i);
                    if (n != -1) continue;
                    throw new EOFException("Didn't read to end of stream");
                }
            }
            catch (Throwable throwable) {
                ReadRunnable readRunnable = this;
                synchronized (readRunnable) {
                    this.error = throwable;
                }
                log.log(Level.WARNING, "Exception caught in reader thread", throwable);
            }
            ReadRunnable readRunnable = this;
            synchronized (readRunnable) {
                this.done = true;
            }
        }

        public synchronized void waitUntilReady() {
        }

        public synchronized Throwable getError() {
            return this.error;
        }

        public synchronized boolean isDone() {
            return this.done;
        }
    }
}

