/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.clips;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.ExportPlugin;
import edu.stanford.smi.protege.plugin.ImportPlugin;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.storage.clips.ClipsFilePanel;
import edu.stanford.smi.protege.storage.clips.ClipsKnowledgeBaseFactory;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.WaitCursor;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClipsImportExportPlugin
implements ImportPlugin,
ExportPlugin {
    private static transient Logger log = Log.getLogger(ClipsImportExportPlugin.class);

    public String getName() {
        return "CLIPS";
    }

    public Project handleImportRequest() {
        Project project = Project.createNewProject(null, new ArrayList());
        ClipsImportExportPlugin.handleImportRequest(project);
        return project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleImportRequest(Project project) {
        ClipsFilePanel clipsFilePanel = new ClipsFilePanel();
        String string = LocalizedText.getText(ResourceKey.CLIPS_FILES_TO_IMPORT_DIALOG_TITLE);
        int n = ModalDialog.showDialog(null, clipsFilePanel, string, 11);
        if (n == 1) {
            String string2 = clipsFilePanel.getClsesFileName();
            String string3 = clipsFilePanel.getInstancesFileName();
            WaitCursor waitCursor = new WaitCursor(ProjectManager.getProjectManager().getMainPanel());
            try {
                ClipsImportExportPlugin.importProject(project, string2, string3);
            }
            finally {
                waitCursor.hide();
            }
        }
    }

    private static void importProject(Project project, String string, String string2) {
        ArrayList arrayList = new ArrayList();
        KnowledgeBase knowledgeBase = project.getKnowledgeBase();
        ClipsKnowledgeBaseFactory clipsKnowledgeBaseFactory = new ClipsKnowledgeBaseFactory();
        Reader reader = FileUtilities.getReader(string);
        Reader reader2 = FileUtilities.getReader(string2);
        clipsKnowledgeBaseFactory.loadKnowledgeBase(knowledgeBase, reader, reader2, false, arrayList);
        Log.handleErrors(Log.getLogger(ClipsImportExportPlugin.class), Level.WARNING, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleExportRequest(Project project) {
        ClipsFilePanel clipsFilePanel = new ClipsFilePanel();
        String string = LocalizedText.getText(ResourceKey.CLIPS_FILES_TO_EXPORT_DIALOG_TITLE);
        int n = ModalDialog.showDialog(null, clipsFilePanel, string, 11);
        if (n == 1) {
            String string2 = clipsFilePanel.getClsesFileName();
            String string3 = clipsFilePanel.getInstancesFileName();
            WaitCursor waitCursor = new WaitCursor(ProjectManager.getProjectManager().getMainPanel());
            try {
                ClipsImportExportPlugin.exportProject(project, string2, string3);
            }
            finally {
                waitCursor.hide();
            }
        }
    }

    private static void exportProject(Project project, String string, String string2) {
        ArrayList arrayList = new ArrayList();
        KnowledgeBase knowledgeBase = project.getKnowledgeBase();
        ClipsKnowledgeBaseFactory clipsKnowledgeBaseFactory = new ClipsKnowledgeBaseFactory();
        Writer writer = FileUtilities.getWriter(string);
        Writer writer2 = FileUtilities.getWriter(string2);
        clipsKnowledgeBaseFactory.saveKnowledgeBase(knowledgeBase, writer, writer2, arrayList);
        Log.handleErrors(log, Level.WARNING, arrayList);
    }

    public void dispose() {
    }
}

