/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SimpleListModel;
import edu.stanford.smi.protege.util.TransferableCollection;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.Collection;
import javax.swing.JList;

public class ListTarget
implements DropTargetListener {
    private int _dropSelectionIndex = -1;
    private Object _dropTargetArea;

    private void clearDropSelection(JList jList) {
        jList.putClientProperty(DefaultRenderer.DROP_TARGET, null);
        jList.putClientProperty(DefaultRenderer.DROP_TARGET_AREA, null);
        this.setDropSelectionIndex(jList, -1);
    }

    public void doDrop(JList jList, Collection collection, int n, Object object) {
        int n2 = n;
        if (object == DefaultRenderer.DROP_TARGET_AREA_BELOW) {
            ++n2;
        }
        SimpleListModel simpleListModel = (SimpleListModel)jList.getModel();
        int[] nArray = jList.getSelectedIndices();
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            simpleListModel.moveValue(n3, n2);
            if (n3 <= n2) continue;
            ++n2;
        }
        jList.setSelectionInterval(nArray[0], nArray[nArray.length - 1]);
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.clearDropSelection((JList)dropTargetEvent.getDropTargetContext().getComponent());
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
        this.setDropSelection(dropTargetDragEvent);
    }

    public void dragScroll(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        boolean bl = false;
        JList jList = (JList)dropTargetDropEvent.getDropTargetContext().getComponent();
        this.setDropSelection(jList, dropTargetDropEvent.getLocation());
        if (this._dropSelectionIndex != -1 && dropTargetDropEvent.isDataFlavorSupported(TransferableCollection.getCollectionFlavor())) {
            try {
                int n = dropTargetDropEvent.getDropAction();
                dropTargetDropEvent.acceptDrop(n);
                Collection collection = (Collection)dropTargetDropEvent.getTransferable().getTransferData(TransferableCollection.getCollectionFlavor());
                this.doDrop(jList, collection, this._dropSelectionIndex, this._dropTargetArea);
            }
            catch (Exception exception) {
                Log.getLogger().severe(Log.toString(exception));
            }
        } else {
            dropTargetDropEvent.rejectDrop();
            Log.getLogger().warning("unsupported flavor: " + dropTargetDropEvent);
        }
        dropTargetDropEvent.dropComplete(bl);
        this.clearDropSelection(jList);
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    private void setDropSelection(DropTargetDragEvent dropTargetDragEvent) {
        this.setDropSelection((JList)dropTargetDragEvent.getDropTargetContext().getComponent(), dropTargetDragEvent.getLocation());
    }

    private void setDropSelection(JList jList, Point point) {
        int n = jList.locationToIndex(point);
        if (n == -1) {
            this.clearDropSelection(jList);
        } else {
            Object e = jList.getModel().getElementAt(n);
            Rectangle rectangle = jList.getCellBounds(n, n);
            if (point.y < rectangle.y + rectangle.height / 2) {
                this._dropTargetArea = DefaultRenderer.DROP_TARGET_AREA_ABOVE;
            } else if (n == jList.getModel().getSize() - 1) {
                this._dropTargetArea = DefaultRenderer.DROP_TARGET_AREA_BELOW;
            } else {
                this._dropTargetArea = DefaultRenderer.DROP_TARGET_AREA_ABOVE;
                e = jList.getModel().getElementAt(++n);
            }
            jList.putClientProperty(DefaultRenderer.DROP_TARGET, e);
            jList.putClientProperty(DefaultRenderer.DROP_TARGET_AREA, this._dropTargetArea);
            this.setDropSelectionIndex(jList, n);
        }
    }

    private void setDropSelectionIndex(JList jList, int n) {
        this._dropSelectionIndex = n;
        jList.repaint();
    }
}

