/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.code.generator.wrapping;

import edu.stanford.smi.protege.code.generator.wrapping.SlotAtClassCode;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClsCode {
    private Cls cls;

    public ClsCode(Cls cls) {
        this.cls = cls;
    }

    public String getJavaName() {
        return ClsCode.getValidJavaName(this.cls.getName());
    }

    public List<SlotAtClassCode> getSlotCodes(boolean bl) {
        HashSet<Slot> hashSet = new HashSet<Slot>();
        ArrayList<SlotAtClassCode> arrayList = new ArrayList<SlotAtClassCode>();
        HashSet<Slot> hashSet2 = new HashSet<Slot>(this.cls.getTemplateSlots());
        for (Slot slot : hashSet2) {
            if (slot.isSystem()) continue;
            hashSet.add(slot);
            SlotAtClassCode slotAtClassCode = new SlotAtClassCode(this.cls, slot);
            arrayList.add(slotAtClassCode);
            Collection collection = slot.getSubslots();
            for (Slot slot2 : collection) {
                if (hashSet.contains(slot2)) continue;
                arrayList.add(new SlotAtClassCode(this.cls, slot2));
                hashSet.add(slot2);
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public static String getValidJavaName(String string) {
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            string = string.replace(c, '_');
        }
        return string;
    }
}

