/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteServerProject;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Session;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.server.framestore.RemoteServerFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerSessionLost;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteClientProject
extends Project {
    private static Logger log = Log.getLogger(RemoteClientProject.class);
    private RemoteServer _server;
    private RemoteServerProject _serverProject;
    private RemoteSession _session;
    private Thread shutdownHook;

    public static Project createProject(RemoteServer remoteServer, RemoteServerProject remoteServerProject, RemoteSession remoteSession, boolean bl) throws RemoteException {
        return new RemoteClientProject(remoteServer, remoteServerProject, remoteSession, bl);
    }

    public RemoteClientProject(RemoteServer remoteServer, RemoteServerProject remoteServerProject, RemoteSession remoteSession, boolean bl) throws RemoteException {
        super(null, null, new ArrayList(), false);
        this._server = remoteServer;
        this._serverProject = remoteServerProject;
        this._session = remoteSession;
        remoteServerProject.getDomainKbFrameStore(remoteSession);
        KnowledgeBase knowledgeBase = RemoteClientProject.createKnowledgeBase(remoteServer, remoteServerProject.getDomainKbFrameStore(remoteSession), remoteServerProject.getDomainKbFactoryClassName(), remoteSession, false);
        KnowledgeBase knowledgeBase2 = RemoteClientProject.createKnowledgeBase(remoteServer, remoteServerProject.getProjectKbFrameStore(remoteSession), remoteServerProject.getProjectKbFactoryClassName(), remoteSession, true);
        knowledgeBase2 = RemoteClientProject.copyKb(knowledgeBase2, knowledgeBase);
        this.setKnowledgeBases(knowledgeBase, knowledgeBase2);
        if (bl) {
            knowledgeBase.setPollForEvents(true);
        }
        this.installShutdownHook();
    }

    private static KnowledgeBase copyKb(KnowledgeBase knowledgeBase, KnowledgeBase knowledgeBase2) {
        ArrayList arrayList = new ArrayList();
        KnowledgeBase knowledgeBase3 = RemoteClientProject.loadProjectKB(null, null, arrayList);
        Log.handleErrors(log, Level.WARNING, arrayList);
        knowledgeBase3.deleteInstance(RemoteClientProject.getProjectInstance(knowledgeBase3));
        Instance instance = RemoteClientProject.getProjectInstance(knowledgeBase);
        instance.deepCopy(knowledgeBase3, null);
        RemoteClientProject.copyClientInformation(knowledgeBase, knowledgeBase3, knowledgeBase2, false);
        return knowledgeBase3;
    }

    private static KnowledgeBase createKnowledgeBase(RemoteServer remoteServer, RemoteServerFrameStore remoteServerFrameStore, String string, RemoteSession remoteSession, boolean bl) {
        Class clazz = SystemUtilities.forName(string, true);
        KnowledgeBaseFactory knowledgeBaseFactory = (KnowledgeBaseFactory)SystemUtilities.newInstance(clazz);
        ArrayList arrayList = new ArrayList();
        DefaultKnowledgeBase defaultKnowledgeBase = (DefaultKnowledgeBase)knowledgeBaseFactory.createKnowledgeBase(arrayList);
        Log.handleErrors(log, Level.WARNING, arrayList);
        if (log.isLoggable(Level.FINE)) {
            log.fine("created kb=" + defaultKnowledgeBase);
        }
        defaultKnowledgeBase.setGenerateEventsEnabled(false);
        defaultKnowledgeBase.setCallCachingEnabled(false);
        RemoteClientFrameStore remoteClientFrameStore = new RemoteClientFrameStore(remoteServer, remoteServerFrameStore, remoteSession, defaultKnowledgeBase, bl);
        defaultKnowledgeBase.setTerminalFrameStore(remoteClientFrameStore);
        return defaultKnowledgeBase;
    }

    public RemoteSession getSession() {
        return this._session;
    }

    public RemoteServer getServer() {
        return this._server;
    }

    public URI getProjectURI() {
        URI uRI = null;
        try {
            uRI = this._serverProject.getURI(this._session);
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
        }
        return uRI;
    }

    public URL getProjectURL() {
        URL uRL = null;
        try {
            uRL = new URL(this.getProjectURI().toString());
        }
        catch (MalformedURLException malformedURLException) {
            Log.getLogger().severe(Log.toString(malformedURLException));
        }
        return uRL;
    }

    public Collection getCurrentUsers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Collection collection = this._serverProject.getCurrentSessions(this._session);
            for (Session session : collection) {
                arrayList.add(session.getUserName());
            }
        }
        catch (RemoteException remoteException) {
            Log.getLogger().severe(Log.toString(remoteException));
        }
        return arrayList;
    }

    public String getLocalUser() {
        return this._session.getUserName();
    }

    public void dispose() {
        if (log.isLoggable(Level.FINE)) {
            Log.getLogger().fine("Remote project dispose " + this);
        }
        super.dispose();
        this.attemptClose();
        this.uninstallShutdownHook();
    }

    private void attemptClose() {
        try {
            this._serverProject.close(this._session);
        }
        catch (ServerSessionLost serverSessionLost) {
            Log.getLogger().info("Session disconnected");
        }
        catch (RemoteException remoteException) {
            Log.getLogger().warning(remoteException.toString());
        }
    }

    public KnowledgeBaseFactory getKnowledgeBaseFactory() {
        return null;
    }

    public boolean isMultiUserClient() {
        return true;
    }

    private void installShutdownHook() {
        this.shutdownHook = new Thread("Remote Project ShutdownHook"){

            public void run() {
                try {
                    RemoteClientProject.this.attemptClose();
                }
                catch (Throwable throwable) {
                    Log.getLogger().log(Level.INFO, "Exception caught", throwable);
                }
            }
        };
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Unable to install shutdown hook", exception);
        }
    }

    private void uninstallShutdownHook() {
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Unable to remove shutdown hook", exception);
        }
    }

    public boolean isDirty() {
        return false;
    }
}

