/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.framestore.SimpleTestCase;
import edu.stanford.smi.protege.server.RemoteProjectManager;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteServerProject;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.framestore.LastUsageInvocationHandler;
import edu.stanford.smi.protege.server.metaproject.MetaProject;
import edu.stanford.smi.protege.server.metaproject.User;
import edu.stanford.smi.protege.server.metaproject.impl.MetaProjectImpl;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.DeletionHook;
import edu.stanford.smi.protege.util.DeletionHookUtil;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ProtegeJob;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.io.File;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Server_Test
extends SimpleTestCase {
    private static transient Logger log = Log.getLogger(Server_Test.class);
    public static final String HOST = "localhost";
    public static final String USER1 = "Ray Fergerson";
    public static final String PASSWORD1 = "claudia";
    public static final String WRONG_PASSWORD = "elle";
    public static final String PROJECT_NAME = "Newspaper";
    public static final String USER2 = "Jennifer Vendetti";
    public static final String PASSWORD2 = "jenny";
    public static final String ADMIN_USER = "Admin";
    public static final String ADMIN_PASSWORD = "admin";
    public static final String NAME = "//localhost/" + Server.getBoundName();
    public static final String JAR_PROPERTY = "junit.server.protege.jar";
    public static String protegeJarLocation = "build/dist/protege.jar";
    public static String metaproject = "examples/server/metaproject.pprj";
    private static boolean serverRunning = false;
    private RemoteServer _server;
    private int updateCounter;
    private static boolean informedServerNotConfigured = false;

    public void setUp() throws Exception {
        super.setUp();
        try {
            if (!Server_Test.startServer()) {
                return;
            }
            this._server = (RemoteServer)Naming.lookup(NAME);
            this._server.reinitialize();
        }
        catch (NotBoundException notBoundException) {
            Server_Test.fail((String)"Could not bind to server (is rmiregistry running?)");
        }
    }

    public static boolean startServer() throws Exception {
        File file = ApplicationProperties.getApplicationDirectory();
        File file2 = new File(file, protegeJarLocation);
        if (!file2.exists() && !(file2 = new File(protegeJarLocation)).exists()) {
            System.out.println("Need to compile to a jar file before running server tests");
            System.out.println("System tests not configured");
            return false;
        }
        System.setProperty("java.rmi.server.codebase", file2.toURL().toString());
        String[] stringArray = new String[]{"", metaproject};
        if (!serverRunning) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("starting server");
            }
            Server.startServer(stringArray);
            serverRunning = true;
        }
        return true;
    }

    public static boolean isServerRunning() {
        return serverRunning;
    }

    public static void setMetaProject(String string) {
        metaproject = string;
    }

    private static String getMachineIpAddress() {
        return SystemUtilities.getMachineIpAddress();
    }

    public void testSession() throws RemoteException {
        if (!serverRunning) {
            return;
        }
        RemoteSession remoteSession = this._server.openSession(USER1, Server_Test.getMachineIpAddress(), PASSWORD1);
        Server_Test.assertNotNull((String)"session", (Object)remoteSession);
        RemoteSession remoteSession2 = this._server.openSession(USER1, Server_Test.getMachineIpAddress(), WRONG_PASSWORD);
        Server_Test.assertNull((String)"no session", (Object)remoteSession2);
        this._server.closeSession(remoteSession);
    }

    public void testConnection() throws RemoteException {
        if (!serverRunning) {
            return;
        }
        RemoteSession remoteSession = this._server.openSession(USER1, Server_Test.getMachineIpAddress(), PASSWORD1);
        Server_Test.assertNotNull((Object)remoteSession);
        RemoteServerProject remoteServerProject = this._server.openProject(PROJECT_NAME, remoteSession);
        Server_Test.assertNotNull((Object)remoteServerProject);
        RemoteSession remoteSession2 = this._server.openSession(USER2, Server_Test.getMachineIpAddress(), PASSWORD2);
        RemoteServerProject remoteServerProject2 = this._server.openProject(PROJECT_NAME, remoteSession2);
        Server_Test.assertEquals((String)"projects", (Object)remoteServerProject, (Object)remoteServerProject2);
        Collection<RemoteSession> collection = this._server.getCurrentSessions(PROJECT_NAME, remoteSession2);
        Server_Test.assertEqualsSet(Server_Test.makeList(remoteSession, remoteSession2), collection);
        remoteServerProject2.close(remoteSession2);
        collection = this._server.getCurrentSessions(PROJECT_NAME, remoteSession);
        Server_Test.assertEqualsSet(Server_Test.makeList(remoteSession), collection);
        remoteServerProject.close(remoteSession);
        this._server.closeSession(remoteSession);
        this._server.closeSession(remoteSession2);
    }

    public void testGetProject() {
        if (!serverRunning) {
            return;
        }
        Project project = RemoteProjectManager.getInstance().getProject(HOST, USER1, PASSWORD1, PROJECT_NAME, true);
        Server_Test.assertNotNull((Object)project);
        KnowledgeBase knowledgeBase = project.getKnowledgeBase();
        Cls cls = knowledgeBase.getCls("Editor");
        Server_Test.assertNotNull((Object)cls);
        project.dispose();
    }

    public void testGetMetaProject() throws MalformedURLException, RemoteException, NotBoundException {
        if (!serverRunning) {
            return;
        }
        RemoteServer remoteServer = (RemoteServer)Naming.lookup("//localhost/" + Server.getBoundName());
        RemoteSession remoteSession = remoteServer.openSession(ADMIN_USER, SystemUtilities.getMachineIpAddress(), ADMIN_PASSWORD);
        MetaProject metaProject = RemoteProjectManager.getInstance().connectToMetaProject(remoteServer, remoteSession);
        Server_Test.assertTrue((boolean)((MetaProjectImpl)metaProject).getKnowledgeBase().getProject().isMultiUserClient());
        Server_Test.assertTrue((metaProject.getProjects().size() == 7 ? 1 : 0) != 0);
        Server_Test.assertTrue((metaProject.getProject("Wines") != null ? 1 : 0) != 0);
        metaProject.dispose();
    }

    public void testAccessTimes() throws MalformedURLException, RemoteException, NotBoundException, InterruptedException {
        if (!serverRunning) {
            return;
        }
        RemoteServer remoteServer = (RemoteServer)Naming.lookup("//localhost/" + Server.getBoundName());
        RemoteSession remoteSession = remoteServer.openSession(ADMIN_USER, SystemUtilities.getMachineIpAddress(), ADMIN_PASSWORD);
        MetaProject metaProject = RemoteProjectManager.getInstance().connectToMetaProject(remoteServer, remoteSession);
        User user = metaProject.getUser(USER2);
        long l = System.currentTimeMillis();
        Thread.sleep(LastUsageInvocationHandler.ACCESS_TIME_GRANULARITY);
        ((MetaProjectImpl)metaProject).getKnowledgeBase().flushEvents();
        Server_Test.assertTrue((user.getLastLogin() == null || user.getLastLogin().getTime() < l ? 1 : 0) != 0);
        Server_Test.assertTrue((user.getLastAccess() == null || user.getLastAccess().getTime() < l ? 1 : 0) != 0);
        Project project = RemoteProjectManager.getInstance().getProject(HOST, USER2, PASSWORD2, PROJECT_NAME, true);
        KnowledgeBase knowledgeBase = project.getKnowledgeBase();
        ((MetaProjectImpl)metaProject).getKnowledgeBase().flushEvents();
        Date date = user.getLastLogin();
        Server_Test.assertTrue((date.getTime() > l ? 1 : 0) != 0);
        Server_Test.assertTrue((user.getLastAccess().getTime() > l ? 1 : 0) != 0);
        l = System.currentTimeMillis();
        Thread.sleep(LastUsageInvocationHandler.ACCESS_TIME_GRANULARITY);
        Server_Test.assertTrue((date.getTime() < l ? 1 : 0) != 0);
        Server_Test.assertTrue((user.getLastAccess().getTime() <= l ? 1 : 0) != 0);
        Thread.sleep(LastUsageInvocationHandler.ACCESS_TIME_GRANULARITY);
        knowledgeBase.createCls("garbage", Collections.singleton(knowledgeBase.getRootCls()));
        ((MetaProjectImpl)metaProject).getKnowledgeBase().flushEvents();
        Server_Test.assertTrue((boolean)date.equals(user.getLastLogin()));
        Server_Test.assertTrue((user.getLastAccess().getTime() > l ? 1 : 0) != 0);
        Server_Test.assertTrue((user.getLastAccess().getTime() <= System.currentTimeMillis() ? 1 : 0) != 0);
        knowledgeBase.getProject().dispose();
        metaProject.dispose();
    }

    public void testDeletionHook() {
        if (!serverRunning) {
            return;
        }
        Project project = RemoteProjectManager.getInstance().getProject(HOST, USER1, PASSWORD1, PROJECT_NAME, true);
        Server_Test.assertNotNull((Object)project);
        KnowledgeBase knowledgeBase = project.getKnowledgeBase();
        DeletionHookJob deletionHookJob = new DeletionHookJob(knowledgeBase);
        deletionHookJob.execute();
        knowledgeBase.deleteCls(knowledgeBase.getCls("Content_Layout"));
        Server_Test.assertTrue((boolean)((Boolean)deletionHookJob.execute()));
        project.dispose();
    }

    public static void setProtegeJarLocation(String string) {
        protegeJarLocation = string;
    }

    public static class DeletionHookJob
    extends ProtegeJob {
        private static final long serialVersionUID = 1L;
        private static boolean installed = false;
        private static boolean deleteFound = false;

        public DeletionHookJob(KnowledgeBase knowledgeBase) {
            super(knowledgeBase);
        }

        public Boolean run() {
            if (!installed) {
                DeletionHookUtil.addDeletionHook(this.getKnowledgeBase(), new DeletionHook(){

                    public void delete(Frame frame) {
                        if (frame.getKnowledgeBase() != null) {
                            deleteFound = true;
                        }
                    }
                });
                installed = true;
            }
            return deleteFound;
        }
    }
}

