/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore;

import edu.stanford.smi.protege.exception.OntologyException;
import edu.stanford.smi.protege.exception.ProtegeException;
import edu.stanford.smi.protege.exception.ProtegeIOException;
import edu.stanford.smi.protege.exception.TransactionException;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculatorStats;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.update.OntologyUpdate;
import edu.stanford.smi.protege.server.update.RemoteResponse;
import edu.stanford.smi.protege.util.AbstractEvent;
import edu.stanford.smi.protege.util.ProtegeJob;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface RemoteServerFrameStore
extends Remote {
    public static final long HEARTBEAT_POLL_INTERVAL = 3000L;
    public static final long HEARTBEAT_CLIENT_DIED = 24000L;

    public Map<RemoteSession, Boolean> getUserInfo() throws RemoteException;

    public FrameCalculatorStats getStats() throws RemoteException;

    public int getClsCount(RemoteSession var1) throws RemoteException;

    public int getSlotCount(RemoteSession var1) throws RemoteException;

    public int getFacetCount(RemoteSession var1) throws RemoteException;

    public int getSimpleInstanceCount(RemoteSession var1) throws RemoteException;

    public int getFrameCount(RemoteSession var1) throws RemoteException;

    public Set<Cls> getClses(RemoteSession var1) throws RemoteException;

    public Set<Facet> getFacets(RemoteSession var1) throws RemoteException;

    public Set<Frame> getFrames(RemoteSession var1) throws RemoteException;

    public RemoteResponse<Frame> getFrame(String var1, RemoteSession var2) throws RemoteException;

    public String getFrameName(Frame var1, RemoteSession var2) throws RemoteException;

    public RemoteResponse<Cls> createCls(FrameID var1, Collection var2, Collection var3, boolean var4, RemoteSession var5) throws RemoteException;

    public RemoteResponse<Slot> createSlot(FrameID var1, Collection var2, Collection var3, boolean var4, RemoteSession var5) throws RemoteException;

    public RemoteResponse<Facet> createFacet(FrameID var1, Collection var2, boolean var3, RemoteSession var4) throws RemoteException;

    public RemoteResponse<SimpleInstance> createSimpleInstance(FrameID var1, Collection var2, boolean var3, RemoteSession var4) throws RemoteException;

    public OntologyUpdate deleteCls(Cls var1, RemoteSession var2) throws RemoteException;

    public OntologyUpdate deleteSlot(Slot var1, RemoteSession var2) throws RemoteException;

    public OntologyUpdate deleteFacet(Facet var1, RemoteSession var2) throws RemoteException;

    public OntologyUpdate deleteSimpleInstance(SimpleInstance var1, RemoteSession var2) throws RemoteException;

    public Set<Slot> getOwnSlots(Frame var1, RemoteSession var2) throws RemoteException;

    public RemoteResponse<List> getDirectOwnSlotValues(Frame var1, Slot var2, RemoteSession var3) throws RemoteException;

    public int getDirectOwnSlotValuesCount(Frame var1, Slot var2, RemoteSession var3) throws RemoteException;

    public OntologyUpdate moveDirectOwnSlotValue(Frame var1, Slot var2, int var3, int var4, RemoteSession var5) throws RemoteException;

    public OntologyUpdate setDirectOwnSlotValues(Frame var1, Slot var2, Collection var3, RemoteSession var4) throws RemoteException;

    public Set getOverriddenTemplateSlots(Cls var1, RemoteSession var2) throws RemoteException;

    public Set getDirectlyOverriddenTemplateSlots(Cls var1, RemoteSession var2) throws RemoteException;

    public OntologyUpdate addDirectTemplateSlot(Cls var1, Slot var2, RemoteSession var3) throws RemoteException;

    public OntologyUpdate removeDirectTemplateSlot(Cls var1, Slot var2, RemoteSession var3) throws RemoteException;

    public OntologyUpdate moveDirectTemplateSlot(Cls var1, Slot var2, int var3, RemoteSession var4) throws RemoteException;

    public RemoteResponse<List> getDirectTemplateSlotValues(Cls var1, Slot var2, RemoteSession var3) throws RemoteException;

    public OntologyUpdate setDirectTemplateSlotValues(Cls var1, Slot var2, Collection var3, RemoteSession var4) throws RemoteException;

    public Set<Facet> getTemplateFacets(Cls var1, Slot var2, RemoteSession var3) throws RemoteException;

    public Set getOverriddenTemplateFacets(Cls var1, Slot var2, RemoteSession var3) throws RemoteException;

    public Set getDirectlyOverriddenTemplateFacets(Cls var1, Slot var2, RemoteSession var3) throws RemoteException;

    public OntologyUpdate removeDirectTemplateFacetOverrides(Cls var1, Slot var2, RemoteSession var3) throws RemoteException;

    public Collection getTemplateFacetValues(Cls var1, Slot var2, Facet var3, RemoteSession var4) throws RemoteException;

    public RemoteResponse<List> getDirectTemplateFacetValues(Cls var1, Slot var2, Facet var3, RemoteSession var4) throws RemoteException;

    public OntologyUpdate setDirectTemplateFacetValues(Cls var1, Slot var2, Facet var3, Collection var4, RemoteSession var5) throws RemoteException;

    public OntologyUpdate addDirectSuperclass(Cls var1, Cls var2, RemoteSession var3) throws RemoteException;

    public OntologyUpdate removeDirectSuperclass(Cls var1, Cls var2, RemoteSession var3) throws RemoteException;

    public OntologyUpdate moveDirectSubclass(Cls var1, Cls var2, int var3, RemoteSession var4) throws RemoteException;

    public OntologyUpdate addDirectSuperslot(Slot var1, Slot var2, RemoteSession var3) throws RemoteException;

    public OntologyUpdate removeDirectSuperslot(Slot var1, Slot var2, RemoteSession var3) throws RemoteException;

    public OntologyUpdate moveDirectSubslot(Slot var1, Slot var2, int var3, RemoteSession var4) throws RemoteException;

    public RemoteResponse<Set<Instance>> getInstances(Cls var1, RemoteSession var2) throws RemoteException;

    public OntologyUpdate addDirectType(Instance var1, Cls var2, RemoteSession var3) throws RemoteException;

    public OntologyUpdate removeDirectType(Instance var1, Cls var2, RemoteSession var3) throws RemoteException;

    public OntologyUpdate moveDirectType(Instance var1, Cls var2, int var3, RemoteSession var4) throws RemoteException;

    public RemoteResponse<List<AbstractEvent>> getEvents(RemoteSession var1) throws RemoteException;

    public Set<Reference> getReferences(Object var1, RemoteSession var2) throws RemoteException;

    public Set<Cls> getClsesWithMatchingBrowserText(String var1, Collection var2, int var3, RemoteSession var4) throws RemoteException;

    public Set<Reference> getMatchingReferences(String var1, int var2, RemoteSession var3) throws RemoteException;

    public Set<Frame> getFramesWithDirectOwnSlotValue(Slot var1, Object var2, RemoteSession var3) throws RemoteException;

    public Set<Frame> getFramesWithAnyDirectOwnSlotValue(Slot var1, RemoteSession var2) throws RemoteException;

    public Set<Frame> getFramesWithMatchingDirectOwnSlotValue(Slot var1, String var2, int var3, RemoteSession var4) throws RemoteException;

    public Set getClsesWithDirectTemplateSlotValue(Slot var1, Object var2, RemoteSession var3) throws RemoteException;

    public Set<Cls> getClsesWithAnyDirectTemplateSlotValue(Slot var1, RemoteSession var2) throws RemoteException;

    public Set getClsesWithMatchingDirectTemplateSlotValue(Slot var1, String var2, int var3, RemoteSession var4) throws RemoteException;

    public Set getClsesWithDirectTemplateFacetValue(Slot var1, Facet var2, Object var3, RemoteSession var4) throws RemoteException;

    public Set getClsesWithMatchingDirectTemplateFacetValue(Slot var1, Facet var2, String var3, int var4, RemoteSession var5) throws RemoteException;

    public RemoteResponse<Collection<Frame>> executeQuery(Query var1, RemoteSession var2) throws OntologyException, ProtegeIOException, RemoteException;

    public RemoteResponse<Set> getDirectOwnSlotValuesClosure(Frame var1, Slot var2, Set<Frame> var3, RemoteSession var4) throws RemoteException;

    public RemoteResponse<Set> getDirectOwnSlotValuesClosure(Collection<Frame> var1, Slot var2, Set<Frame> var3, RemoteSession var4) throws RemoteException;

    public void close(RemoteSession var1) throws RemoteException;

    public RemoteResponse<Object> executeProtegeJob(ProtegeJob var1, RemoteSession var2) throws ProtegeException, RemoteException;

    public RemoteResponse<Boolean> beginTransaction(String var1, RemoteSession var2) throws RemoteException;

    public RemoteResponse<Boolean> commitTransaction(RemoteSession var1) throws RemoteException;

    public RemoteResponse<Boolean> rollbackTransaction(RemoteSession var1) throws RemoteException;

    public Frame getFrame(FrameID var1, RemoteSession var2) throws RemoteException;

    public OntologyUpdate replaceFrame(Frame var1, Frame var2, RemoteSession var3) throws RemoteException;

    public OntologyUpdate preload(Set<String> var1, boolean var2, RemoteSession var3) throws RemoteException;

    public void requestValueCache(Set<Frame> var1, boolean var2, RemoteSession var3) throws RemoteException;

    public TransactionIsolationLevel getTransactionIsolationLevel() throws TransactionException, RemoteException;

    public boolean setTransactionIsolationLevel(TransactionIsolationLevel var1) throws TransactionException, RemoteException;

    public void heartBeat(RemoteSession var1) throws RemoteException;

    public Set<Operation> getAllowedOperations(RemoteSession var1) throws RemoteException;

    public Set<Operation> getKnownOperations(RemoteSession var1) throws RemoteException;
}

