/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.socket.deflate;

import edu.stanford.smi.protege.server.socket.deflate.PacketHeader;
import edu.stanford.smi.protege.util.Log;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Deflater;

public class CompressingOutputStream
extends OutputStream {
    private static Logger log = Log.getLogger(CompressingOutputStream.class);
    public static int COMPRESSION_PAD = 1024;
    public static int BUFFER_SIZE = 131072;
    public static int KB = 1024;
    protected OutputStream os;
    private Deflater deflater;
    private static int counter = 0;
    private int id;
    protected byte[] buffer = new byte[BUFFER_SIZE];
    protected int offset = 0;
    private static int totalBytesWritten = 0;
    private static int totalCompressedBytesWritten = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompressingOutputStream(OutputStream outputStream) {
        this.os = outputStream;
        this.deflater = new Deflater();
        Class<CompressingOutputStream> clazz = CompressingOutputStream.class;
        synchronized (CompressingOutputStream.class) {
            this.id = counter++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void write(int n) throws IOException {
        this.ensureBufferNotFull();
        this.buffer[this.offset++] = (byte)n;
        this.ensureBufferNotFull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        try {
            if (this.offset == 0) {
            } else {
                this.deflater.reset();
                this.deflater.setInput(this.buffer, 0, this.offset);
                this.deflater.finish();
                byte[] byArray = new byte[this.offset + COMPRESSION_PAD];
                this.deflater.deflate(byArray);
                if (!this.deflater.needsInput()) {
                    throw new IOException("Insufficient pad for compression");
                }
                int n = (int)this.deflater.getBytesWritten();
                PacketHeader packetHeader = new PacketHeader((int)this.deflater.getBytesRead(), n);
                this.logPacket(byArray, n);
                packetHeader.write(this.os);
                this.os.write(byArray, 0, n);
            }
        }
        finally {
            this.offset = 0;
        }
        this.os.flush();
    }

    private void ensureBufferNotFull() throws IOException {
        if (this.offset >= BUFFER_SIZE) {
            this.flush();
        }
    }

    protected void logPacket(byte[] byArray, int n) {
        this.logCompressionRatios(n);
        if (!log.isLoggable(Level.FINEST)) {
            return;
        }
        try {
            int n2;
            log.finest("----------------------------------------");
            log.finest("Outgoing packet for writer " + this.id);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Uncompressed buffer of size ");
            stringBuffer.append(this.offset);
            if (n > this.offset) {
                stringBuffer.append(" (compression increased size)");
            }
            stringBuffer.append(": ");
            for (n2 = 0; n2 < this.offset; ++n2) {
                stringBuffer.append(this.buffer[n2]);
                stringBuffer.append(" ");
            }
            log.finest(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            stringBuffer.append("Compressed buffer of size ");
            stringBuffer.append(n);
            stringBuffer.append(": ");
            for (n2 = 0; n2 < n; ++n2) {
                stringBuffer.append(byArray[n2]);
                stringBuffer.append(" ");
            }
            log.finest(stringBuffer.toString());
            log.finest("----------------------------------------");
        }
        catch (Throwable throwable) {
            log.finest("Could not log exitting packet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCompressionRatios(int n) {
        if (!log.isLoggable(Level.FINE)) {
            return;
        }
        Class<CompressingOutputStream> clazz = CompressingOutputStream.class;
        synchronized (CompressingOutputStream.class) {
            int n2 = totalBytesWritten / (KB * KB);
            totalCompressedBytesWritten += n;
            if (n2 < (totalBytesWritten += this.offset) / (KB * KB)) {
                log.fine(String.format("%d MBytes written: Compression ratio = %.3f to 1", totalBytesWritten / (KB * KB), (double)totalBytesWritten / (double)totalCompressedBytesWritten));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

