/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;

public class URIUtilities {
    private static boolean isFile(URI uRI) {
        return "file".equals(uRI.getScheme()) || !uRI.isAbsolute();
    }

    public static String getDisplayText(URI uRI) {
        String string = null;
        if (uRI != null) {
            if (URIUtilities.isFile(uRI)) {
                File file = new File(uRI.toString());
                string = file.getPath();
            } else {
                string = uRI.toString();
            }
        }
        return string;
    }

    public static URI resolve(URI uRI, String string) {
        URI uRI2 = null;
        if (uRI == null) {
            uRI2 = URIUtilities.createURI(string);
        } else {
            String string2 = URIUtilities.replaceURIName(uRI.toString(), string);
            uRI2 = URIUtilities.createURI(string2);
        }
        return uRI2;
    }

    private static String replaceURIName(String string, String string2) {
        String string3 = null;
        int n = string.lastIndexOf(47);
        if (n != -1) {
            string3 = string.substring(0, n + 1) + string2;
        }
        return string3;
    }

    public static String getName(URI uRI) {
        String string;
        String string2 = null;
        if (uRI != null && (string = uRI.getPath()) != null) {
            int n = string.lastIndexOf(47);
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    public static String getBaseName(URI uRI) {
        int n;
        String string = URIUtilities.getName(uRI);
        if (string != null && (n = string.lastIndexOf(46)) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static URI getParentURI(URI uRI) {
        String string;
        int n;
        URI uRI2 = null;
        if (uRI != null && (n = (string = uRI.toString()).lastIndexOf(47)) != -1) {
            string = string.substring(0, n);
            uRI2 = URI.create(string);
        }
        return uRI2;
    }

    public static String getExtension(URI uRI) {
        int n;
        String string = null;
        String string2 = URIUtilities.getName(uRI);
        if (string2 != null && (n = string2.lastIndexOf(46)) != -1) {
            string = string2.substring(n + 1);
        }
        return string;
    }

    public static URL toURL(String string, URI uRI) {
        URL uRL = null;
        if (string != null) {
            URI uRI2 = null;
            try {
                uRI2 = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (uRI2 == null || !uRI2.isAbsolute()) {
                File file = new File(string);
                uRI2 = file.isAbsolute() ? file.toURI() : URIUtilities.resolve(uRI, string);
            }
            if (uRI2 != null && uRI2.isAbsolute()) {
                try {
                    uRL = uRI2.toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return uRL;
    }

    public static URI relativize(URI uRI, URI uRI2) {
        URI uRI3;
        if (uRI == null) {
            uRI3 = uRI2;
        } else {
            try {
                File file = new File(uRI);
                if (!file.isDirectory()) {
                    File file2 = file.getParentFile();
                    uRI = file2.toURI();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            uRI3 = uRI.relativize(uRI2);
        }
        return uRI3;
    }

    public static URI normalize(URI uRI) {
        URI uRI2 = null;
        if (uRI != null && "file".equals((uRI2 = uRI.normalize()).getScheme())) {
            try {
                uRI2 = new File(uRI2).getCanonicalFile().toURI();
            }
            catch (IOException iOException) {
                uRI2 = new File(uRI2).toURI();
            }
        }
        return uRI2;
    }

    public static URI replaceExtension(URI uRI, String string) {
        String string2;
        int n;
        URI uRI2 = null;
        if (uRI != null && (n = (string2 = uRI.toString()).lastIndexOf(46)) != -1) {
            String string3 = string2.substring(0, n) + string;
            uRI2 = URIUtilities.createURI(string3);
        }
        return uRI2;
    }

    public static URI ensureExtension(URI uRI, String string) {
        URI uRI2 = null;
        if (uRI.toString().endsWith(string)) {
            uRI2 = uRI;
        } else {
            try {
                uRI2 = new URI(uRI.toString() + string);
            }
            catch (URISyntaxException uRISyntaxException) {
                Log.getLogger().warning(uRISyntaxException.toString());
            }
        }
        return uRI2;
    }

    public static Writer createBufferedWriter(URI uRI, boolean bl) {
        return FileUtilities.createBufferedWriter(new File(uRI), bl);
    }

    public static BufferedReader createBufferedReader(URI uRI) {
        BufferedReader bufferedReader = null;
        if (uRI != null) {
            try {
                File file = new File(uRI);
                bufferedReader = FileUtilities.createBufferedReader(file);
            }
            catch (Exception exception) {
                try {
                    URL uRL = uRI.toURL();
                    InputStream inputStream = uRL.openStream();
                    bufferedReader = FileUtilities.createBufferedReader(inputStream);
                }
                catch (MalformedURLException malformedURLException) {
                    Log.getLogger().log(Level.WARNING, "Exception caught", malformedURLException);
                }
                catch (IOException iOException) {
                    Log.getLogger().log(Level.WARNING, "Exception caught", iOException);
                }
            }
        }
        return bufferedReader;
    }

    public static URI createURI(String string) {
        URI uRI = null;
        if (string != null && (string = string.trim()).length() != 0) {
            try {
                uRI = URIUtilities.hasSchemePart(string) ? new URI(string) : URIUtilities.createURIFromFileString(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                uRI = URIUtilities.createURIFromFileString(string);
            }
        }
        uRI = URIUtilities.normalize(uRI);
        return uRI;
    }

    public static boolean isURI(String string) {
        return URIUtilities.hasSchemePart(string);
    }

    private static boolean hasSchemePart(String string) {
        int n = string.indexOf(58);
        return n > 1;
    }

    private static URI createURIFromFileString(String string) {
        URI uRI = null;
        try {
            uRI = new File(string).toURI();
            uRI = URIUtilities.normalize(uRI);
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
        }
        return uRI;
    }

    public static boolean isValidURI(String string) {
        try {
            URI uRI = new URI(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isAbsoluteURI(String string) {
        try {
            URI uRI = new URI(string);
            return uRI.isAbsolute();
        }
        catch (Exception exception) {
            return false;
        }
    }
}

