/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util.transaction.cache.impl;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.transaction.cache.Cache;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteableCache<S, V, R>
implements Cache<S, V, R> {
    private Logger logger = Log.getLogger(CompleteableCache.class);
    private CompletionStatus status = CompletionStatus.NORMAL;
    private Set<V> invalidReads = new HashSet<V>();
    private Cache<S, V, R> delegate;

    public CompleteableCache(Cache<S, V, R> cache) {
        this.delegate = cache;
    }

    @Override
    public CacheResult<R> readCache(S s, V v) {
        CacheResult<R> cacheResult = this.delegate.readCache(s, v);
        if (cacheResult.getResult() == null && this.status == CompletionStatus.CACHE_COMPLETE && !this.invalidReads.contains(v) && !cacheResult.isValid()) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Cache " + this.getCacheId() + " is complete - null is valid.");
            }
            return new CacheResult<Object>(null, true);
        }
        return cacheResult;
    }

    @Override
    public void updateCache(S s, V v) {
        if (this.status != CompletionStatus.NORMAL) {
            this.invalidReads.add(v);
        }
        this.delegate.updateCache(s, v);
    }

    @Override
    public void updateCache(S s, V v, R r) {
        if (this.status != CompletionStatus.NORMAL) {
            this.invalidReads.remove(v);
        }
        this.delegate.updateCache(s, v, r);
    }

    @Override
    public void modifyCache(S s, V v) {
        if (this.status != CompletionStatus.NORMAL) {
            this.invalidReads.add(v);
        }
        this.delegate.modifyCache(s, v);
    }

    @Override
    public void modifyCache(S s, V v, R r) {
        if (this.status != CompletionStatus.NORMAL) {
            this.invalidReads.remove(v);
        }
        this.delegate.modifyCache(s, v, r);
    }

    @Override
    public void invalidate(S s) {
        this.delegate.invalidate(s);
    }

    @Override
    public boolean isInvalid() {
        return this.delegate.isInvalid();
    }

    @Override
    public void startCompleteCache() {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Cache " + this.getCacheId() + " starting to complete the cache");
        }
        this.status = CompletionStatus.GETTING_COMPLETE_CACHE;
        this.invalidReads = new HashSet<V>();
        this.delegate.startCompleteCache();
    }

    @Override
    public void finishCompleteCache() {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Cache " + this.getCacheId() + " cache completed");
        }
        if (this.status == CompletionStatus.GETTING_COMPLETE_CACHE) {
            this.status = CompletionStatus.CACHE_COMPLETE;
        }
        this.delegate.finishCompleteCache();
    }

    @Override
    public void abortCompleteCache() {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Cache " + this.getCacheId() + " caching aborted");
        }
        this.status = CompletionStatus.NORMAL;
        this.invalidReads.clear();
        this.delegate.abortCompleteCache();
    }

    @Override
    public boolean isCacheComplete() {
        return this.status == CompletionStatus.CACHE_COMPLETE;
    }

    @Override
    public void beginTransaction(S s) {
        this.delegate.beginTransaction(s);
    }

    @Override
    public void commitTransaction(S s) {
        this.delegate.commitTransaction(s);
    }

    @Override
    public void rollbackTransaction(S s) {
        this.delegate.rollbackTransaction(s);
    }

    @Override
    public int getTransactionNesting(S s) {
        return this.delegate.getTransactionNesting(s);
    }

    @Override
    public void flush() {
        this.localFlush();
        this.delegate.flush();
    }

    private void localFlush() {
        this.status = CompletionStatus.NORMAL;
        this.invalidReads.clear();
    }

    @Override
    public int getCacheId() {
        return this.delegate.getCacheId();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CompletionStatus {
        NORMAL,
        GETTING_COMPLETE_CACHE,
        CACHE_COMPLETE;

    }
}

