/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.Action;
import javax.swing.JList;

public class InverseSlotWidget
extends AbstractSlotWidget {
    private JList _list;
    private AllowableAction _viewAction;
    private AllowableAction _createAction;
    private AllowableAction _addAction;
    private AllowableAction _removeAction;
    private FrameListener _frameListener = new FrameAdapter(){

        public void ownSlotValueChanged(FrameEvent frameEvent) {
            InverseSlotWidget.this.updateWidget();
        }
    };

    private Slot createInverseSlot() {
        Slot slot = null;
        try {
            Slot slot2 = (Slot)this.getInstance();
            this.beginTransaction("create inverse slot for " + slot2.getName(), slot2 == null ? null : "inverse_of_" + slot2.getName());
            String string = "inverse_of_" + slot2.getName();
            while (this.getKnowledgeBase().getFrame(string) != null) {
                string = string + "_";
            }
            Collection collection = this.getSuperslotInverses(slot2);
            Cls cls = this.getKnowledgeBase().getDefaultSlotMetaCls();
            slot = this.getKnowledgeBase().createSlot(string, cls, collection, true);
            Collection collection2 = slot2.getAllowedClses();
            Collection collection3 = slot2.getDirectDomain();
            slot.setAllowedClses(collection3);
            this.setDomain(slot, collection2);
            slot.setAllowsMultipleValues(true);
            this.setInverseSlot(slot);
            this.commitTransaction();
        }
        catch (Exception exception) {
            this.rollbackTransaction();
            Log.getLogger().warning("Could not create inverse slot for: " + this.getInstance());
        }
        return slot;
    }

    private void setDomain(Slot slot, Collection collection) {
        for (Cls cls : collection) {
            cls.addDirectTemplateSlot(slot);
        }
    }

    private Collection getSuperslotInverses(Slot slot) {
        LinkedHashSet<Slot> linkedHashSet = new LinkedHashSet<Slot>();
        for (Slot slot2 : slot.getSuperslots()) {
            Slot slot3 = slot2.getInverseSlot();
            if (slot3 == null) continue;
            linkedHashSet.add(slot3);
        }
        return linkedHashSet;
    }

    private JList createList() {
        SelectableList selectableList = ComponentFactory.createSingleItemList(this.getViewAction());
        selectableList.setCellRenderer(FrameRenderer.createInstance());
        return selectableList;
    }

    private Action getAddAction() {
        if (this._addAction == null) {
            this._addAction = new AddAction(ResourceKey.SLOT_ADD){

                public void onAdd() {
                    InverseSlotWidget.this.selectSlotToAdd();
                }
            };
        }
        return this._addAction;
    }

    private Action getCreateAction() {
        if (this._createAction == null) {
            this._createAction = new CreateAction(ResourceKey.SLOT_CREATE){

                public void onCreate() {
                    Slot slot = InverseSlotWidget.this.createInverseSlot();
                    InverseSlotWidget.this.getProject().show(slot);
                }
            };
        }
        return this._createAction;
    }

    protected Collection getPossibleInverses() {
        ArrayList<Slot> arrayList = new ArrayList<Slot>();
        for (Slot slot : this.getKnowledgeBase().getSlots()) {
            ValueType valueType = slot.getValueType();
            Slot slot2 = slot.getInverseSlot();
            if (slot.isSystem() || !InverseSlotWidget.equals(valueType, ValueType.INSTANCE) || slot2 != null) continue;
            arrayList.add(slot);
        }
        return arrayList;
    }

    private Action getRemoveAction() {
        if (this._removeAction == null) {
            this._removeAction = new RemoveAction(ResourceKey.SLOT_REMOVE, (Selectable)this){

                public void onRemove(Object object) {
                    InverseSlotWidget.this.setInverseSlot(null);
                }
            };
        }
        return this._removeAction;
    }

    public Collection getSelection() {
        return this.getValues();
    }

    public Collection getValues() {
        return ComponentUtilities.getListValues(this._list);
    }

    private Action getViewAction() {
        if (this._viewAction == null) {
            this._viewAction = new ViewAction(ResourceKey.SLOT_VIEW, (Selectable)this){

                public void onView(Object object) {
                    Slot slot = (Slot)object;
                    InverseSlotWidget.this.getProject().show(slot);
                }
            };
        }
        return this._viewAction;
    }

    public void initialize() {
        this._list = this.createList();
        LabeledComponent labeledComponent = new LabeledComponent(this.getLabel(), this._list);
        labeledComponent.addHeaderButton(this.getViewAction());
        labeledComponent.addHeaderButton(this.getCreateAction());
        labeledComponent.addHeaderButton(this.getAddAction());
        labeledComponent.addHeaderButton(this.getRemoveAction());
        if (this.isSlotAtCls()) {
            this._createAction.setAllowed(false);
            this._addAction.setAllowed(false);
            this._removeAction.setAllowed(false);
        }
        this.add(labeledComponent);
        this.setPreferredColumns(2);
        this.setPreferredRows(1);
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return slot.getName().equals(":SLOT-INVERSE");
    }

    private void selectSlotToAdd() {
        Collection collection = this.getPossibleInverses();
        if (collection.isEmpty()) {
            String string = "There are no existing slots which can be used as an inverse.";
            ModalDialog.showMessageDialog(this, string);
        } else {
            Slot slot = DisplayUtilities.pickSlot(this, collection);
            if (slot != null) {
                this.setInverseSlot(slot);
            }
        }
    }

    public void setEditable(boolean bl) {
        this.updateWidget();
    }

    public void setInstance(Instance instance) {
        Instance instance2 = this.getInstance();
        if (instance2 != null && !this.isSlotAtCls()) {
            instance2.removeFrameListener(this._frameListener);
        }
        super.setInstance(instance);
        if (instance != null && !this.isSlotAtCls()) {
            instance.addFrameListener(this._frameListener);
        }
    }

    private void setInverseSlot(Slot slot) {
        Collection<Slot> collection = CollectionUtilities.createCollection(slot);
        ComponentUtilities.setListValues(this._list, collection);
        this.valueChanged();
    }

    public void setValues(Collection collection) {
        ComponentUtilities.setListValues(this._list, collection);
    }

    private void updateWidget() {
        boolean bl;
        Instance instance = this.getInstance();
        boolean bl2 = bl = !this.isSlotAtCls() && instance.isEditable();
        if (bl && instance instanceof Slot) {
            ValueType valueType = ((Slot)instance).getValueType();
            bl = InverseSlotWidget.equals(valueType, ValueType.INSTANCE) || InverseSlotWidget.equals(valueType, ValueType.CLS);
        }
        this._createAction.setAllowed(bl);
        this._addAction.setAllowed(bl);
        this._removeAction.setAllowed(bl);
    }

    public String getLabel() {
        return this.localizeStandardLabel(super.getLabel(), "Inverse Slot", ResourceKey.INVERSE_SLOT_WIDGET_LABEL);
    }
}

