/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DocumentChangedListener;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protege.widget.TextComponentWidget;
import java.awt.Color;
import java.awt.Font;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;

public class YellowStickyWidget
extends AbstractSlotWidget {
    private static final Color YELLOW_STICKY_COLOR = new Color(255, 255, 204);
    private JTextArea _textArea;

    public Collection getValues() {
        String string = this._textArea.getText();
        Collection<Object> collection = (string = string.trim()).length() == 0 ? Collections.EMPTY_LIST : CollectionUtilities.createCollection(string);
        return collection;
    }

    public void addNotify() {
        super.addNotify();
        ComponentUtilities.requestFocus(this._textArea);
    }

    public void initialize() {
        this._textArea = ComponentFactory.createTextArea();
        this._textArea.setBackground(YELLOW_STICKY_COLOR);
        Font font = this._textArea.getFont();
        Font font2 = new Font(font.getName(), 2, font.getSize());
        this._textArea.setFont(font2);
        this._textArea.getDocument().addDocumentListener(new DocumentChangedListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                YellowStickyWidget.this.valueChanged();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this._textArea);
        jScrollPane.setBorder(null);
        this.add(jScrollPane);
        this.setPreferredRows(2);
        this.setPreferredColumns(2);
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return TextComponentWidget.isSuitable(cls, slot, facet);
    }

    public void setBorder(Border border) {
        if (this.isDesignTime()) {
            super.setBorder(border);
        }
    }

    public void setEditable(boolean bl) {
        this._textArea.setEnabled(bl);
    }

    public void setValues(Collection collection) {
        String string = (String)CollectionUtilities.getFirstItem(collection);
        if (string == null) {
            string = "";
        }
        this._textArea.setText(string);
    }
}

