/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.util.FileField;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.URIField;
import edu.stanford.smi.protege.util.URIList;
import edu.stanford.smi.protege.util.Validatable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class KnowledgeBaseSourcesEditor
extends JComponent
implements Validatable {
    private static final long serialVersionUID = 3820797792113838686L;
    private PropertyList _sources;
    private FileField _projectPathField;
    private URIList _includedProjectsList;
    private String _oldProjectPath;
    private boolean _showingProject;

    protected KnowledgeBaseSourcesEditor(String string, PropertyList propertyList) {
        this._sources = propertyList;
        if (string != null) {
            try {
                this._oldProjectPath = new File(URI.create(string)).getAbsolutePath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setLayout(new BorderLayout(10, 10));
        this.add((Component)this.createProjectPathField(), "North");
        this.createIncludedProjectsList();
    }

    public void setShowIncludedProjects(boolean bl) {
        if (this._includedProjectsList != null) {
            this._includedProjectsList.setVisible(bl);
        }
    }

    public JComponent createIncludedProjectsList() {
        this._includedProjectsList = new URIList("Included Projects", null, ".pprj", "Project Files");
        return this._includedProjectsList;
    }

    public JComponent createProjectPathField() {
        this._projectPathField = new FileField("Project", this._oldProjectPath, ".pprj", "Project Files");
        this._projectPathField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                String string = KnowledgeBaseSourcesEditor.this.getProjectPath();
                KnowledgeBaseSourcesEditor.this.onProjectPathChange(KnowledgeBaseSourcesEditor.this._oldProjectPath, string);
                KnowledgeBaseSourcesEditor.this._oldProjectPath = string;
            }
        });
        this._projectPathField.setDialogType(1);
        return this._projectPathField;
    }

    public Collection getIncludedProjects() {
        return this._includedProjectsList == null ? Collections.EMPTY_LIST : this._includedProjectsList.getURIs();
    }

    public String getProjectPath() {
        return this.getProjectPathFromProjectField();
    }

    private String getProjectPathFromProjectField() {
        String string = null;
        if (this._showingProject && (string = this._projectPathField.getPath()) != null) {
            string = FileUtilities.ensureExtension(string, ".pprj");
        }
        return string;
    }

    public PropertyList getSources() {
        return this._sources;
    }

    public void setShowProject(boolean bl) {
        this._showingProject = bl;
        this.remove(this._projectPathField);
        if (this._includedProjectsList != null) {
            this.remove(this._includedProjectsList);
        }
        if (bl) {
            this.add((Component)this._projectPathField, "North");
        } else if (this._includedProjectsList != null) {
            this.add((Component)this._includedProjectsList, "North");
        }
        this.revalidate();
    }

    public boolean isShowingProject() {
        return this._showingProject;
    }

    protected boolean hasValidValue(URIField uRIField) {
        URI uRI = uRIField.getRelativeURI();
        boolean bl = uRI != null;
        return bl;
    }

    protected void onProjectPathChange(String string, String string2) {
    }

    protected void updatePath(FileField fileField, String string, String string2) {
        String string3 = new File(string).getName();
        String string4 = FileUtilities.replaceExtension(string3, string2);
        fileField.setPath(string4);
    }

    protected String getBaseFile(FileField fileField) {
        String string = fileField.getPath();
        if (this._showingProject) {
            int n = string.lastIndexOf(File.separatorChar);
            string = string.substring(n + 1);
        }
        return string;
    }
}

