/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.undo.DeleteFrameCommand;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeleteSlotCommand
extends DeleteFrameCommand {
    private Map<Frame, Collection> directOwnSlotValues = new HashMap<Frame, Collection>();
    private Map<Cls, Collection> directTemplateSlotValues = new HashMap<Cls, Collection>();

    public DeleteSlotCommand(FrameStore frameStore, Slot slot) {
        super(frameStore, slot);
    }

    public Slot getSlot() {
        return (Slot)this.getFrame();
    }

    protected void saveFrame() {
        super.saveFrame();
        this.saveSlot();
    }

    protected void restoreFrame() {
        super.restoreFrame();
        this.restoreSlot();
    }

    private void saveSlot() {
        List list;
        Slot slot = this.getSlot();
        for (Frame frame : this.getDelegate().getFramesWithAnyDirectOwnSlotValue(slot)) {
            list = this.getDelegate().getDirectOwnSlotValues(frame, slot);
            if (list == null || list.isEmpty()) continue;
            this.directOwnSlotValues.put(frame, list);
        }
        for (Cls cls : this.getDelegate().getClsesWithAnyDirectTemplateSlotValue(slot)) {
            list = this.getDelegate().getDirectTemplateSlotValues(cls, slot);
            if (list == null || list.isEmpty()) continue;
            this.directTemplateSlotValues.put(cls, list);
        }
    }

    private void restoreSlot() {
        for (Map.Entry<Frame, Collection> entry : this.directOwnSlotValues.entrySet()) {
            this.getDelegate().setDirectOwnSlotValues(entry.getKey(), this.getSlot(), entry.getValue());
        }
        for (Map.Entry<Frame, Collection> entry : this.directTemplateSlotValues.entrySet()) {
            this.getDelegate().setDirectTemplateSlotValues((Cls)entry.getKey(), this.getSlot(), entry.getValue());
        }
    }
}

