/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore;

import edu.stanford.smi.protege.server.framestore.BandWidthPolicy;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.update.ValueUpdate;
import edu.stanford.smi.protege.server.util.FifoReader;
import edu.stanford.smi.protege.server.util.FifoWriter;
import edu.stanford.smi.protege.util.AbstractEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Registration {
    private static final transient Logger cacheLog = ServerFrameStore.cacheLog;
    private FifoReader<AbstractEvent> events;
    private List<ValueUpdate> updates = new ArrayList<ValueUpdate>();
    private List<ValueUpdate> commitableUpdates = new ArrayList<ValueUpdate>();
    private BandWidthPolicy bandwidthPolicy = new BandWidthPolicy();
    private long lastHeartbeat = 0L;

    public Registration(FifoWriter<AbstractEvent> fifoWriter) {
        this.events = new FifoReader<AbstractEvent>(fifoWriter);
    }

    public FifoReader<AbstractEvent> getEvents() {
        return this.events;
    }

    public List<ValueUpdate> getAndClearValueUpdates() {
        List<ValueUpdate> list = this.updates;
        this.updates = new ArrayList<ValueUpdate>();
        return list;
    }

    public void addUpdate(ValueUpdate valueUpdate) {
        this.updates.add(valueUpdate);
    }

    public void addCommittableUpdate(ValueUpdate valueUpdate) {
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Saving an update for commit/rollback " + valueUpdate);
        }
        this.commitableUpdates.add(valueUpdate);
    }

    public List<ValueUpdate> getCommits() {
        return this.commitableUpdates;
    }

    public void endTransaction() {
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Ending transaction: clearing transaction local events and updates");
        }
        this.commitableUpdates = new ArrayList<ValueUpdate>();
    }

    public BandWidthPolicy getBandWidthPolicy() {
        return this.bandwidthPolicy;
    }

    public long getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    public void setLastHeartbeat(long l) {
        this.lastHeartbeat = l;
    }
}

