/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.ui.LocaleComparator;
import edu.stanford.smi.protege.ui.LocaleRenderer;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.StandardAction;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.Validatable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class GeneralPreferencesPanel
extends Box
implements Validatable {
    private JTextField userNameField;
    private JRadioButton useLoginUserNameButton;
    private JRadioButton useSpecifiedUserNameButton;
    private JRadioButton protegeDefaultLocaleButton;
    private JRadioButton systemDefaultLocaleButton;
    private JRadioButton otherLocaleButton;
    private JComboBox localeComboBox;
    private JCheckBox showWelcomeDialogCheckBox;
    private JCheckBox prettyPrintLabelsCheckBox;
    private JCheckBox sortClassTreeCheckBox;
    private JCheckBox sortSlotTreeCheckBox;

    public GeneralPreferencesPanel() {
        super(1);
        this.add(this.createShowWelcomeDialogCheckBox());
        this.add(this.createPrettyPrintLabelsCheckBox());
        this.add(this.createSortClassTreeCheckBox());
        this.add(this.createSortSlotTreeCheckBox());
        this.add(this.createUsernamePanel());
        this.add(this.createLocalePanel());
    }

    private JComponent createUsernamePanel() {
        String string = ApplicationProperties.getUserName();
        String string2 = SystemUtilities.getUserName();
        Box box = Box.createVerticalBox();
        box.setAlignmentX(0.0f);
        box.setBorder(BorderFactory.createTitledBorder("User Name"));
        Box box2 = Box.createHorizontalBox();
        box2.setAlignmentX(0.0f);
        box2.setBackground(Color.RED);
        box2.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.userNameField = ComponentFactory.createTextField();
        this.userNameField.setColumns(15);
        StandardAction standardAction = new StandardAction("Use Specified Name: "){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GeneralPreferencesPanel.this.useSpecifiedUserNameButton.isSelected()) {
                    GeneralPreferencesPanel.this.userNameField.setEnabled(true);
                } else {
                    GeneralPreferencesPanel.this.userNameField.setText(null);
                    GeneralPreferencesPanel.this.userNameField.setEnabled(false);
                }
            }
        };
        this.useSpecifiedUserNameButton = new JRadioButton(standardAction);
        box2.add(this.useSpecifiedUserNameButton);
        box2.add(this.userNameField);
        this.useLoginUserNameButton = new JRadioButton("Use Login Name: " + string2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.useSpecifiedUserNameButton);
        buttonGroup.add(this.useLoginUserNameButton);
        if (string == null || string.length() == 0 || string2.equals(string)) {
            this.useLoginUserNameButton.setSelected(true);
        } else {
            this.useSpecifiedUserNameButton.setSelected(true);
            this.userNameField.setText(string);
        }
        box.add(this.useLoginUserNameButton);
        box.add(box2);
        return box;
    }

    private JComponent createLocalePanel() {
        Box box = Box.createVerticalBox();
        Locale locale = ApplicationProperties.getLocale();
        Locale locale2 = SystemUtilities.getSystemLocale();
        Locale locale3 = SystemUtilities.getProtegeSystemDefaultLocale();
        box.setBorder(BorderFactory.createTitledBorder("Locale"));
        this.protegeDefaultLocaleButton = new JRadioButton(Text.getProgramName() + " Default:   " + locale3.getDisplayName());
        this.systemDefaultLocaleButton = new JRadioButton("System Default:   " + locale2.getDisplayName());
        this.otherLocaleButton = new JRadioButton("Other:   ");
        this.localeComboBox = ComponentFactory.createComboBox();
        this.localeComboBox.setModel(new DefaultComboBoxModel<Locale>(GeneralPreferencesPanel.getSortedLocales()));
        this.localeComboBox.setRenderer(new LocaleRenderer());
        this.localeComboBox.setEnabled(false);
        if (locale.equals(locale3)) {
            this.protegeDefaultLocaleButton.setSelected(true);
        } else if (locale.equals(locale2)) {
            this.systemDefaultLocaleButton.setSelected(true);
        } else {
            this.otherLocaleButton.setSelected(true);
            this.localeComboBox.setSelectedItem(locale);
            this.localeComboBox.setEnabled(true);
        }
        if (locale2.equals(locale3)) {
            this.systemDefaultLocaleButton.setEnabled(false);
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GeneralPreferencesPanel.this.localeComboBox.setEnabled(GeneralPreferencesPanel.this.otherLocaleButton.isSelected());
            }
        };
        this.protegeDefaultLocaleButton.addActionListener(actionListener);
        this.systemDefaultLocaleButton.addActionListener(actionListener);
        this.otherLocaleButton.addActionListener(actionListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.protegeDefaultLocaleButton);
        buttonGroup.add(this.systemDefaultLocaleButton);
        buttonGroup.add(this.otherLocaleButton);
        Box box2 = Box.createHorizontalBox();
        box2.add(this.otherLocaleButton);
        box2.add(this.localeComboBox);
        box2.setAlignmentX(0.0f);
        box.add(this.protegeDefaultLocaleButton);
        box.add(this.systemDefaultLocaleButton);
        box.add(box2);
        box.setVisible(SystemUtilities.showAlphaFeatures());
        return box;
    }

    private static Locale[] getSortedLocales() {
        Locale[] localeArray = Locale.getAvailableLocales();
        Arrays.sort(localeArray, new LocaleComparator());
        return localeArray;
    }

    private JComponent createShowWelcomeDialogCheckBox() {
        this.showWelcomeDialogCheckBox = ComponentFactory.createCheckBox("Show Welcome Dialog on Start-up");
        this.showWelcomeDialogCheckBox.setSelected(ApplicationProperties.getWelcomeDialogShow());
        return this.showWelcomeDialogCheckBox;
    }

    private JComponent createPrettyPrintLabelsCheckBox() {
        this.prettyPrintLabelsCheckBox = ComponentFactory.createCheckBox("Capitalize Slot Widget Labels");
        this.prettyPrintLabelsCheckBox.setSelected(ApplicationProperties.getPrettyPrintSlotWidgetLabels());
        return this.prettyPrintLabelsCheckBox;
    }

    private Component createSortSlotTreeCheckBox() {
        this.sortSlotTreeCheckBox = ComponentFactory.createCheckBox("Sort slot tree (Slots Tab)");
        this.sortSlotTreeCheckBox.setSelected(ApplicationProperties.getSortSlotTreeOption());
        return this.sortSlotTreeCheckBox;
    }

    private Component createSortClassTreeCheckBox() {
        this.sortClassTreeCheckBox = ComponentFactory.createCheckBox("Sort class tree (Classes Tab)");
        this.sortClassTreeCheckBox.setSelected(ApplicationProperties.getSortClassTreeOption());
        return this.sortClassTreeCheckBox;
    }

    public void saveContents() {
        ApplicationProperties.setUserName(this.userNameField.getText());
        ApplicationProperties.setWelcomeDialogShow(this.showWelcomeDialogCheckBox.isSelected());
        ApplicationProperties.setPrettyPrintSlotWidgetLabels(this.prettyPrintLabelsCheckBox.isSelected());
        ApplicationProperties.setSortClassTreeOption(this.sortClassTreeCheckBox.isSelected());
        ApplicationProperties.setSortSlotTreeOption(this.sortSlotTreeCheckBox.isSelected());
        Locale locale = this.protegeDefaultLocaleButton.isSelected() ? SystemUtilities.getProtegeSystemDefaultLocale() : (this.systemDefaultLocaleButton.isSelected() ? SystemUtilities.getSystemLocale() : (Locale)this.localeComboBox.getSelectedItem());
        ApplicationProperties.setLocale(locale);
    }

    public boolean validateContents() {
        return true;
    }
}

