/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtilities {
    public static void addOwnSlotValue(Frame frame, String string, Object object) {
        Assert.assertNotNull("value", object);
        frame.addOwnSlotValue(ModelUtilities.getSlot(frame, string), object);
    }

    public static Map createValueMap(KnowledgeBase knowledgeBase, KnowledgeBase knowledgeBase2) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (Frame frame : knowledgeBase.getFrames()) {
            if (ModelUtilities.isCopyable(frame)) continue;
            Frame frame2 = knowledgeBase2.getFrame(frame.getName());
            hashMap.put(frame, frame2);
        }
        hashMap.put(knowledgeBase, knowledgeBase2);
        return hashMap;
    }

    private static Facet getFacet(Frame frame, String string) {
        Facet facet = frame.getKnowledgeBase().getFacet(string);
        if (facet == null) {
            Log.getLogger().warning("missing facet: " + string);
        }
        return facet;
    }

    public static Object getOwnSlotValue(Frame frame, String string) {
        Object object;
        Slot slot = ModelUtilities.getSlot(frame, string);
        if (slot == null) {
            object = null;
            Log.getLogger().warning("unknown slot: " + string);
        } else {
            object = frame.getOwnSlotValue(slot);
        }
        return object;
    }

    public static Object getDirectOwnSlotValue(Frame frame, String string) {
        Object object;
        Slot slot = ModelUtilities.getSlot(frame, string);
        if (slot == null) {
            object = null;
            Log.getLogger().warning("unknown slot: " + string);
        } else {
            object = frame.getDirectOwnSlotValue(slot);
        }
        return object;
    }

    public static Collection getOwnSlotValues(Frame frame, String string) {
        Collection collection;
        Slot slot = ModelUtilities.getSlot(frame, string);
        if (slot == null) {
            collection = Collections.EMPTY_LIST;
            Log.getLogger().warning("unknown slot: " + string);
        } else {
            collection = frame.getOwnSlotValues(slot);
        }
        return collection;
    }

    public static List getDirectOwnSlotValues(Frame frame, String string) {
        List list;
        Slot slot = ModelUtilities.getSlot(frame, string);
        if (slot == null) {
            list = Collections.EMPTY_LIST;
            Log.getLogger().warning("unknown slot: " + string);
        } else {
            list = frame.getDirectOwnSlotValues(slot);
        }
        return list;
    }

    public List<Cls> getPath(Cls cls, List<Cls> list) {
        list.add(0, cls);
        Cls cls2 = CollectionUtilities.getFirstItem(cls.getDirectSuperclasses());
        if (cls2 != null) {
            this.getPath(cls2, list);
        }
        return list;
    }

    public static void getPropertyClosureToRoot(Instance instance, Slot slot, Instance instance2, List<Instance> list, Collection<List<Instance>> collection) {
        list.add(0, instance);
        Collection collection2 = instance.getOwnSlotValues(slot);
        for (Object e : collection2) {
            ArrayList<Instance> arrayList;
            if (!(e instanceof Instance)) continue;
            Instance instance3 = (Instance)e;
            if (instance3.equals(instance2)) {
                arrayList = new ArrayList<Instance>(list);
                arrayList.add(0, instance3);
                collection.add(arrayList);
                continue;
            }
            if (list.contains(instance3)) continue;
            arrayList = new ArrayList<Instance>(list);
            ModelUtilities.getPropertyClosureToRoot(instance3, slot, instance2, arrayList, collection);
        }
    }

    public static Collection<List<Instance>> getPropertyClosureToRoot(Instance instance, Slot slot, Instance instance2) {
        ArrayList<List<Instance>> arrayList = new ArrayList<List<Instance>>();
        if (instance.equals(instance2)) {
            arrayList.add(Collections.singletonList(instance2));
            return arrayList;
        }
        ModelUtilities.getPropertyClosureToRoot(instance, slot, instance2, new LinkedList<Instance>(), arrayList);
        return arrayList;
    }

    public static Map<Object, List<Instance>> getPropertyValuesOnPropertyClosureToRoot(Instance instance, Slot slot, Instance instance2, Slot slot2) {
        HashMap<Object, List<Instance>> hashMap = new HashMap<Object, List<Instance>>();
        Collection<List<Instance>> collection = ModelUtilities.getPropertyClosureToRoot(instance, slot, instance2);
        HashSet<Instance> hashSet = new HashSet<Instance>();
        for (List<Instance> object : collection) {
            hashSet.addAll(object);
        }
        for (Instance instance3 : hashSet) {
            Collection collection2 = instance3.getOwnSlotValues(slot2);
            for (Object e : collection2) {
                if (e == null) continue;
                ArrayList<Instance> arrayList = (ArrayList<Instance>)hashMap.get(e);
                if (arrayList == null) {
                    arrayList = new ArrayList<Instance>();
                    hashMap.put(e, arrayList);
                }
                arrayList.add(instance3);
            }
        }
        return hashMap;
    }

    public static Map<Object, List<Instance>> getPropertyValuesOnAllSuperclasses(Cls cls, Slot slot) {
        KnowledgeBase knowledgeBase = cls.getKnowledgeBase();
        Cls cls2 = knowledgeBase.getRootCls();
        Slot slot2 = knowledgeBase.getSystemFrames().getDirectSuperclassesSlot();
        return ModelUtilities.getPropertyValuesOnPropertyClosureToRoot(cls, slot2, cls2, slot);
    }

    public static List<Cls> getPathToRoot(Cls cls) {
        return ModelUtilities.getPathToRoot(cls, new LinkedList<Cls>());
    }

    private static List<Cls> getPathToRoot(Cls cls, LinkedList<Cls> linkedList) {
        linkedList.add(0, cls);
        Iterator<Cls> iterator = cls.getDirectSuperclasses().iterator();
        Cls cls2 = cls.getKnowledgeBase().getRootCls();
        while (iterator.hasNext()) {
            Cls cls3 = iterator.next();
            if (linkedList.contains(cls3) || !cls.isVisible()) continue;
            ArrayList<Cls> arrayList = new ArrayList<Cls>(linkedList);
            ModelUtilities.getPathToRoot(cls3, linkedList);
            if (linkedList.getFirst().equals(cls2)) break;
            linkedList.clear();
            linkedList.addAll(arrayList);
        }
        return linkedList;
    }

    public static Collection<List<Cls>> getPathsToRoot(Cls cls) {
        ArrayList<List<Cls>> arrayList = new ArrayList<List<Cls>>();
        if (cls.equals(cls.getKnowledgeBase().getRootCls())) {
            arrayList.add((List)cls.getKnowledgeBase().getRootClses());
            return arrayList;
        }
        ModelUtilities.getPathsToRoot(cls, new LinkedList<Cls>(), arrayList);
        return arrayList;
    }

    private static void getPathsToRoot(Cls cls, List<Cls> list, Collection<List<Cls>> collection) {
        list.add(0, cls);
        Cls cls2 = cls.getKnowledgeBase().getRootCls();
        Collection<Cls> collection2 = cls.getDirectSuperclasses();
        for (Cls cls3 : collection2) {
            ArrayList<Cls> arrayList;
            if (cls3.equals(cls2)) {
                arrayList = new ArrayList<Cls>(list);
                arrayList.add(0, cls3);
                collection.add(arrayList);
                continue;
            }
            if (list.contains(cls3)) continue;
            arrayList = new ArrayList<Cls>(list);
            ModelUtilities.getPathsToRoot(cls3, arrayList, collection);
        }
    }

    private static Slot getSlot(Frame frame, String string) {
        Assert.assertNotNull("frame", frame);
        Assert.assertNotNull("slot", string);
        Slot slot = frame.getKnowledgeBase().getSlot(string);
        if (slot == null) {
            Log.getLogger().warning("missing slot: " + string);
        }
        return slot;
    }

    public static Object getTemplateFacetValue(Cls cls, Slot slot, String string) {
        Facet facet = ModelUtilities.getFacet(cls, string);
        Object object = facet == null ? null : cls.getTemplateFacetValue(slot, facet);
        return object;
    }

    public static Collection getTemplateFacetValues(Cls cls, Slot slot, String string) {
        Facet facet = ModelUtilities.getFacet(cls, string);
        Collection collection = facet == null ? Collections.EMPTY_LIST : cls.getTemplateFacetValues(slot, facet);
        return collection;
    }

    public static boolean isVisibleInGUI(Frame frame) {
        return frame.getProject().getDisplayHiddenFrames() || frame.isVisible();
    }

    private static boolean isCopyable(Frame frame) {
        return frame instanceof SimpleInstance;
    }

    public static void removeOwnSlotValue(Frame frame, String string, Object object) {
        frame.removeOwnSlotValue(ModelUtilities.getSlot(frame, string), object);
    }

    public static void setOwnSlotValue(Frame frame, String string, Object object) {
        Slot slot = ModelUtilities.getSlot(frame, string);
        if (slot != null) {
            frame.setOwnSlotValue(slot, object);
        } else {
            Log.getLogger().warning("Cannot set value of slot " + string + " at frame " + frame + " to " + object + " Inexistent slot.");
        }
    }

    public static void setOwnSlotValues(Frame frame, String string, Collection collection) {
        Slot slot = ModelUtilities.getSlot(frame, string);
        if (slot != null) {
            frame.setOwnSlotValues(slot, collection);
        } else {
            Log.getLogger().warning("Cannot set values of slot " + string + " at frame " + frame + " to " + collection + " Inexistent slot.");
        }
    }

    public static void setTemplateFacetValue(Cls cls, Slot slot, String string, Object object) {
        cls.setTemplateFacetValue(slot, ModelUtilities.getFacet(cls, string), object);
    }

    public static void setTemplateFacetValues(Cls cls, Slot slot, String string, Collection collection) {
        cls.setTemplateFacetValues(slot, ModelUtilities.getFacet(cls, string), collection);
    }
}

