/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.test.APITestCase;
import java.awt.Rectangle;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Project_Test
extends APITestCase {
    private static boolean disableMissingWebPageTests = true;
    private static final String SUBDIR = "project_subdir";
    private static final String NewspaperJarFileProperty = "junit.project.file.jar.newspaper";
    private static final String IncludingFileProperty = "junit.project.file.including";
    private static final String IncludedFileProperty = "junit.project.file.including";
    private static final String MAP_NAME = "Project_Test.test_map";
    private static final String HTTP_BASE = "http://protege.stanford.edu/";
    private static final String DIR = "applet_demo/Newspaper/";
    private static final String FILE_BASE = "file:/u:/protege_web/";
    private static final String JAR_PROJECT = "newspaper.jar!/samples/examples/newspaper/newspaper.pprj";
    private static final String HTTP_PROJECT_STRING = "http://protege.stanford.edu/applet_demo/Newspaper/newspaper.pprj";
    private static final String HTTP_JAR_PROJECT_STRING = "jar:http://protege.stanford.edu/applet_demo/Newspaper/newspaper.jar!/samples/examples/newspaper/newspaper.pprj";
    private static final String INCLUDED_PROJECT_NAME = "included";
    private static final String MAIN_PROJECT_NAME = "main";

    public void testPropertyMapLoading() {
        Frame frame = this.createFrame();
        String string = frame.getName();
        Map map = new HashMap<Object, Object>();
        this.setClientInformation(MAP_NAME, map);
        Rectangle rectangle = new Rectangle(1, 2, 3, 4);
        map.put(frame, rectangle);
        map.put("foo", "bar");
        Project_Test.saveAndReload();
        frame = this.getFrame(string);
        map = (Map)this.getClientInformation(MAP_NAME);
        Project_Test.assertNotNull((String)"map exists", map);
        Project_Test.assertEquals((String)"string", (Object)"bar", map.get("foo"));
        Project_Test.assertEquals((String)"rectangle", (Object)rectangle, map.get(frame));
    }

    public void testProjectURISaveLoad() {
        Project project = Project_Test.createProjectOnDisk(Project_Test.getTempDirectory(), MAIN_PROJECT_NAME);
        Project_Test.assertNotNull((Object)project);
    }

    private static File getTempSubdirectory() {
        return Project_Test.getTempSubdirectory(SUBDIR);
    }

    private static void deleteTempSubdirectory() {
        Project_Test.deleteTempSubdirectory(SUBDIR);
    }

    private static Project createProjectOnDisk(File file, String string) {
        ArrayList arrayList = new ArrayList();
        Project project = Project.createNewProject(null, arrayList);
        Project_Test.checkErrors(arrayList);
        URI uRI = new File(file, string + ".pprj").toURI();
        project.setProjectURI(uRI);
        KnowledgeBase knowledgeBase = project.getKnowledgeBase();
        Cls cls = knowledgeBase.createCls(null, knowledgeBase.getRootClses());
        Slot slot = knowledgeBase.createSlot(null);
        cls.addDirectTemplateSlot(slot);
        knowledgeBase.createInstance(null, cls);
        int n = knowledgeBase.getFrameCount();
        project.save(arrayList);
        Project_Test.checkErrors(arrayList);
        project.dispose();
        project = Project.loadProjectFromURI(uRI, arrayList);
        Project_Test.checkErrors(arrayList);
        knowledgeBase = project.getKnowledgeBase();
        Project_Test.assertEquals((int)n, (int)knowledgeBase.getFrameCount());
        return project;
    }

    public void testProjectLoadFromFile() {
        Project project = Project_Test.createProjectOnDisk(Project_Test.getTempDirectory(), MAIN_PROJECT_NAME);
        int n = project.getKnowledgeBase().getFrameCount();
        URI uRI = project.getProjectURI();
        ArrayList arrayList = new ArrayList();
        project = Project.loadProjectFromFile(new File(uRI).getPath(), arrayList);
        Project_Test.checkErrors(arrayList);
        int n2 = project.getKnowledgeBase().getFrameCount();
        Project_Test.assertEquals((int)n, (int)n2);
    }

    public void testProjectLoadFromHttpJar() {
        if (!disableMissingWebPageTests) {
            this.loadProjectFromURI(HTTP_JAR_PROJECT_STRING);
        }
    }

    private Project loadProjectFromURI(String string) {
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            Project_Test.fail();
        }
        Project project = Project_Test.loadProjectFromURI(uRI);
        Cls cls = project.getKnowledgeBase().getCls("Editor");
        Project_Test.assertNotNull((Object)cls);
        return project;
    }

    private static Project loadProjectFromURI(URI uRI) {
        ArrayList arrayList = new ArrayList();
        Project project = Project.loadProjectFromURI(uRI, arrayList);
        Project_Test.checkErrors(arrayList);
        return project;
    }

    public void testProjectLoadFromHttp() {
        if (!disableMissingWebPageTests) {
            this.loadProjectFromURI(HTTP_PROJECT_STRING);
        }
    }

    public void testProjectLoadFromFileJar() {
        Properties properties = Project_Test.getJunitProperties();
        String string = properties.getProperty(NewspaperJarFileProperty);
        if (string == null) {
            return;
        }
        try {
            this.loadProjectFromURI(string);
        }
        catch (Exception exception) {
            Project_Test.fail((String)"Exception caught loading jar file");
        }
    }

    public void testIncludeFromSameDirectory() {
        Project project = Project_Test.createProjectOnDisk(Project_Test.getTempDirectory(), MAIN_PROJECT_NAME);
        Project project2 = Project_Test.createProjectOnDisk(Project_Test.getTempDirectory(), INCLUDED_PROJECT_NAME);
        this.checkInclusion(project, project2);
    }

    private void checkInclusion(Project project, Project project2) {
        URI uRI = project.getProjectURI();
        ArrayList arrayList = new ArrayList();
        project.includeProject(project2.getProjectURI(), arrayList);
        Project_Test.checkErrors(arrayList);
        int n = project.getKnowledgeBase().getFrameCount();
        project.save(arrayList);
        Project_Test.checkErrors(arrayList);
        Project project3 = Project_Test.loadProjectFromURI(uRI);
        int n2 = project3.getKnowledgeBase().getFrameCount();
        Project_Test.assertEquals((int)n, (int)n2);
    }

    public void testIncludeFromSubdirectory() {
        Project project = Project_Test.createProjectOnDisk(Project_Test.getTempSubdirectory(), INCLUDED_PROJECT_NAME);
        Project project2 = Project_Test.createProjectOnDisk(Project_Test.getTempDirectory(), MAIN_PROJECT_NAME);
        this.checkInclusion(project2, project);
    }

    public void testIncludeFromSuperdirectory() {
        Project project = Project_Test.createProjectOnDisk(Project_Test.getTempDirectory(), INCLUDED_PROJECT_NAME);
        Project project2 = Project_Test.createProjectOnDisk(Project_Test.getTempSubdirectory(), MAIN_PROJECT_NAME);
        this.checkInclusion(project2, project);
    }

    public void testIncludeWithSaveToSubdirectory() {
        Project project = Project_Test.createProjectOnDisk(Project_Test.getTempSubdirectory(), MAIN_PROJECT_NAME);
        URI uRI = project.getProjectURI();
        Project_Test.deleteTempSubdirectory();
        Project project2 = Project_Test.createProjectOnDisk(Project_Test.getTempDirectory(), INCLUDED_PROJECT_NAME);
        Project project3 = Project_Test.createProjectOnDisk(Project_Test.getTempDirectory(), MAIN_PROJECT_NAME);
        this.checkInclusion(project3, project2);
        Project_Test.getTempSubdirectory();
        project3.setProjectURI(uRI);
        Project_Test.saveAndReload(project);
    }

    private static Project saveAndReload(Project project) {
        ArrayList arrayList = new ArrayList();
        int n = project.getKnowledgeBase().getFrameCount();
        URI uRI = project.getProjectURI();
        project.save(arrayList);
        Project_Test.checkErrors(arrayList);
        project = Project.loadProjectFromURI(uRI, arrayList);
        Project_Test.checkErrors(arrayList);
        int n2 = project.getKnowledgeBase().getFrameCount();
        Project_Test.assertEquals((int)n, (int)n2);
        return project;
    }

    public void testIncludeWithSaveToSuperdirectory() {
        Project project = Project_Test.createProjectOnDisk(Project_Test.getTempDirectory(), MAIN_PROJECT_NAME);
        URI uRI = project.getProjectURI();
        Project_Test.deleteTempSubdirectory();
        Project project2 = Project_Test.createProjectOnDisk(Project_Test.getTempSubdirectory(), INCLUDED_PROJECT_NAME);
        Project project3 = Project_Test.createProjectOnDisk(Project_Test.getTempSubdirectory(), MAIN_PROJECT_NAME);
        this.checkInclusion(project3, project2);
        project3.setProjectURI(uRI);
        Project_Test.saveAndReload(project);
    }

    public void testIncludeFromHttp() {
        if (disableMissingWebPageTests) {
            return;
        }
        Project project = this.loadProjectFromURI(HTTP_PROJECT_STRING);
        Project project2 = Project_Test.createProjectOnDisk(Project_Test.getTempDirectory(), MAIN_PROJECT_NAME);
        this.checkInclusion(project2, project);
    }

    public void testIncludeFromFileJar() {
        Properties properties = Project_Test.getJunitProperties();
        String string = properties.getProperty("junit.project.file.including");
        String string2 = properties.getProperty("junit.project.file.including");
        if (string == null && string2 == null) {
            return;
        }
        Project project = this.loadProjectFromURI(string2);
        Project project2 = Project_Test.createProjectOnDisk(Project_Test.getTempDirectory(), string);
        this.checkInclusion(project2, project);
    }

    public void testIncludeFromHttpJar() {
        if (disableMissingWebPageTests) {
            return;
        }
        Project project = this.loadProjectFromURI(HTTP_JAR_PROJECT_STRING);
        Project project2 = Project_Test.createProjectOnDisk(Project_Test.getTempDirectory(), MAIN_PROJECT_NAME);
        this.checkInclusion(project2, project);
    }

    public void testIsDirtyOnCreateInstance() {
        Project project = this.getProject();
        project.clearIsDirty();
        KnowledgeBase knowledgeBase = project.getKnowledgeBase();
        project.getKnowledgeBase().createInstance(null, knowledgeBase.getRootCls());
        Project_Test.assertTrue((boolean)project.isDirty());
    }
}

