/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.SimpleListModel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListModel;

public class AboutPluginsBox
extends JPanel {
    private static final long serialVersionUID = -6678212119027124508L;
    private JList pluginsList = this.createPluginsList();
    private JEditorPane aboutViewer = AboutPluginsBox.createAboutViewer();

    public AboutPluginsBox() {
        this.layoutComponents();
    }

    private JList createPluginsList() {
        SelectableList selectableList = ComponentFactory.createSelectableList(null);
        ListModel listModel = AboutPluginsBox.createPluginsModel();
        selectableList.setModel(listModel);
        selectableList.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                String string = (String)AboutPluginsBox.this.pluginsList.getSelectedValue();
                if (string != null) {
                    URL uRL = PluginUtilities.getPluginComponentAboutURL(string);
                    try {
                        AboutPluginsBox.this.aboutViewer.setPage(uRL);
                    }
                    catch (IOException iOException) {
                        Log.getLogger().warning(iOException.toString());
                    }
                }
            }
        });
        selectableList.setPreferredSize(new Dimension(150, 150));
        return selectableList;
    }

    private static ListModel createPluginsModel() {
        ArrayList<String> arrayList = new ArrayList<String>(PluginUtilities.getPluginComponentNames());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            URL uRL = PluginUtilities.getPluginComponentAboutURL(string);
            if (uRL != null) continue;
            iterator.remove();
        }
        Collections.sort(arrayList);
        return new SimpleListModel(arrayList);
    }

    private static JEditorPane createAboutViewer() {
        JEditorPane jEditorPane = ComponentFactory.createHTMLBrowser(null);
        jEditorPane.setPreferredSize(new Dimension(600, 600));
        return jEditorPane;
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        LabeledComponent labeledComponent = new LabeledComponent("Installed Plugins", new JScrollPane(this.pluginsList));
        LabeledComponent labeledComponent2 = new LabeledComponent("About Selected Plugin", new JScrollPane(this.aboutViewer));
        JSplitPane jSplitPane = ComponentFactory.createLeftRightSplitPane(labeledComponent, labeledComponent2);
        this.add(jSplitPane);
    }
}

