/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.util.Log;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class FrameStoreMethodInvoker {
    private static Map methodNameToInvokerMap = new HashMap();

    private static void checkInvokers() {
        Method[] methodArray = FrameStore.class.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (methodNameToInvokerMap.containsKey(methodArray[i].getName())) continue;
            Log.getLogger().severe("Missing method invoker: " + methodArray[i].getName());
        }
    }

    private static void addInvoker(String string, Invoker invoker) {
        Invoker invoker2 = methodNameToInvokerMap.put(string, invoker);
        if (invoker2 != null) {
            Log.getLogger().warning("replaced previous invoker: " + string);
        }
    }

    public static Object invoke(Method method, Object[] objectArray, FrameStore frameStore) {
        Invoker invoker = (Invoker)methodNameToInvokerMap.get(method.getName());
        return invoker.invoke(frameStore, objectArray);
    }

    private static int getInteger(Object object) {
        return (Integer)object;
    }

    private static boolean getBoolean(Object object) {
        return (Boolean)object;
    }

    private static void addInvokers() {
        FrameStoreMethodInvoker.addInvoker("getFrameName", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getFrameName((Frame)objectArray[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getName", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getName();
            }
        });
        FrameStoreMethodInvoker.addInvoker("getClsCount", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return new Integer(frameStore.getClsCount());
            }
        });
        FrameStoreMethodInvoker.addInvoker("getSlotCount", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return new Integer(frameStore.getSlotCount());
            }
        });
        FrameStoreMethodInvoker.addInvoker("getFacetCount", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return new Integer(frameStore.getFacetCount());
            }
        });
        FrameStoreMethodInvoker.addInvoker("getSimpleInstanceCount", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return new Integer(frameStore.getSimpleInstanceCount());
            }
        });
        FrameStoreMethodInvoker.addInvoker("getFrameCount", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return new Integer(frameStore.getFrameCount());
            }
        });
        FrameStoreMethodInvoker.addInvoker("getClses", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getClses();
            }
        });
        FrameStoreMethodInvoker.addInvoker("getSlots", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getSlots();
            }
        });
        FrameStoreMethodInvoker.addInvoker("getFacets", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getFacets();
            }
        });
        FrameStoreMethodInvoker.addInvoker("getFrames", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getFrames();
            }
        });
        FrameStoreMethodInvoker.addInvoker("getFrame", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                Frame frame = objectArray[0] instanceof String ? frameStore.getFrame((String)objectArray[0]) : frameStore.getFrame((FrameID)objectArray[0]);
                return frame;
            }
        });
        FrameStoreMethodInvoker.addInvoker("createCls", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.createCls((FrameID)objectArray[0], (Collection)objectArray[1], (Collection)objectArray[2], FrameStoreMethodInvoker.getBoolean(objectArray[3]));
            }
        });
        FrameStoreMethodInvoker.addInvoker("createSlot", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.createSlot((FrameID)objectArray[0], (Collection)objectArray[1], (Collection)objectArray[2], FrameStoreMethodInvoker.getBoolean(objectArray[3]));
            }
        });
        FrameStoreMethodInvoker.addInvoker("createFacet", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.createFacet((FrameID)objectArray[0], (Collection)objectArray[1], FrameStoreMethodInvoker.getBoolean(objectArray[2]));
            }
        });
        FrameStoreMethodInvoker.addInvoker("createSimpleInstance", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.createSimpleInstance((FrameID)objectArray[0], (Collection)objectArray[1], FrameStoreMethodInvoker.getBoolean(objectArray[2]));
            }
        });
        FrameStoreMethodInvoker.addInvoker("deleteCls", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                frameStore.deleteCls((Cls)objectArray[0]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("deleteSlot", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                frameStore.deleteSlot((Slot)objectArray[0]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("deleteFacet", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                frameStore.deleteFacet((Facet)objectArray[0]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("deleteSimpleInstance", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                frameStore.deleteSimpleInstance((SimpleInstance)objectArray[0]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("getOwnSlots", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getOwnSlots((Frame)objectArray[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getOwnSlotValues", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getOwnSlotValues((Frame)objectArray[0], (Slot)objectArray[1]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectOwnSlotValues", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getDirectOwnSlotValues((Frame)objectArray[0], (Slot)objectArray[1]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectOwnSlotValuesCount", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return new Integer(frameStore.getDirectOwnSlotValuesCount((Frame)objectArray[0], (Slot)objectArray[1]));
            }
        });
        FrameStoreMethodInvoker.addInvoker("moveDirectOwnSlotValue", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                frameStore.moveDirectOwnSlotValue((Frame)objectArray[0], (Slot)objectArray[1], FrameStoreMethodInvoker.getInteger(objectArray[2]), FrameStoreMethodInvoker.getInteger(objectArray[3]));
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("setDirectOwnSlotValues", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                frameStore.setDirectOwnSlotValues((Frame)objectArray[0], (Slot)objectArray[1], (Collection)objectArray[2]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("getOwnFacets", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getOwnFacets((Frame)objectArray[0], (Slot)objectArray[1]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getOwnFacetValues", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getOwnFacetValues((Frame)objectArray[0], (Slot)objectArray[1], (Facet)objectArray[2]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getTemplateSlots", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getTemplateSlots((Cls)objectArray[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectTemplateSlots", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getDirectTemplateSlots((Cls)objectArray[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectDomain", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getDirectDomain((Slot)objectArray[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDomain", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getDomain((Slot)objectArray[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getOverriddenTemplateSlots", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getOverriddenTemplateSlots((Cls)objectArray[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectlyOverriddenTemplateSlots", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getDirectlyOverriddenTemplateSlots((Cls)objectArray[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("addDirectTemplateSlot", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                frameStore.addDirectTemplateSlot((Cls)objectArray[0], (Slot)objectArray[1]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("removeDirectTemplateSlot", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                frameStore.removeDirectTemplateSlot((Cls)objectArray[0], (Slot)objectArray[1]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("moveDirectTemplateSlot", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                frameStore.moveDirectTemplateSlot((Cls)objectArray[0], (Slot)objectArray[1], FrameStoreMethodInvoker.getInteger(objectArray[2]));
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("getTemplateSlotValues", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getTemplateSlotValues((Cls)objectArray[0], (Slot)objectArray[1]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectTemplateSlotValues", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getDirectTemplateSlotValues((Cls)objectArray[0], (Slot)objectArray[1]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("setDirectTemplateSlotValues", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                frameStore.setDirectTemplateSlotValues((Cls)objectArray[0], (Slot)objectArray[1], (Collection)objectArray[2]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("getTemplateFacets", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getTemplateFacets((Cls)objectArray[0], (Slot)objectArray[1]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getOverriddenTemplateFacets", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getOverriddenTemplateFacets((Cls)objectArray[0], (Slot)objectArray[1]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectlyOverriddenTemplateFacets", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getDirectlyOverriddenTemplateFacets((Cls)objectArray[0], (Slot)objectArray[1]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("removeDirectTemplateFacetOverrides", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                frameStore.removeDirectTemplateFacetOverrides((Cls)objectArray[0], (Slot)objectArray[1]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("getTemplateFacetValues", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getTemplateFacetValues((Cls)objectArray[0], (Slot)objectArray[1], (Facet)objectArray[2]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectTemplateFacetValues", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getDirectTemplateFacetValues((Cls)objectArray[0], (Slot)objectArray[1], (Facet)objectArray[2]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("setDirectTemplateFacetValues", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                frameStore.setDirectTemplateFacetValues((Cls)objectArray[0], (Slot)objectArray[1], (Facet)objectArray[2], (Collection)objectArray[3]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectSuperclasses", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getDirectSuperclasses((Cls)objectArray[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getSuperclasses", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getSuperclasses((Cls)objectArray[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectSuperclasses", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getDirectSuperclasses((Cls)objectArray[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectSubclasses", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getDirectSubclasses((Cls)objectArray[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getSubclasses", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getSubclasses((Cls)objectArray[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectSuperclasses", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getDirectSuperclasses((Cls)objectArray[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("addDirectSuperclass", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                frameStore.addDirectSuperclass((Cls)objectArray[0], (Cls)objectArray[1]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("removeDirectSuperclass", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                frameStore.removeDirectSuperclass((Cls)objectArray[0], (Cls)objectArray[1]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("moveDirectSubclass", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                frameStore.moveDirectSubclass((Cls)objectArray[0], (Cls)objectArray[1], FrameStoreMethodInvoker.getInteger(objectArray[2]));
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectSuperslots", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getDirectSuperslots((Slot)objectArray[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getSuperslots", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getSuperslots((Slot)objectArray[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectSubslots", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getDirectSubslots((Slot)objectArray[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getSubslots", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getSubslots((Slot)objectArray[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("addDirectSuperslot", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                frameStore.addDirectSuperslot((Slot)objectArray[0], (Slot)objectArray[1]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("removeDirectSuperslot", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                frameStore.removeDirectSuperslot((Slot)objectArray[0], (Slot)objectArray[1]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("moveDirectSubslot", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                frameStore.moveDirectSubslot((Slot)objectArray[0], (Slot)objectArray[1], FrameStoreMethodInvoker.getInteger(objectArray[2]));
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("getFrameName", new Invoker(){

            public Object invoke(FrameStore frameStore, Object[] objectArray) {
                return frameStore.getFrameName((Frame)objectArray[0]);
            }
        });
    }

    static {
        FrameStoreMethodInvoker.addInvokers();
        FrameStoreMethodInvoker.checkInvokers();
    }

    static interface Invoker {
        public Object invoke(FrameStore var1, Object[] var2);
    }
}

