/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.storage.database.DatabasePlugin;
import edu.stanford.smi.protege.storage.database.DatabaseProperty;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.Wizard;
import edu.stanford.smi.protege.util.WizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DatabaseWizardPage
extends WizardPage {
    private static final long serialVersionUID = -6619215858750011057L;
    private Map<DatabaseProperty, JTextField> fields = new EnumMap<DatabaseProperty, JTextField>(DatabaseProperty.class);
    private JTextArea errorArea;
    private DatabasePlugin plugin;
    private static int MAX_TABLE_NAME_LENGTH = 20;

    public DatabaseWizardPage(Wizard wizard, DatabasePlugin databasePlugin) {
        super("datbase", wizard);
        this.plugin = databasePlugin;
        this.createComponents();
        this.layoutComponents();
        this.updateSetPageComplete();
    }

    private void createComponents() {
        for (DatabaseProperty databaseProperty : DatabaseProperty.values()) {
            if (databaseProperty == DatabaseProperty.PASSWORD_PROPERTY) {
                this.fields.put(databaseProperty, this.createPasswordTextField());
                continue;
            }
            this.fields.put(databaseProperty, this.createTextField(databaseProperty));
        }
        this.errorArea = ComponentFactory.createTextArea();
        this.errorArea.setEditable(false);
    }

    private JTextField createTextField(final DatabaseProperty databaseProperty) {
        String string = DatabaseProperty.getProperty(databaseProperty);
        final JTextField jTextField = ComponentFactory.createTextField(string);
        jTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                DatabaseWizardPage.this.updateSetPageComplete();
                DatabaseProperty.setProperty(databaseProperty, jTextField.getText());
            }
        });
        return jTextField;
    }

    private JTextField createPasswordTextField() {
        JPasswordField jPasswordField = ComponentFactory.createPasswordField();
        jPasswordField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                DatabaseWizardPage.this.updateSetPageComplete();
            }
        });
        return jPasswordField;
    }

    protected void updateSetPageComplete() {
        this.setErrorText(null);
        this.setPageComplete(this.isComplete());
    }

    protected boolean isComplete() {
        return this.hasValidDriver() && this.hasValidUrl() && this.hasValidTable();
    }

    private boolean hasValidDriver() {
        boolean bl = false;
        String string = this.getFieldText(DatabaseProperty.DRIVER_PROPERTY);
        if ((string = string.trim()).length() == 0) {
            this.setErrorText("Driver class required");
        } else {
            Class clazz = SystemUtilities.forName(string);
            boolean bl2 = bl = clazz != null;
            if (clazz == null) {
                this.setErrorText("Driver class not found");
            }
        }
        return bl;
    }

    private boolean hasValidUrl() {
        boolean bl = false;
        String string = this.getFieldText(DatabaseProperty.URL_PROPERTY);
        string = string.trim();
        String string2 = this.getFieldText(DatabaseProperty.USERNAME_PROPERTY);
        String string3 = this.getFieldText(DatabaseProperty.PASSWORD_PROPERTY);
        if (string.length() == 0) {
            this.setErrorText("URL is required");
        } else if (string2.length() == 0) {
            this.setErrorText("Username is required");
        } else {
            try {
                Connection connection = DriverManager.getConnection(string, string2, string3);
                connection.close();
                bl = true;
            }
            catch (SQLException sQLException) {
                this.setErrorText("Invalid URL, username, or password:\n" + sQLException.getMessage());
            }
        }
        return bl;
    }

    private boolean hasValidTable() {
        boolean bl = false;
        String string = this.getFieldText(DatabaseProperty.TABLENAME_PROPERTY);
        if (string.length() == 0) {
            this.setErrorText("Table name is required.");
        } else if (string.length() > MAX_TABLE_NAME_LENGTH) {
            this.setErrorText("Table name is too long.");
        } else {
            bl = true;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isJavaIdentifierPart(c)) continue;
                bl = false;
                break;
            }
            if (!bl) {
                this.setErrorText("Invalid table name");
            }
        }
        return bl;
    }

    protected void setErrorText(String string) {
        this.errorArea.setText(string);
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        Box box = Box.createVerticalBox();
        this.layoutComponents(box);
    }

    protected void layoutComponents(Box box) {
        for (DatabaseProperty databaseProperty : DatabaseProperty.values()) {
            this.addField(box, databaseProperty);
        }
        this.errorArea.setPreferredSize(new Dimension(10, 50));
        this.errorArea.setBackground(this.getBackground());
        box.add(Box.createVerticalStrut(20));
        box.add(ComponentFactory.createScrollPane(this.errorArea));
        this.add((Component)box, "North");
    }

    private void addField(Box box, DatabaseProperty databaseProperty) {
        box.add(new LabeledComponent(databaseProperty.getTitle(), this.fields.get((Object)databaseProperty)));
    }

    public void onFinish() {
        this.plugin.setDriver(this.getFieldText(DatabaseProperty.DRIVER_PROPERTY));
        this.plugin.setTable(this.getFieldText(DatabaseProperty.TABLENAME_PROPERTY));
        this.plugin.setUsername(this.getFieldText(DatabaseProperty.USERNAME_PROPERTY));
        this.plugin.setPassword(this.getFieldText(DatabaseProperty.PASSWORD_PROPERTY));
        this.plugin.setURL(this.getFieldText(DatabaseProperty.URL_PROPERTY));
    }

    protected String getFieldText(DatabaseProperty databaseProperty) {
        return this.fields.get((Object)databaseProperty).getText();
    }
}

