/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.WaitCursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TreeSelectionHelper<X> {
    private JTree tree;

    public TreeSelectionHelper(JTree jTree) {
        this.tree = jTree;
    }

    protected abstract Collection<X> getParents(X var1);

    protected boolean isVisible(X x) {
        return true;
    }

    protected Collection<X> getRoots() {
        ArrayList arrayList = new ArrayList((Collection)((LazyTreeNode)this.tree.getModel().getRoot()).getUserObject());
        return arrayList;
    }

    public void setSelectedNode(X x) {
        WaitCursor waitCursor = new WaitCursor(this.tree);
        ArrayList arrayList = new ArrayList();
        this.getVisiblePathToRoot(x, arrayList);
        Collections.reverse(arrayList);
        ComponentUtilities.setSelectedObjectPath(this.tree, arrayList);
        waitCursor.hide();
    }

    protected Collection<X> filterHiddenRoots(Collection<X> collection) {
        Iterator<X> iterator = collection.iterator();
        while (iterator.hasNext()) {
            X x = iterator.next();
            if (this.isVisible(x)) continue;
            iterator.remove();
        }
        return collection;
    }

    public void getVisiblePathToRoot(X x, Collection<X> collection) {
        boolean bl;
        Collection<X> collection2 = this.filterHiddenRoots(this.getRoots());
        collection.add(x);
        if (!collection2.contains(x) && !(bl = this.getVisiblePathToRoot(x, collection2, collection))) {
            Log.getLogger().warning("No visible path found for " + x);
        }
    }

    private boolean getVisiblePathToRoot(X x, Collection<X> collection, Collection<X> collection2) {
        boolean bl = false;
        Iterator<X> iterator = this.getParents(x).iterator();
        while (iterator.hasNext() && !bl) {
            X x2 = iterator.next();
            if (!this.isVisible(x2) || collection2.contains(x2)) continue;
            collection2.add(x2);
            bl = collection.contains(x2) ? true : this.getVisiblePathToRoot(x2, collection, collection2);
            if (bl) continue;
            collection2.remove(x2);
        }
        return bl;
    }
}

