/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util.transaction.cache.impl;

import edu.stanford.smi.protege.util.transaction.cache.Cache;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicCache<S, V, R>
implements Cache<S, V, R> {
    private Map<V, R> cache = new HashMap<V, R>();
    private Map<S, Integer> transactionNestingMap = new HashMap<S, Integer>();
    private static int idCounter = 0;
    private int id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicCache() {
        Class<BasicCache> clazz = BasicCache.class;
        synchronized (BasicCache.class) {
            this.id = idCounter++;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public CacheResult<R> readCache(S s, V v) {
        return new CacheResult<R>(this.cache.get(v), this.cache.containsKey(v));
    }

    @Override
    public void updateCache(S s, V v) {
    }

    @Override
    public void updateCache(S s, V v, R r) {
        this.cache.put(v, r);
    }

    @Override
    public void modifyCache(S s, V v) {
        this.cache.remove(v);
    }

    @Override
    public void modifyCache(S s, V v, R r) {
        this.cache.put(v, r);
    }

    @Override
    public void invalidate(S s) {
    }

    @Override
    public boolean isInvalid() {
        return false;
    }

    @Override
    public void startCompleteCache() {
    }

    @Override
    public void finishCompleteCache() {
    }

    @Override
    public void abortCompleteCache() {
    }

    @Override
    public boolean isCacheComplete() {
        return false;
    }

    @Override
    public void beginTransaction(S s) {
        Integer n = this.transactionNestingMap.get(s);
        if (n == null) {
            this.transactionNestingMap.put(s, 1);
            return;
        }
        this.transactionNestingMap.put(s, n + 1);
    }

    @Override
    public void commitTransaction(S s) {
        this.decrementTransaction(s);
    }

    @Override
    public void rollbackTransaction(S s) {
        this.decrementTransaction(s);
    }

    private void decrementTransaction(S s) {
        Integer n = this.transactionNestingMap.get(s);
        if (n == null) {
            this.transactionNestingMap.put(s, -1);
        } else if (n == 1) {
            this.transactionNestingMap.remove(s);
        } else {
            this.transactionNestingMap.put(s, n - 1);
        }
    }

    @Override
    public int getTransactionNesting(S s) {
        Integer n = this.transactionNestingMap.get(s);
        if (n == null) {
            return 0;
        }
        return n;
    }

    @Override
    public void flush() {
        this.transactionNestingMap.clear();
        this.cache.clear();
    }

    @Override
    public int getCacheId() {
        return this.id;
    }
}

