/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.InstanceDisplay;
import edu.stanford.smi.protege.ui.SubslotPane;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.widget.AbstractTabWidget;
import edu.stanford.smi.protege.widget.SuperslotsPanel;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JSplitPane;

public class SlotsTab
extends AbstractTabWidget {
    private static final long serialVersionUID = 1274808722828634747L;
    private SubslotPane _slotsPanel;
    private SuperslotsPanel _superslotsPanel;
    private InstanceDisplay _slotDisplay;
    private JSplitPane _mainSplitter;
    private JSplitPane _clsesSplitter;

    private JComponent createMainSplitter() {
        this._mainSplitter = this.createLeftRightSplitPane("SlotsTab.left_right", 250);
        this._mainSplitter.setLeftComponent(this.createSlotsSplitter());
        this._slotDisplay = (InstanceDisplay)this.createSlotDisplay();
        this._mainSplitter.setRightComponent(this._slotDisplay);
        return this._mainSplitter;
    }

    private JComponent createSuperslotsPanel() {
        this._superslotsPanel = new SuperslotsPanel(this.getProject());
        this._superslotsPanel.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                Collection collection = SlotsTab.this._superslotsPanel.getSelection();
                if (collection.size() == 1) {
                    Slot slot = (Slot)CollectionUtilities.getFirstItem(collection);
                    SlotsTab.this._slotsPanel.setDisplayParent(slot);
                }
            }
        });
        return this._superslotsPanel;
    }

    protected JComponent createSlotDisplay() {
        return new InstanceDisplay(this.getProject());
    }

    private JComponent createSlotsPanel() {
        this._slotsPanel = new SubslotPane(this.getProject());
        this._slotsPanel.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                SlotsTab.this.transmitSelection();
            }
        });
        return this._slotsPanel;
    }

    private JComponent createSlotsSplitter() {
        this._clsesSplitter = this.createTopBottomSplitPane("SlotTab.left.top_bottom", 400);
        this._clsesSplitter.setTopComponent(this.createSlotsPanel());
        this._clsesSplitter.setBottomComponent(this.createSuperslotsPanel());
        return this._clsesSplitter;
    }

    public LabeledComponent getLabeledComponent() {
        return this._slotsPanel.getLabeledComponent();
    }

    public void initialize() {
        this.setIcon(Icons.getSlotIcon());
        this.setLabel(LocalizedText.getText(ResourceKey.SLOTS_VIEW_TITLE));
        this.add(this.createMainSplitter());
        this.transmitSelection();
        this.setClsTree(this._slotsPanel.getDropComponent());
    }

    private void transmitSelection() {
        Slot slot = (Slot)CollectionUtilities.getFirstItem(this._slotsPanel.getSelection());
        this._superslotsPanel.setSlot(slot, this._slotsPanel.getDisplayParent());
        this._slotDisplay.setInstance(slot);
    }
}

