/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.OwnSlotValueFrameRenderer;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.DeleteAction;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ListSelectionListenerAdapter;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.SwitchableListSelectionListener;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protege.widget.ReadOnlyWidgetConfigurationPanel;
import edu.stanford.smi.protege.widget.WidgetConfigurationPanel;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public abstract class AbstractListWidget
extends AbstractSlotWidget {
    private JList _list;
    private LabeledComponent _labeledComponent;
    private SwitchableListSelectionListener _listListener = new ListSelectionListenerAdapter(this);

    protected AbstractListWidget() {
        this.setPreferredColumns(2);
        this.setPreferredRows(2);
    }

    protected JList getList() {
        return this._list;
    }

    public void addButton(Action action) {
        this.addButton(action, true);
    }

    public void addButton(Action action, boolean bl) {
        if (action != null) {
            this.addButtonConfiguration(action, bl);
            if (this.displayButton(action)) {
                this._labeledComponent.addHeaderButton(action);
            }
        }
    }

    public void addItem(Object object) {
        ComponentUtilities.addListValue(this._list, object);
    }

    public void addItems(Collection collection) {
        ComponentUtilities.addListValues(this._list, collection);
    }

    public boolean contains(Object object) {
        return ComponentUtilities.listValuesContain(this._list, object);
    }

    private JComponent createLabeledComponent(Action action) {
        this._list = ComponentFactory.createList(action, true);
        this._list.getModel().addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                AbstractListWidget.this.valueChanged();
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                AbstractListWidget.this.valueChanged();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                AbstractListWidget.this.valueChanged();
            }
        });
        this._list.setCellRenderer(this.createRenderer());
        this._list.addListSelectionListener(this._listListener);
        this._labeledComponent = new LabeledComponent(this.getLabel(), ComponentFactory.createScrollPane(this._list));
        return this._labeledComponent;
    }

    protected ListCellRenderer createRenderer() {
        return FrameRenderer.createInstance();
    }

    protected LabeledComponent getLabeledComponent() {
        return this._labeledComponent;
    }

    public Collection getSelection() {
        return ComponentUtilities.getSelection(this._list);
    }

    public Collection getValues() {
        return ComponentUtilities.getListValues(this._list);
    }

    public void initialize() {
        this.initialize(this.getDoubleClickAction());
        this.setEditable(true);
    }

    public void initialize(Action action) {
        this.add(this.createLabeledComponent(action));
    }

    public void removeAllItems() {
        ComponentUtilities.clearListValues(this._list);
    }

    public void removeItem(Object object) {
        if (this.isDirectValue(object)) {
            ComponentUtilities.removeListValue(this._list, object);
        } else {
            SystemUtilities.beep();
        }
    }

    public void removeItems(Collection collection) {
        if (this.canRemove(collection)) {
            ComponentUtilities.removeListValues(this._list, collection);
        } else {
            SystemUtilities.beep();
        }
    }

    protected boolean canRemove(Collection collection) {
        return this.areDirectValues(collection);
    }

    public void replaceItem(Object object, Object object2) {
        ComponentUtilities.replaceListValue(this._list, object, object2);
    }

    public void setEditable(boolean bl) {
        bl = bl && !this.isReadOnlyConfiguredWidget();
        for (Action action : this._labeledComponent.getHeaderButtonActions()) {
            if (!(action instanceof CreateAction) && !(action instanceof AddAction) && !(action instanceof RemoveAction) && !(action instanceof DeleteAction)) continue;
            ((AllowableAction)action).setAllowed(bl);
        }
    }

    public void setInstance(Instance instance) {
        super.setInstance(instance);
        this._list.setCellRenderer(new OwnSlotValueFrameRenderer(instance, this.getSlot()));
    }

    public void setRenderer(ListCellRenderer listCellRenderer) {
        this._list.setCellRenderer(listCellRenderer);
    }

    public void setSelection(Object object) {
        this._list.setSelectedValue(object, true);
    }

    public void setValues(Collection collection) {
        ComponentUtilities.setListValues(this._list, collection);
    }

    public WidgetConfigurationPanel createWidgetConfigurationPanel() {
        WidgetConfigurationPanel widgetConfigurationPanel = super.createWidgetConfigurationPanel();
        widgetConfigurationPanel.addTab("Options", new ReadOnlyWidgetConfigurationPanel(this));
        return widgetConfigurationPanel;
    }
}

