/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.exception.TransactionException;
import edu.stanford.smi.protege.model.framestore.AbstractFrameStoreInvocationHandler;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.MethodCall;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.util.CacheMap;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.lang.reflect.Method;
import java.util.Collection;

public class CallCachingFrameStore
extends AbstractFrameStoreInvocationHandler {
    private static final int MAX_SIZE = 100000;
    private CacheMap _cache = new CacheMap(100000);
    private MethodCall _lookupMethodCall = new MethodCall();
    private TransactionMonitor transactionMonitor;
    private int hit = 0;
    private int miss = 0;

    protected Object handleInvoke(Method method, Object[] objectArray) {
        Object object;
        if (CallCachingFrameStore.isGetEvents(method)) {
            object = this.invoke(method, objectArray);
            Collection collection = (Collection)object;
            if (!collection.isEmpty()) {
                this.clearCache();
            }
        } else if (CallCachingFrameStore.isQuery(method)) {
            object = this.query(method, objectArray);
        } else {
            this._cache.clear();
            object = this.invoke(method, objectArray);
        }
        return object;
    }

    public void executeQuery(Query query, QueryCallback queryCallback) {
        this.getDelegate().executeQuery(query, queryCallback);
    }

    private static boolean isGetEvents(Method method) {
        return method.getName().equals("getEvents");
    }

    private Object query(Method method, Object[] objectArray) {
        boolean bl = false;
        try {
            bl = this.transactionMonitor != null && this.transactionMonitor.inTransaction() && this.transactionMonitor.getTransationIsolationLevel() == TransactionIsolationLevel.SERIALIZABLE;
        }
        catch (TransactionException transactionException) {
            bl = true;
        }
        this._lookupMethodCall.set(method, objectArray);
        Object object = this._cache.get(this._lookupMethodCall);
        if (object == null || bl) {
            ++this.miss;
            object = this.invoke(method, objectArray);
            if (this.transactionMonitor == null || !this.transactionMonitor.existsTransaction()) {
                this._cache.put(new MethodCall(method, objectArray), object);
            }
        } else {
            ++this.hit;
        }
        return object;
    }

    private void clearCache() {
        this._cache.clear();
    }

    public void handleClose() {
        this._cache.clear();
        this._cache = null;
    }

    protected void handleReinitialize() {
        this._cache.clear();
    }

    protected void setDelegate(FrameStore frameStore) {
        super.setDelegate(frameStore);
        if (frameStore != null) {
            this.transactionMonitor = frameStore.getTransactionStatusMonitor();
        }
    }
}

