/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.event.ServerProjectNotificationEvent;
import edu.stanford.smi.protege.event.ServerProjectSessionClosedEvent;
import edu.stanford.smi.protege.event.ServerProjectStatusChangeEvent;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.EventGeneratorFrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.plugin.ProjectPluginManager;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.server.ProtegeRmiClassLoaderSpi;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteServerProject;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.ServerProject;
import edu.stanford.smi.protege.server.ServerProperties;
import edu.stanford.smi.protege.server.Session;
import edu.stanford.smi.protege.server.framestore.LocalizeFrameStoreHandler;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerSessionLost;
import edu.stanford.smi.protege.server.metaproject.MetaProject;
import edu.stanford.smi.protege.server.metaproject.MetaProjectConstants;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.metaproject.Policy;
import edu.stanford.smi.protege.server.metaproject.PolicyControlledObject;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.server.metaproject.ServerInstance;
import edu.stanford.smi.protege.server.metaproject.User;
import edu.stanford.smi.protege.server.metaproject.impl.MetaProjectImpl;
import edu.stanford.smi.protege.server.socket.RmiSocketFactory;
import edu.stanford.smi.protege.server.socket.SSLFactory;
import edu.stanford.smi.protege.server.util.ProjectInfo;
import edu.stanford.smi.protege.server.util.ServerUtil;
import edu.stanford.smi.protege.storage.clips.ClipsKnowledgeBaseFactory;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ServerJob;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.URIUtilities;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
extends UnicastRemoteObject
implements RemoteServer {
    private static final long serialVersionUID = 1675054259604532947L;
    private static final transient Logger log = Log.getLogger(Server.class);
    public static final int NO_SAVE = -1;
    private static final String SAVE_INTERVAL_OPTION = "-saveIntervalSec=";
    private static final String NOPRELOAD_OPTION = "-nopreload";
    private static final String OPTION_CHAR = "-";
    private ThreadFactory daemonizingThreadFactory = new ThreadFactory(){

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    };
    private final ExecutorService serverExecutor = Executors.newCachedThreadPool(this.daemonizingThreadFactory);
    private final ExecutorService singleJobAtATimeExecutor = Executors.newSingleThreadExecutor(this.daemonizingThreadFactory);
    private URI metaprojectURI;
    private URI _baseURI;
    private boolean preload = true;
    private volatile int _saveIntervalMsec = -1;
    private static volatile Server serverInstance;
    private ServerProject serverMetaProject;
    private volatile Thread _updateThread;
    private MetaProject metaproject;
    private FrameListener metaprojectFrameListener;
    private FrameListener metaprojectProjectClsListener;
    private Cls projectCls;
    private Slot nameSlot;
    private final ProjectPluginManager _projectPluginManager = new ProjectPluginManager();
    private final Map<String, Project> _nameToOpenProjectMap = new HashMap<String, Project>();
    private final Map<String, ServerProject.ProjectStatus> _nameToProjectStatusMap = new TreeMap<String, ServerProject.ProjectStatus>();
    private final Map<Project, ServerProject> _projectToServerProjectMap = new HashMap<Project, ServerProject>();
    private final Map<RemoteSession, Collection<ServerProject>> _sessionToProjectsMap = new HashMap<RemoteSession, Collection<ServerProject>>();
    private List<RemoteSession> _sessions = Collections.synchronizedList(new ArrayList());
    private final Map<String, FutureTask<Object>> projectToShutdownTaskNotificationMap = new HashMap<String, FutureTask<Object>>();

    public static void main(String[] stringArray) {
        try {
            Server.startServer(stringArray);
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "server startup failed", exception);
        }
    }

    public static void startServer(String[] stringArray) throws IOException {
        Log.getLogger().info("Protege server is starting...");
        SystemUtilities.logSystemInfo();
        System.setProperty("java.rmi.server.RMIClassLoaderSpi", ProtegeRmiClassLoaderSpi.class.getName());
        Server.checkRegistry();
        SystemUtilities.initialize();
        serverInstance = new Server(stringArray);
        Server.afterLoad();
        serverInstance.bindName();
        Log.getLogger().info("Protege server ready to accept connections...");
    }

    private static void checkRegistry() throws IOException {
        try {
            Server.getRegistry().list();
        }
        catch (RemoteException remoteException) {
            log.log(Level.WARNING, "Is the registry running?", remoteException);
            throw new IOException("Could not connect to the rmi registry task");
        }
    }

    private static void afterLoad() {
        for (Map.Entry<String, Project> entry : Server.serverInstance._nameToOpenProjectMap.entrySet()) {
            String string = entry.getKey();
            Project project = entry.getValue();
            Log.getLogger().info("Loading project plugins for project " + string);
            Server.serverInstance._projectPluginManager.afterLoad(project);
        }
    }

    public static Server getInstance() {
        return serverInstance;
    }

    public static Policy getPolicy() {
        return Server.serverInstance.metaproject.getPolicy();
    }

    public static String getBoundName() {
        return Text.getProgramTextName();
    }

    protected static String getLocalBoundName() {
        return Server.getBoundName();
    }

    public int getSaveIntervalMsec() {
        return this._saveIntervalMsec;
    }

    public void setSaveIntervalMsec(int n) {
        this._saveIntervalMsec = n;
    }

    private static Registry getRegistry() throws RemoteException {
        int n = Integer.getInteger("protege.rmi.registry.port", 1099);
        return LocateRegistry.getRegistry(null, n);
    }

    private void parseArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.parseArg(stringArray[i]);
        }
    }

    protected void parseArg(String string) {
        if (string.startsWith(SAVE_INTERVAL_OPTION)) {
            this.extractSaveInterval(string);
        } else if (string.startsWith(NOPRELOAD_OPTION)) {
            this.preload = false;
        } else if (string.startsWith(OPTION_CHAR)) {
            this.printUsage();
        } else {
            this.extractMetaProjectLocation(string);
        }
    }

    private void extractSaveInterval(String string) {
        if (string.startsWith(SAVE_INTERVAL_OPTION)) {
            String string2 = string.substring(SAVE_INTERVAL_OPTION.length());
            int n = Integer.parseInt(string2);
            Log.getLogger().config("Save interval sec=" + n);
            if (n > 0) {
                this._saveIntervalMsec = n * 1000;
            }
        } else {
            this.printUsage();
        }
    }

    protected void extractMetaProjectLocation(String string) {
        this.metaprojectURI = URIUtilities.createURI(string);
    }

    protected void printUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("usage: java -cp protege.jar edu.stanford.smi.protege.server.Server [options] <metaproject>");
        stringBuffer.append("\n\tOptions:");
        stringBuffer.append("\n\t\t-saveIntervalSec=<nseconds>");
        stringBuffer.append("\n\t\t\tSave any dirty projects every n minutes (only needed for file based projects)");
        stringBuffer.append("\n\t\t-nopreload");
        stringBuffer.append("\n\t\t\tDon't preload projects.");
        System.err.println(stringBuffer.toString());
        System.exit(-1);
    }

    private Server(String[] stringArray) throws RemoteException, IOException {
        super(SSLFactory.getServerPort(SSLFactory.Context.LOGIN), new RmiSocketFactory(SSLFactory.Context.LOGIN), new RmiSocketFactory(SSLFactory.Context.LOGIN));
        this.parseArgs(stringArray);
        this.initialize();
    }

    private void clear() {
        this._nameToOpenProjectMap.clear();
        this._nameToProjectStatusMap.clear();
        this._projectToServerProjectMap.clear();
        this._sessions.clear();
        this._sessionToProjectsMap.clear();
        this.removeMetaProjectListeners();
        this.stopProjectUpdateThread();
    }

    private void initialize() throws RemoteException {
        Log.getLogger().info("Using metaproject from: " + this.metaprojectURI);
        this.metaproject = new MetaProjectImpl(this.metaprojectURI, true);
        this.serverMetaProject = null;
        ServerUtil.fixMetaProject(this.metaproject);
        this.initializeProjects();
        this.addMetaProjectListeners();
        this.startProjectUpdateThread();
    }

    private void initializeProjects() {
        for (String string : this.getAvailableProjectNames(null)) {
            this._nameToProjectStatusMap.put(string, ServerProject.ProjectStatus.READY);
            if (this.preload) {
                try {
                    this.createProject(string);
                }
                catch (Exception exception) {
                    Log.getLogger().warning("Error at loading project: " + string + "Error message: " + exception.getMessage());
                }
                continue;
            }
            Log.getLogger().info("Found project " + string);
        }
    }

    protected void bindName() throws RemoteException {
        try {
            String string = Server.getLocalBoundName();
            Server.getRegistry().rebind(string, this);
            this._baseURI = new URI("rmi://" + Server.getMachineName() + "/" + string);
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
            if (exception instanceof RemoteException) {
                throw (RemoteException)exception;
            }
            throw new RemoteException(exception.getMessage());
        }
    }

    protected void unBindName() throws RemoteException {
        try {
            String string = Server.getLocalBoundName();
            Server.getRegistry().unbind(string);
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
            if (exception instanceof RemoteException) {
                throw (RemoteException)exception;
            }
            throw new RemoteException(exception.getMessage());
        }
    }

    private static String getMachineName() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            Log.getLogger().severe(Log.toString(unknownHostException));
            string = "localhost";
        }
        return string;
    }

    private boolean readAllowed(String string, RemoteSession remoteSession) {
        Policy policy = this.metaproject.getPolicy();
        User user = policy.getUserByName(remoteSession.getUserName());
        ProjectInstance projectInstance = this.metaproject.getProject(string);
        if (projectInstance == null) {
            return true;
        }
        return policy.isOperationAuthorized(user, MetaProjectConstants.OPERATION_READ, projectInstance);
    }

    private void recordConnection(RemoteSession remoteSession, ServerProject serverProject) throws ServerSessionLost {
        Collection<ServerProject> collection = this._sessionToProjectsMap.get(remoteSession);
        if (collection == null) {
            collection = new ArrayList<ServerProject>();
            this._sessionToProjectsMap.put(remoteSession, collection);
        }
        collection.add(serverProject);
        serverProject.register(remoteSession);
        Log.getLogger().info("Server: Adding " + remoteSession + " on " + new Date());
    }

    private void recordDisconnection(RemoteSession remoteSession, RemoteServerProject remoteServerProject) throws ServerSessionLost {
        Collection<ServerProject> collection = this._sessionToProjectsMap.get(remoteSession);
        if (collection != null) {
            collection.remove(remoteServerProject);
        }
        if (collection == null || collection.isEmpty()) {
            this._sessionToProjectsMap.remove(remoteSession);
            this._sessions.remove(remoteSession);
        }
        if (remoteServerProject instanceof ServerProject) {
            ((ServerProject)remoteServerProject).deregister(remoteSession);
        }
        Log.getLogger().info("Server: Removing " + remoteSession + " on " + new Date());
    }

    public synchronized ServerProject getServerProject(String string) {
        Project project = this.getProject(string);
        return project == null ? null : this.getServerProject(project);
    }

    private ServerProject createServerProject(String string, Project project) {
        ServerProject serverProject = null;
        try {
            serverProject = new ServerProject(this, this.getURI(string), this.metaproject.getProject(string), project);
        }
        catch (RemoteException remoteException) {
            Log.getLogger().severe(Log.toString(remoteException));
        }
        return serverProject;
    }

    private URI getURI(String string) {
        String string2 = FileUtilities.urlEncode(string);
        return this._baseURI.resolve(string2);
    }

    private void addServerProject(Project project, ServerProject serverProject) {
        this._projectToServerProjectMap.put(project, serverProject);
    }

    public synchronized Project getOrCreateProject(String string) {
        Project project = this.getProject(string);
        if (project == null) {
            project = this.createProject(string);
        }
        return project;
    }

    private Project createProject(String string) {
        if (this._nameToProjectStatusMap.get(string) != ServerProject.ProjectStatus.READY) {
            return null;
        }
        Project project = null;
        for (ProjectInstance projectInstance : this.metaproject.getProjects()) {
            String string2 = projectInstance.getName();
            if (!string2.equals(string)) continue;
            String string3 = projectInstance.getLocation();
            URI uRI = URIUtilities.createURI(string3);
            Log.getLogger().info("Loading project " + string + " from " + uRI);
            ArrayList arrayList = new ArrayList();
            project = Project.loadProjectFromURI(uRI, arrayList, true);
            Log.handleErrors(log, Level.WARNING, arrayList);
            if (serverInstance != null) {
                this._projectPluginManager.afterLoad(project);
            }
            Server.localizeProject(project);
            this._nameToOpenProjectMap.put(string, project);
            break;
        }
        return project;
    }

    private static void localizeProject(Project project) {
        Server.localizeKB(project.getKnowledgeBase());
        Server.localizeKB(project.getInternalProjectKnowledgeBase());
    }

    private static void localizeKB(KnowledgeBase knowledgeBase) {
        FrameStore frameStore = new LocalizeFrameStoreHandler(knowledgeBase).newFrameStore();
        knowledgeBase.insertFrameStore(frameStore);
    }

    private static boolean isCurrent(Session session) {
        return true;
    }

    private boolean isValid(String string, String string2) {
        User user = this.metaproject.getUser(string);
        if (user == null) {
            return false;
        }
        return user.verifyPassword(string2);
    }

    @Override
    public String toString() {
        return "Server";
    }

    private synchronized void startProjectUpdateThread() {
        if (this._saveIntervalMsec != -1) {
            this._updateThread = new Thread("Save Projects"){

                public void run() {
                    try {
                        while (Server.this._updateThread == this) {
                            2.sleep(Server.this._saveIntervalMsec);
                            Server.this.saveAllProjects();
                        }
                    }
                    catch (Throwable throwable) {
                        Log.getLogger().log(Level.INFO, "Exception caught", throwable);
                    }
                }
            };
            this._updateThread.setDaemon(true);
            this._updateThread.start();
        }
    }

    private synchronized void stopProjectUpdateThread() {
        this._updateThread = null;
    }

    @Override
    public synchronized boolean saveMetaProject(RemoteSession remoteSession) throws RemoteException {
        ArrayList arrayList = new ArrayList();
        log.info("Saving metaproject...");
        this.metaproject.save(arrayList);
        if (!arrayList.isEmpty()) {
            log.warning("Errors found saving metaproject");
            Server.dumpErrors(((MetaProjectImpl)this.metaproject).getKnowledgeBase().getProject(), arrayList);
        }
        return arrayList.size() == 0;
    }

    public synchronized void saveAllProjects() {
        for (Map.Entry<Project, ServerProject> object2 : this._projectToServerProjectMap.entrySet()) {
            Project project = object2.getKey();
            ServerProject serverProject = object2.getValue();
            if (!serverProject.isDirty()) continue;
            Server.save(serverProject, project);
        }
        ArrayList arrayList = new ArrayList();
        this.metaproject.save(arrayList);
        if (!arrayList.isEmpty()) {
            log.warning("Errors found saving metaproject");
            Server.dumpErrors(((MetaProjectImpl)this.metaproject).getKnowledgeBase().getProject(), arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void save(ServerProject serverProject, Project project) {
        Log.getLogger().info("Saving " + project);
        ArrayList arrayList = new ArrayList();
        KnowledgeBase knowledgeBase = project.getKnowledgeBase();
        synchronized (knowledgeBase) {
            KnowledgeBase knowledgeBase2 = project.getInternalProjectKnowledgeBase();
            synchronized (knowledgeBase2) {
                KnowledgeBase knowledgeBase3 = project.getKnowledgeBase();
                KnowledgeBaseFactory knowledgeBaseFactory = knowledgeBase3.getKnowledgeBaseFactory();
                knowledgeBaseFactory.saveKnowledgeBase(knowledgeBase3, project.getSources(), arrayList);
                Server.serverInstance._projectPluginManager.afterSave(project);
            }
        }
        if (serverProject != null) {
            serverProject.setClean();
        }
        Server.dumpErrors(project, arrayList);
    }

    private static void dumpErrors(Project project, Collection collection) {
        if (!collection.isEmpty()) {
            Log.getLogger().warning("Unable to save project " + project);
            Log.handleErrors(log, Level.WARNING, collection);
        }
    }

    private void closeProject(String string) {
        Project project = this._nameToOpenProjectMap.get(string);
        ServerProject serverProject = this._projectToServerProjectMap.get(project);
        HashSet<Session> hashSet = new HashSet<Session>();
        for (Map.Entry<RemoteSession, Collection<ServerProject>> object : this._sessionToProjectsMap.entrySet()) {
            RemoteSession remoteSession = object.getKey();
            Collection<ServerProject> collection = object.getValue();
            if (collection.remove(serverProject)) {
                try {
                    serverProject.deregister(remoteSession);
                }
                catch (ServerSessionLost serverSessionLost) {
                    log.log(Level.WARNING, "Unexpected exception deregistering client", serverSessionLost);
                }
            }
            if (!collection.isEmpty() || !(remoteSession instanceof Session)) continue;
            hashSet.add((Session)remoteSession);
        }
        for (Session session : hashSet) {
            this._sessions.remove(session);
            this._sessionToProjectsMap.remove(session);
        }
        Server.save(serverProject, project);
        project.dispose();
        this._projectToServerProjectMap.remove(project);
        this._nameToOpenProjectMap.remove(string);
    }

    public boolean isActive(RemoteSession remoteSession) {
        return this._sessions.contains(remoteSession);
    }

    public synchronized void disconnectFromProject(RemoteServerProject remoteServerProject, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordDisconnection(remoteSession, remoteServerProject);
    }

    public synchronized Project getProject(String string) {
        return this._nameToOpenProjectMap.get(string);
    }

    public synchronized ServerProject getServerProject(Project project) {
        return this._projectToServerProjectMap.get(project);
    }

    @Override
    public synchronized ServerProject.ProjectStatus getProjectStatus(String string) {
        return this._nameToProjectStatusMap.get(string);
    }

    public synchronized void setProjectStatus(String string, ServerProject.ProjectStatus projectStatus) {
        ServerProject.ProjectStatus projectStatus2 = this._nameToProjectStatusMap.put(string, projectStatus);
        Project project = this._nameToOpenProjectMap.get(string);
        if (project != null) {
            KnowledgeBase knowledgeBase = project.getKnowledgeBase();
            EventGeneratorFrameStore eventGeneratorFrameStore = knowledgeBase.getFrameStoreManager().getFrameStoreFromClass(EventGeneratorFrameStore.class);
            eventGeneratorFrameStore.addCustomEvent(new ServerProjectStatusChangeEvent(string, projectStatus2, projectStatus));
        }
    }

    public synchronized Collection<ServerProject> getCurrentProjects(RemoteSession remoteSession) {
        return this._sessionToProjectsMap.get(remoteSession);
    }

    public synchronized Collection<RemoteSession> getCurrentSessions() {
        return new ArrayList<RemoteSession>(this._sessions);
    }

    public synchronized Collection<RemoteSession> getCurrentSessions(RemoteServerProject remoteServerProject) {
        ArrayList<RemoteSession> arrayList = new ArrayList<RemoteSession>();
        for (Map.Entry<RemoteSession, Collection<ServerProject>> entry : this._sessionToProjectsMap.entrySet()) {
            Session session;
            Collection<ServerProject> collection = entry.getValue();
            if (!collection.contains(remoteServerProject) || !Server.isCurrent(session = (Session)entry.getKey())) continue;
            arrayList.add(session);
        }
        return arrayList;
    }

    public synchronized void setFrameCalculatorDisabled(boolean bl) {
        for (ServerProject serverProject : this._projectToServerProjectMap.values()) {
            serverProject.setFrameCalculatorDisabled(bl);
        }
    }

    public synchronized MetaProject getMetaProjectNew() {
        return this.metaproject;
    }

    @Deprecated
    public synchronized KnowledgeBase getMetaProject() {
        return ((MetaProjectImpl)this.metaproject).getKnowledgeBase();
    }

    @Deprecated
    public synchronized Cls getProjectCls() {
        if (this.projectCls == null) {
            this.projectCls = ((MetaProjectImpl)this.metaproject).getCls(MetaProjectImpl.ClsEnum.Project);
        }
        return this.projectCls;
    }

    @Deprecated
    public synchronized Slot getNameSlot() {
        if (this.nameSlot == null) {
            this.nameSlot = ((MetaProjectImpl)this.metaproject).getSlot(MetaProjectImpl.SlotEnum.name);
        }
        return this.nameSlot;
    }

    private FrameListener getMetaProjectFrameListener() {
        if (this.metaprojectFrameListener == null) {
            this.metaprojectFrameListener = new FrameAdapter(){
                private Cls projectClass;
                {
                    this.projectClass = Server.this.getProjectCls();
                }

                public void ownSlotValueChanged(FrameEvent frameEvent) {
                    Instance instance = (Instance)frameEvent.getFrame();
                    if (instance.hasType(this.projectClass) && frameEvent.getSlot().equals(Server.this.nameSlot)) {
                        List list = frameEvent.getOldValues();
                        final String string = list != null && list.size() > 0 ? CollectionUtilities.getFirstItem(list).toString() : new String();
                        final String string2 = (String)instance.getOwnSlotValue(Server.this.nameSlot);
                        Server.this.singleJobAtATimeExecutor.submit(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                Server server = Server.this;
                                synchronized (server) {
                                    if (string2 != null && string2.length() > 0) {
                                        if (string.length() == 0) {
                                            Server.this._nameToProjectStatusMap.put(string2, ServerProject.ProjectStatus.CLOSED_FOR_MAINTENANCE);
                                            log.info("Project instance " + string2 + " was added to the metaproject.");
                                        } else {
                                            Server.this._nameToOpenProjectMap.put(string2, Server.this._nameToOpenProjectMap.get(string));
                                            Server.this._nameToProjectStatusMap.put(string2, Server.this._nameToProjectStatusMap.get(string));
                                            Server.this._nameToOpenProjectMap.remove(string);
                                            Server.this._nameToProjectStatusMap.remove(string);
                                            log.info("Project instance name was changed. Old name: " + string + "; New name: " + string2);
                                        }
                                    }
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.metaprojectFrameListener;
    }

    private FrameListener getMetaProjectProjectClsListener() {
        if (this.metaprojectProjectClsListener == null) {
            this.metaprojectProjectClsListener = new FrameAdapter(){

                public void ownSlotValueChanged(FrameEvent frameEvent) {
                    Server.this.singleJobAtATimeExecutor.submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            Server server = Server.this;
                            synchronized (server) {
                                HashSet hashSet = new HashSet(Server.this._nameToProjectStatusMap.keySet());
                                for (String string : hashSet) {
                                    ProjectInstance projectInstance = Server.this.metaproject.getProject(string);
                                    if (projectInstance != null) continue;
                                    Project project = (Project)Server.this._nameToOpenProjectMap.remove(string);
                                    Server.this._nameToProjectStatusMap.remove(string);
                                    if (project != null) {
                                        Server.this._projectToServerProjectMap.remove(project);
                                        project.dispose();
                                    }
                                    log.info("Project instance " + string + " was removed from the metaproject");
                                }
                            }
                        }
                    });
                }
            };
        }
        return this.metaprojectProjectClsListener;
    }

    private void addMetaProjectListeners() {
        if (this.metaproject != null) {
            this.getProjectCls();
            this.getNameSlot();
            KnowledgeBase knowledgeBase = ((MetaProjectImpl)this.metaproject).getKnowledgeBase();
            ServerFrameStore.requestEventDispatch(knowledgeBase);
            this.getMetaProjectFrameListener();
            knowledgeBase.addFrameListener(this.metaprojectFrameListener);
            this.getMetaProjectProjectClsListener();
            this.projectCls.addFrameListener(this.metaprojectProjectClsListener);
        }
    }

    private void removeMetaProjectListeners() {
        if (this.metaprojectFrameListener != null) {
            try {
                ((MetaProjectImpl)this.metaproject).getKnowledgeBase().removeFrameListener(this.metaprojectFrameListener);
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "Could not remove metaproject frame listener", exception);
            }
        }
        if (this.metaprojectProjectClsListener != null) {
            try {
                this.projectCls.removeFrameListener(this.metaprojectProjectClsListener);
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "Could not remove metaproject cls listener for cls Project", exception);
            }
        }
    }

    @Override
    public synchronized void reinitialize() throws RemoteException {
        Log.getLogger().info("Server reinitializing");
        this.unBindName();
        this.clear();
        serverInstance = null;
        this.initialize();
        serverInstance = this;
        Server.afterLoad();
        this.bindName();
    }

    @Override
    public synchronized RemoteSession openSession(String string, String string2, String string3) {
        Session session = null;
        if (this.isValid(string, string3)) {
            boolean bl = this.isServerOperationAllowed(new Session(string, string2, false), MetaProjectConstants.OPERATION_DELEGATE);
            session = new Session(string, string2, bl);
            this._sessions.add(session);
            this.metaproject.getUser(string).setLastLogin(new Date());
        } else {
            Log.getLogger().warning("Failed login for user " + string + " IP: " + string2);
        }
        return session;
    }

    @Override
    public synchronized RemoteSession cloneSession(RemoteSession remoteSession) {
        if (!this._sessions.contains(remoteSession)) {
            return null;
        }
        remoteSession = new Session(remoteSession.getUserName(), remoteSession.getUserIpAddress(), remoteSession.allowDelegation());
        this._sessions.add(remoteSession);
        return remoteSession;
    }

    @Override
    public synchronized void closeSession(RemoteSession remoteSession) {
        this._sessions.remove(remoteSession);
    }

    @Override
    public synchronized Collection<RemoteSession> getCurrentSessions(String string, RemoteSession remoteSession) {
        ServerProject serverProject = this.getServerProject(string);
        Collection<Object> collection = serverProject == null ? Collections.EMPTY_LIST : this.getCurrentSessions(serverProject);
        return collection;
    }

    @Override
    public synchronized Collection<String> getAvailableProjectNames(RemoteSession remoteSession) {
        Policy policy = this.metaproject.getPolicy();
        User user = remoteSession != null ? policy.getUserByName(remoteSession.getUserName()) : null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ProjectInstance projectInstance : this.metaproject.getProjects()) {
            Object object;
            String string;
            ServerProject.ProjectStatus projectStatus;
            if (user != null && (!policy.isOperationAuthorized(user, MetaProjectConstants.OPERATION_DISPLAY_IN_PROJECT_LIST, projectInstance) || !policy.isOperationAuthorized(user, MetaProjectConstants.OPERATION_READ, projectInstance)) || (projectStatus = this._nameToProjectStatusMap.get(string = projectInstance.getName())) != null && projectStatus != ServerProject.ProjectStatus.READY) continue;
            String string2 = projectInstance.getLocation();
            if (string2 == null || string2.length() == 0) {
                log.warning("Project with empty location will be ignored: " + string);
                continue;
            }
            URI uRI = URIUtilities.createURI(string2);
            String string3 = uRI.getScheme();
            if (string3 != null && string3.contains("http")) {
                object = URIUtilities.createBufferedReader(uRI);
                if (object != null) {
                    arrayList.add(projectInstance.getName());
                    FileUtilities.close((Reader)object);
                    continue;
                }
                Log.getLogger().warning("Missing project at " + string2);
                continue;
            }
            object = new File(string2);
            if (((File)object).exists() && ((File)object).isFile()) {
                arrayList.add(projectInstance.getName());
                continue;
            }
            Log.getLogger().warning("Missing project at " + string2);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    public synchronized Collection<ProjectInfo> getAvailableProjectInfo(RemoteSession remoteSession) {
        ArrayList<ProjectInfo> arrayList = new ArrayList<ProjectInfo>();
        Collection<String> collection = this.getAvailableProjectNames(remoteSession);
        for (String string : collection) {
            try {
                ProjectInstance projectInstance = this.metaproject.getProject(string);
                User user = projectInstance.getOwner();
                arrayList.add(new ProjectInfo(projectInstance.getName(), projectInstance.getDescription(), user == null ? null : user.getName()));
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.WARNING, "Errors at retrieving project instance from metaproject. Project name" + string, exception);
            }
        }
        return arrayList;
    }

    public synchronized Collection<String> getAllProjectNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this._nameToProjectStatusMap.keySet());
        Collections.sort(arrayList);
        return arrayList;
    }

    public synchronized Map<String, ServerProject.ProjectStatus> getProjectsStatusMap() {
        return this._nameToProjectStatusMap;
    }

    @Override
    public synchronized RemoteServerProject openProject(String string, RemoteSession remoteSession) throws ServerSessionLost {
        if (!this._sessions.contains(remoteSession)) {
            Log.getLogger().warning("Failed to open project: Invalid " + remoteSession + " tried to open project " + string + ". Most likely user is not logged in.");
            return null;
        }
        if (this._nameToProjectStatusMap.get(string) == ServerProject.ProjectStatus.CLOSED_FOR_MAINTENANCE) {
            Log.getLogger().warning("Failed to open project: " + remoteSession + " tried to open project " + string + ", but project is closed for maintenance");
            return null;
        }
        if (!this.readAllowed(string, remoteSession)) {
            Log.getLogger().warning("Failed to open project: " + remoteSession + " tried to open project " + string + ", but user does not have read permission on this project.");
            return null;
        }
        ServerProject serverProject = null;
        Project project = this.getOrCreateProject(string);
        if (project != null) {
            serverProject = this.getServerProject(project);
            if (serverProject == null) {
                serverProject = this.createServerProject(string, project);
                this.addServerProject(project, serverProject);
            }
            if (this._sessionToProjectsMap.get(remoteSession) != null && this._sessionToProjectsMap.get(remoteSession).contains(serverProject)) {
                return null;
            }
            this.recordConnection(remoteSession, serverProject);
            Log.getLogger().info("Server: Opened project " + string + " for " + remoteSession + " on " + new Date());
        } else {
            Log.getLogger().warning("Failed to open project:  " + remoteSession + " tried to open project " + string + ", but operation failed." + "Possible causes: project with this name is not defined in the metaproject;" + "project is not in the ready status, or project could not be opened by the server" + "(check previous server logs)");
        }
        return serverProject;
    }

    @Override
    public synchronized RemoteServerProject openMetaProject(RemoteSession remoteSession) throws RemoteException {
        if (!this.isServerOperationAllowed(remoteSession, MetaProjectConstants.OPERATION_ADMINISTER_SERVER)) {
            log.warning("Failed attempt to open metaproject by " + remoteSession + ". Not enough privileges.");
            throw new SecurityException("Not enough privileges to open metaproject.");
        }
        String string = "Meta-Project";
        if (this.serverMetaProject == null) {
            KnowledgeBase knowledgeBase = ((MetaProjectImpl)this.metaproject).getKnowledgeBase();
            Server.localizeKB(knowledgeBase);
            this.serverMetaProject = new ServerProject(this, this.getURI(string), this.metaproject.getProject(string), knowledgeBase.getProject());
        }
        this.serverMetaProject.register(remoteSession);
        return this.serverMetaProject;
    }

    @Override
    public synchronized RemoteServerProject createProject(String string, RemoteSession remoteSession, KnowledgeBaseFactory knowledgeBaseFactory, boolean bl) throws RemoteException {
        Object object;
        Project project = null;
        for (ProjectInstance object22 : this.metaproject.getProjects()) {
            object = object22.getName();
            if (!((String)object).equals(string)) continue;
            Log.getLogger().warning("Server: Attempting to create server project with existing project name. No server project created.");
            return null;
        }
        String string2 = ServerProperties.getDefaultNewProjectSaveDirectory();
        URI uRI = URIUtilities.createURI((String)string2 + File.separator + string + ".pprj");
        if (uRI == null) {
            Log.getLogger().warning("Could not create new server project at location " + (String)string2 + File.separator + string + ".pprj");
            return null;
        }
        object = new ArrayList();
        project = Project.createNewProject(knowledgeBaseFactory, (Collection)object);
        Log.getLogger().info("Server: Created server project at: " + uRI);
        if (((ArrayList)object).size() > 0) {
            Log.handleErrors(log, Level.SEVERE, (Collection)object);
            return null;
        }
        project.setProjectURI(uRI);
        if (knowledgeBaseFactory instanceof ClipsKnowledgeBaseFactory) {
            ClipsKnowledgeBaseFactory.setSourceFiles(project.getSources(), string + ".pont", string + ".pins");
        }
        project.save((Collection)object);
        if (((ArrayList)object).size() > 0) {
            Log.handleErrors(log, Level.SEVERE, (Collection)object);
            return null;
        }
        project = Project.loadProjectFromURI(uRI, new ArrayList(), true);
        if (serverInstance != null) {
            this._projectPluginManager.afterLoad(project);
        }
        Server.localizeProject(project);
        this._nameToOpenProjectMap.put(string, project);
        if (bl) {
            ProjectInstance projectInstance = this.metaproject.createProject(string);
            projectInstance.setLocation((String)string2 + File.separator + string + ".pprj");
            this.metaproject.save((Collection)object);
            Log.handleErrors(log, Level.SEVERE, (Collection)object);
        }
        return this.getServerProject(project);
    }

    @Override
    public synchronized void setProjectStatus(String string, ServerProject.ProjectStatus projectStatus, RemoteSession remoteSession) {
        ServerProject.ProjectStatus projectStatus2 = this._nameToProjectStatusMap.put(string, projectStatus);
        Project project = this._nameToOpenProjectMap.get(string);
        if (project != null) {
            KnowledgeBase knowledgeBase = project.getKnowledgeBase();
            EventGeneratorFrameStore eventGeneratorFrameStore = knowledgeBase.getFrameStoreManager().getFrameStoreFromClass(EventGeneratorFrameStore.class);
            eventGeneratorFrameStore.addCustomEvent(new ServerProjectStatusChangeEvent(string, projectStatus2, projectStatus));
        }
    }

    @Override
    public synchronized void notifyProject(String string, String string2, RemoteSession remoteSession) {
        Project project = this._nameToOpenProjectMap.get(string);
        if (project != null) {
            KnowledgeBase knowledgeBase = project.getKnowledgeBase();
            EventGeneratorFrameStore eventGeneratorFrameStore = knowledgeBase.getFrameStoreManager().getFrameStoreFromClass(EventGeneratorFrameStore.class);
            eventGeneratorFrameStore.addCustomEvent(new ServerProjectNotificationEvent(string, string2));
        }
    }

    @Override
    public synchronized boolean createUser(String string, String string2) {
        ArrayList arrayList = new ArrayList();
        for (User object2 : this.metaproject.getUsers()) {
            String bl = object2.getName();
            if (!bl.equals(string)) continue;
            Log.getLogger().warning("Server: Could not create user with name " + string + ". User name already exists.");
            return false;
        }
        User user = this.metaproject.createUser(string, string2);
        ArrayList arrayList2 = new ArrayList();
        boolean bl = this.metaproject.save(arrayList2);
        Log.handleErrors(log, Level.SEVERE, arrayList2);
        return bl && arrayList2.size() == 0;
    }

    @Override
    public synchronized boolean hasValidCredentials(String string, String string2) {
        return this.isValid(string, string2);
    }

    @Override
    public synchronized void shutdown() {
        log.info("Received shutdown request.");
        try {
            this.unBindName();
        }
        catch (RemoteException remoteException) {
            log.log(Level.WARNING, "Exception caught unbinding server name", remoteException);
        }
        this.removeMetaProjectListeners();
        this.saveAllProjects();
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SystemUtilities.sleepMsec(100);
                    Log.getLogger().info("Server exiting.");
                    Server server = Server.this;
                    synchronized (server) {
                        for (Project project : Server.this._projectToServerProjectMap.keySet()) {
                            KnowledgeBase knowledgeBase = project.getKnowledgeBase();
                            synchronized (knowledgeBase) {
                                KnowledgeBase knowledgeBase2 = project.getInternalProjectKnowledgeBase();
                                synchronized (knowledgeBase2) {
                                    try {
                                        Server.this._projectPluginManager.beforeClose(project);
                                    }
                                    catch (Exception exception) {
                                        Log.getLogger().log(Level.INFO, "Exception caught cleaning up", exception);
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    Log.getLogger().log(Level.INFO, "Exception caught", exception);
                }
                finally {
                    System.exit(0);
                }
            }
        };
        thread.start();
    }

    @Override
    public synchronized void shutdown(String string, RemoteSession remoteSession) {
        if (!this.isServerOperationAllowed(remoteSession, MetaProjectConstants.OPERATION_ADMINISTER_SERVER) && !this.isOperationAllowed(remoteSession, MetaProjectConstants.OPERATION_STOP_REMOTE_PROJECT, string)) {
            log.warning("Unauthorized attempt to shutdown project " + string + " by " + remoteSession.getUserName() + " @ " + remoteSession.getUserIpAddress());
            return;
        }
        this.setProjectStatus(string, ServerProject.ProjectStatus.CLOSED_FOR_MAINTENANCE, remoteSession);
        this.closeProject(string);
    }

    @Override
    public synchronized void killOtherUserSession(RemoteSession remoteSession, RemoteSession remoteSession2) {
        this.killOtherUserSession(remoteSession, remoteSession2, 0);
    }

    @Override
    public void killOtherUserSession(final RemoteSession remoteSession, final RemoteSession remoteSession2, final int n) {
        Thread thread = new Thread("Kill other session thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                Collection collection;
                HashSet<ServerProject> hashSet = new HashSet<ServerProject>();
                HashSet<ServerProject> hashSet2 = new HashSet<ServerProject>();
                boolean bl = false;
                Server server = Server.this;
                synchronized (server) {
                    collection = (Collection)Server.this._sessionToProjectsMap.get(remoteSession);
                    if (collection == null) {
                        Server.this._sessionToProjectsMap.remove(remoteSession);
                        Server.this._sessions.remove(remoteSession);
                        return;
                    }
                    for (ServerProject serverProject : collection) {
                        String string = serverProject.getMetaProjectInstance().getName();
                        if (!Server.this.isServerOperationAllowed(remoteSession2, MetaProjectConstants.OPERATION_ADMINISTER_SERVER) && !Server.this.isOperationAllowed(remoteSession2, MetaProjectConstants.OPERATION_KILL_OTHER_USER_SESSION, string)) continue;
                        hashSet2.add(serverProject);
                        object = (Project)Server.this._nameToOpenProjectMap.get(string);
                        if (object != null) {
                            KnowledgeBase knowledgeBase = ((Project)object).getKnowledgeBase();
                            EventGeneratorFrameStore eventGeneratorFrameStore = knowledgeBase.getFrameStoreManager().getFrameStoreFromClass(EventGeneratorFrameStore.class);
                            eventGeneratorFrameStore.addCustomEvent(new ServerProjectSessionClosedEvent(string, remoteSession));
                            continue;
                        }
                        bl = true;
                    }
                }
                try {
                    6.sleep(n * 1000);
                }
                catch (InterruptedException interruptedException) {
                    log.severe("Unexpected interrupt - you trying to kill me or what?");
                }
                server = Server.this;
                synchronized (server) {
                    for (ServerProject serverProject : hashSet2) {
                        try {
                            serverProject.deregister(remoteSession);
                            hashSet.add(serverProject);
                        }
                        catch (Throwable throwable) {
                            object = "(unknown)";
                            try {
                                object = serverProject.getMetaProjectInstance().getName();
                            }
                            catch (Exception exception) {
                                Log.emptyCatchBlock(exception);
                            }
                            log.log(Level.WARNING, "Could not deregister session " + remoteSession + " from project " + (String)object, throwable);
                        }
                    }
                    if (bl) {
                        collection.removeAll(hashSet);
                    } else {
                        Server.this._sessionToProjectsMap.remove(remoteSession);
                        Server.this._sessions.remove(remoteSession);
                    }
                }
            }
        };
        thread.start();
    }

    @Override
    public void shutdownProject(RemoteSession remoteSession, String string, float f) throws RemoteException {
        if (remoteSession == null) {
            log.warning("Can only shutdown the remote project " + string + " in multi-user mode.");
            return;
        }
        int n = 5;
        int n2 = 7;
        int n3 = (int)f;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (n3 > n) {
            arrayList.add(n3);
            if (n3 >= 120) {
                n3 = n3 / 120 * 60;
                continue;
            }
            if (n3 >= 20) {
                n3 = n3 / 20 * 10;
                continue;
            }
            if (n3 >= 10) {
                n3 = n3 / 10 * 5;
                continue;
            }
            n3 = n;
        }
        arrayList.add(n3);
        this.shutdownProject(remoteSession, string, arrayList.toArray(new Integer[arrayList.size()]), n2);
    }

    @Override
    public synchronized void shutdownProject(RemoteSession remoteSession, String string, Integer[] integerArray, int n) throws RemoteException {
        if (remoteSession == null) {
            log.warning("Can only shutdown the remote project " + string + " in multi-user mode.");
            return;
        }
        if (!this.isServerOperationAllowed(remoteSession, MetaProjectConstants.OPERATION_ADMINISTER_SERVER) && !this.isOperationAllowed(remoteSession, MetaProjectConstants.OPERATION_STOP_REMOTE_PROJECT, string)) {
            throw new SecurityException("Operation not permitted: Shutdown remote project " + string + " for user: " + remoteSession.getUserName() + " (" + remoteSession.getUserIpAddress() + ")");
        }
        Arrays.sort(integerArray, new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                return n2.compareTo(n);
            }
        });
        Runnable runnable = this.getProjectShutdownRunnable(remoteSession, string, integerArray, n);
        FutureTask<Object> futureTask = new FutureTask<Object>(runnable, null);
        this.serverExecutor.submit(futureTask);
        this.projectToShutdownTaskNotificationMap.put(string, futureTask);
    }

    @Override
    public synchronized boolean cancelShutdownProject(RemoteSession remoteSession, String string) {
        boolean bl = false;
        FutureTask<Object> futureTask = null;
        futureTask = this.projectToShutdownTaskNotificationMap.get(string);
        if (futureTask == null || futureTask.isDone()) {
            return false;
        }
        bl = futureTask.cancel(true);
        if (!bl) {
            log.info("Could not cancel task: " + futureTask);
        } else {
            log.info("Task canceled: " + futureTask);
            this.projectToShutdownTaskNotificationMap.remove(string);
            this.setProjectStatus(string, ServerProject.ProjectStatus.READY);
            this.notifyProject(string, "Shut down of project " + string + " has been canceled by the administrator.", remoteSession);
        }
        return bl;
    }

    private Runnable getProjectShutdownRunnable(final RemoteSession remoteSession, final String string, final Integer[] integerArray, final int n) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Server.this.setProjectStatus(string, ServerProject.ProjectStatus.SHUTTING_DOWN, remoteSession);
                for (int i = 0; i < integerArray.length; ++i) {
                    int n3 = integerArray[i];
                    int n2 = i == integerArray.length - 1 ? n3 : n3 - integerArray[i + 1];
                    String string2 = "Remote project " + string + " will be shut down in " + (n3 <= 60 ? "" + n3 + " seconds." : "" + n3 / 60 + " minutes.");
                    Server.this.notifyProject(string, string2, remoteSession);
                    try {
                        Thread.sleep(n2 * 1000);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        FutureTask futureTask;
                        Server server = Server.this;
                        synchronized (server) {
                            futureTask = (FutureTask)Server.this.projectToShutdownTaskNotificationMap.get(string);
                        }
                        if (futureTask != null && futureTask.isCancelled()) {
                            log.warning("Thread for shutting down project " + string + " has been interrupted.");
                        } else {
                            log.severe("Thread for shutting down project " + string + " has been interrupted for no good reason.");
                        }
                        return;
                    }
                }
                Server.this.setProjectStatus(string, ServerProject.ProjectStatus.CLOSED_FOR_MAINTENANCE, remoteSession);
                if (n != 0) {
                    try {
                        Thread.sleep(n * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                        FutureTask futureTask;
                        Server server = Server.this;
                        synchronized (server) {
                            futureTask = (FutureTask)Server.this.projectToShutdownTaskNotificationMap.get(string);
                        }
                        if (futureTask != null && futureTask.isCancelled()) {
                            log.warning("Thread for shutting down project " + string + " has been interrupted.");
                        } else {
                            log.severe("Thread for shutting down project " + string + " has been interrupted for no good reason.");
                        }
                        return;
                    }
                }
                Server server = Server.this;
                synchronized (server) {
                    Server.this.shutdown(string, remoteSession);
                    Server.this.projectToShutdownTaskNotificationMap.remove(string);
                }
            }
        };
        return runnable;
    }

    @Override
    public boolean allowsCreateUsers() throws RemoteException {
        return ServerProperties.getAllowsCreateUsers();
    }

    @Override
    public synchronized boolean isOperationAllowed(RemoteSession remoteSession, Operation operation, String string) {
        return this.isServerOperationAllowed(remoteSession, operation, this.metaproject.getPolicy().getProjectInstanceByName(string));
    }

    @Override
    public synchronized boolean isServerOperationAllowed(RemoteSession remoteSession, Operation operation) {
        ServerInstance serverInstance = this.metaproject.getPolicy().getFirstServerInstance();
        return serverInstance == null ? true : this.isServerOperationAllowed(remoteSession, operation, serverInstance);
    }

    @Override
    public synchronized boolean isServerOperationAllowed(RemoteSession remoteSession, Operation operation, String string) {
        return this.isServerOperationAllowed(remoteSession, operation, this.metaproject.getPolicy().getServerInstanceByName(string));
    }

    @Override
    public synchronized boolean isGroupOperationAllowed(RemoteSession remoteSession, Operation operation, String string) {
        return this.isServerOperationAllowed(remoteSession, operation, this.metaproject.getGroup(string));
    }

    private boolean isServerOperationAllowed(RemoteSession remoteSession, Operation operation, PolicyControlledObject policyControlledObject) {
        Policy policy = this.metaproject.getPolicy();
        User user = policy.getUserByName(remoteSession.getUserName());
        if (user == null || policyControlledObject == null) {
            return false;
        }
        return policy.isOperationAuthorized(user, operation, policyControlledObject);
    }

    @Override
    public synchronized Collection<Operation> getAllowedOperations(RemoteSession remoteSession, String string, String string2) {
        ArrayList<Operation> arrayList = new ArrayList<Operation>();
        Policy policy = this.metaproject.getPolicy();
        User user = policy.getUserByName(string2);
        ProjectInstance projectInstance = this.metaproject.getPolicy().getProjectInstanceByName(string);
        if (user == null || projectInstance == null) {
            return arrayList;
        }
        for (Operation operation : policy.getKnownOperations()) {
            if (!policy.isOperationAuthorized(user, operation, projectInstance)) continue;
            arrayList.add(operation);
        }
        return arrayList;
    }

    @Override
    public Object executeServerJob(ServerJob serverJob, RemoteSession remoteSession) {
        serverJob.fixLoader();
        return serverJob.run();
    }
}

