/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore.background;

import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CacheRequestReason {
    USER_REQUESTED_FRAME_VALUES,
    USER_NAME_REQUEST,
    USER_CLOSURE_REQUEST,
    USER_SPECIFIC_FRAMES,
    NEW_FRAME,
    IMMEDIATE_PRELOAD,
    PRELOAD,
    SUBCLASS,
    DIRECT_INSTANCES,
    STATE_MACHINE;

    private static int MIN_PRIORITY;

    public int priority() {
        switch (this) {
            case USER_REQUESTED_FRAME_VALUES: {
                return 8;
            }
            case USER_CLOSURE_REQUEST: {
                return 7;
            }
            case NEW_FRAME: {
                return 6;
            }
            case STATE_MACHINE: {
                return 3;
            }
            case IMMEDIATE_PRELOAD: {
                return 3;
            }
            case SUBCLASS: {
                return -1;
            }
            case PRELOAD: {
                return -1;
            }
        }
        return 0;
    }

    public static int priority(EnumSet<CacheRequestReason> enumSet) {
        int n = MIN_PRIORITY;
        for (CacheRequestReason cacheRequestReason : enumSet) {
            if (cacheRequestReason.priority() <= n) continue;
            n = cacheRequestReason.priority();
        }
        return n;
    }

    static {
        int n = STATE_MACHINE.priority();
        for (CacheRequestReason cacheRequestReason : CacheRequestReason.values()) {
            if (cacheRequestReason.priority() < n) {
                n = cacheRequestReason.priority();
            }
            MIN_PRIORITY = n;
        }
    }
}

