/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.storage.database.DatabaseFrameDb;
import edu.stanford.smi.protege.storage.database.DefaultDatabaseFrameDb;
import edu.stanford.smi.protege.util.Log;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseFrameDbFactory {
    private static final Logger log = Log.getLogger(DatabaseFrameDbFactory.class);

    public static DatabaseFrameDb createDatabaseFrameDb(Class<? extends DatabaseFrameDb> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            log.log(Level.SEVERE, "Failed to instantiate DatabaseFrameDb", instantiationException);
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.SEVERE, "Illegal access exception while creating DatabaseFrameDb", illegalAccessException);
            return null;
        }
    }

    public static Class<? extends DatabaseFrameDb> getFrameDbClass(String string) {
        Class clazz = DefaultDatabaseFrameDb.class;
        if (string != null) {
            try {
                Class<?> clazz2 = Class.forName(string);
                clazz = clazz2.asSubclass(DatabaseFrameDb.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.warning(string + " not found, using default DatabaseFrameDb");
            }
            catch (ClassCastException classCastException) {
                log.warning(string + " does not implement DatabaseFrameDb, using default DatabaseFrameDb");
            }
        }
        return clazz;
    }
}

