/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.test;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.test.AbstractTestCase;
import edu.stanford.smi.protege.test.ProjectFactory;
import edu.stanford.smi.protege.util.Log;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Assert;

public abstract class AbstractProjectFactory
implements ProjectFactory {
    protected static void checkErrors(Collection collection) {
        if (!collection.isEmpty()) {
            for (Object e : collection) {
                Log.getLogger().severe("Error: " + e.toString());
            }
            Assert.fail();
        }
    }

    private static File getTempDirectory() {
        return AbstractTestCase.getTempDirectory();
    }

    protected static URI getProjectURI() {
        URI uRI = null;
        try {
            File file = File.createTempFile("test", ".pprj", AbstractProjectFactory.getTempDirectory());
            uRI = file.toURI();
        }
        catch (IOException iOException) {
            Assert.fail((String)iOException.getMessage());
        }
        return uRI;
    }

    public Project saveAndReloadProject(Project project) {
        URI uRI = project.getProjectURI();
        if (uRI == null) {
            uRI = AbstractProjectFactory.getProjectURI();
            project.setProjectURI(uRI);
        }
        ArrayList arrayList = new ArrayList();
        int n = project.getKnowledgeBase().getFrameCount();
        project.save(arrayList);
        AbstractProjectFactory.checkErrors(arrayList);
        project.dispose();
        project = Project.loadProjectFromURI(uRI, arrayList);
        AbstractProjectFactory.checkErrors(arrayList);
        Assert.assertEquals((int)n, (int)project.getKnowledgeBase().getFrameCount());
        return project;
    }
}

