/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.WaitCursor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JComponent;

public abstract class DeleteAction
extends AllowableAction {
    private static final long serialVersionUID = -5040421731435729618L;

    protected DeleteAction(String string, Selectable selectable, Icon icon) {
        super(string, string, icon, selectable);
    }

    protected DeleteAction(String string, Selectable selectable) {
        super(string, selectable);
        if (this.getIcon() == null) {
            this.setIcon(Icons.getDeleteIcon());
        }
    }

    protected DeleteAction(ResourceKey resourceKey, Selectable selectable) {
        super(resourceKey, selectable);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isAllowed() && this.confirmDelete()) {
            this.onDelete();
        }
    }

    private boolean confirmDelete() {
        String string = LocalizedText.getText(ResourceKey.DIALOG_CONFIRM_DELETE_TEXT);
        int n = ModalDialog.showMessageDialog((Component)((JComponent)((Object)this.getSelectable())), string, 13);
        return n == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDelete() {
        WaitCursor waitCursor = new WaitCursor((JComponent)((Object)this.getSelectable()));
        try {
            this.onDelete(new ArrayList(this.getSelection()));
        }
        finally {
            waitCursor.hide();
        }
    }

    protected void onDelete(Collection collection) {
        Iterator iterator = this.getSelection().iterator();
        while (iterator.hasNext()) {
            this.onDelete(iterator.next());
        }
    }

    public void onDelete(Object object) {
        Log.getLogger().warning("onDelete called: should have been overridden");
    }
}

