/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore;

import edu.stanford.smi.protege.exception.ModificationException;
import edu.stanford.smi.protege.model.framestore.AbstractFrameStoreInvocationHandler;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.metaproject.MetaProject;
import edu.stanford.smi.protege.server.metaproject.MetaProjectConstants;
import edu.stanford.smi.protege.server.metaproject.Policy;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.server.metaproject.User;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;

public class ReadAccessEnforcementFrameStore
extends AbstractFrameStoreInvocationHandler {
    private ServerFrameStore serverFrameStore;
    private Collection<String> readOnlyUsers = new HashSet<String>();

    public ReadAccessEnforcementFrameStore(ServerFrameStore serverFrameStore) {
        this.serverFrameStore = serverFrameStore;
        this.loadPolicy();
    }

    public void loadPolicy() {
        MetaProject metaProject = Server.getInstance().getMetaProjectNew();
        Policy policy = Server.getPolicy();
        ProjectInstance projectInstance = this.serverFrameStore.getMetaProjectInstance();
        this.readOnlyUsers.clear();
        for (User user : metaProject.getUsers()) {
            if (policy.isOperationAuthorized(user, MetaProjectConstants.OPERATION_WRITE, projectInstance)) continue;
            this.readOnlyUsers.add(user.getName());
        }
    }

    public boolean isApplicable() {
        return !this.readOnlyUsers.isEmpty();
    }

    public Object handleInvoke(Method method, Object[] objectArray) {
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        boolean bl = false;
        if (remoteSession != null) {
            bl = this.readOnlyUsers.contains(remoteSession.getUserName());
        }
        if (bl && method.getName().endsWith("Transaction")) {
            return Boolean.TRUE;
        }
        if (bl && ReadAccessEnforcementFrameStore.isModification(method)) {
            throw new ModificationException(method.getName());
        }
        return this.invoke(method, objectArray);
    }

    public void executeQuery(Query query, QueryCallback queryCallback) {
        this.getDelegate().executeQuery(query, queryCallback);
    }
}

