/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.metaproject.impl;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.server.metaproject.Group;
import edu.stanford.smi.protege.server.metaproject.GroupOperation;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.metaproject.Policy;
import edu.stanford.smi.protege.server.metaproject.PolicyControlledObject;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.server.metaproject.ServerInstance;
import edu.stanford.smi.protege.server.metaproject.User;
import edu.stanford.smi.protege.server.metaproject.impl.MetaProjectImpl;
import edu.stanford.smi.protege.util.CollectionUtilities;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyImpl
implements Policy,
Localizable,
Serializable {
    private static final long serialVersionUID = 2209527990426609790L;
    MetaProjectImpl mp;

    public PolicyImpl(MetaProjectImpl metaProjectImpl) {
        this.mp = metaProjectImpl;
    }

    @Override
    public boolean isOperationAuthorized(User user, Operation operation, PolicyControlledObject policyControlledObject) {
        if (!this.getKnownOperations().contains(operation)) {
            return true;
        }
        Set<Group> set = user.getGroups();
        for (GroupOperation groupOperation : policyControlledObject.getAllowedGroupOperations()) {
            if (!set.contains(groupOperation.getAllowedGroup()) || !groupOperation.getAllowedOperations().contains(operation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Operation> getAllowedOperations(User user, ProjectInstance projectInstance) {
        HashSet<Operation> hashSet = new HashSet<Operation>();
        if (projectInstance == null) {
            return hashSet;
        }
        Set<Group> set = user.getGroups();
        for (GroupOperation groupOperation : projectInstance.getAllowedGroupOperations()) {
            if (!set.contains(groupOperation.getAllowedGroup())) continue;
            hashSet.addAll(groupOperation.getAllowedOperations());
        }
        return hashSet;
    }

    @Override
    public Set<Operation> getKnownOperations() {
        return this.mp.getOperations();
    }

    @Override
    public User getUserByName(String string) {
        if (string == null) {
            return null;
        }
        for (User user : this.mp.getUsers()) {
            if (!string.equals(user.getName())) continue;
            return user;
        }
        return null;
    }

    @Override
    public ProjectInstance getProjectInstanceByName(String string) {
        for (ProjectInstance projectInstance : this.mp.getProjects()) {
            if (!projectInstance.getName().equals(string)) continue;
            return projectInstance;
        }
        return null;
    }

    @Override
    public ServerInstance getServerInstanceByName(String string) {
        for (ServerInstance serverInstance : this.mp.getServers()) {
            if (!serverInstance.getName().equals(string)) continue;
            return serverInstance;
        }
        return null;
    }

    @Override
    public ServerInstance getFirstServerInstance() {
        return CollectionUtilities.getFirstItem(this.mp.getServers());
    }

    @Override
    public void localize(KnowledgeBase knowledgeBase) {
        this.mp.localize(knowledgeBase);
    }
}

