/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.action.DeleteInstancesAction;
import edu.stanford.smi.protege.action.MakeCopiesAction;
import edu.stanford.smi.protege.action.ReferencersAction;
import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.event.KnowledgeBaseAdapter;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseListener;
import edu.stanford.smi.protege.model.BrowserSlotPattern;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.ConfigureAction;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.ui.ListFinder;
import edu.stanford.smi.protege.ui.MultiSlotPanel;
import edu.stanford.smi.protege.util.AbstractEvent;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.ConcurrentListModel;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.ViewAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectInstancesList
extends SelectableContainer
implements Disposable {
    private static final long serialVersionUID = 3123829893591425192L;
    public static final String SORT_LIMIT_PROPERTY = "ui.DirectInstancesList.sort_limit";
    public static final int SORT_LIMIT = ApplicationProperties.getIntegerProperty("ui.DirectInstancesList.sort_limit", 1000);
    private Collection<Cls> _clses = Collections.EMPTY_LIST;
    private SelectableList _list;
    private Project _project;
    private AllowableAction _createAction;
    private AllowableAction _copyAction;
    private AllowableAction _deleteAction;
    private HeaderComponent _header;
    private boolean _showSubclassInstances;
    private LabeledComponent _labeledComponent;
    private AddInstancesRunner background;
    private ClsListener _clsListener = new ClsAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void directInstanceAdded(ClsEvent clsEvent) {
            DirectInstancesList directInstancesList = DirectInstancesList.this;
            synchronized (directInstancesList) {
                if (DirectInstancesList.this.background != null && !clsEvent.isReplacementEvent()) {
                    DirectInstancesList.this.background.setDeferredSelection(clsEvent.getInstance());
                    DirectInstancesList.this.background.addChange(clsEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void directInstanceRemoved(ClsEvent clsEvent) {
            DirectInstancesList directInstancesList = DirectInstancesList.this;
            synchronized (directInstancesList) {
                if (DirectInstancesList.this.background != null && !clsEvent.isReplacementEvent()) {
                    DirectInstancesList.this.background.addChange(clsEvent);
                }
            }
        }
    };
    private FrameListener _clsFrameListener = new FrameAdapter(){

        public void ownSlotValueChanged(FrameEvent frameEvent) {
            super.ownSlotValueChanged(frameEvent);
            DirectInstancesList.this.background.addChange(frameEvent);
        }
    };
    private KnowledgeBaseListener kbListener = new KnowledgeBaseAdapter(){

        public void frameReplaced(KnowledgeBaseEvent knowledgeBaseEvent) {
            Instance instance = (Instance)knowledgeBaseEvent.getNewFrame();
            Collection collection = instance.getDirectTypes();
            for (Cls cls : collection) {
                if (!DirectInstancesList.this._clses.contains(cls)) continue;
                DirectInstancesList.this.background.addChange(knowledgeBaseEvent);
                return;
            }
        }
    };

    public DirectInstancesList(Project project) {
        this._project = project;
        Action action = this.createViewAction();
        this._list = ComponentFactory.createSelectableList(action);
        this._list.setCellRenderer(FrameRenderer.createInstance());
        this._list.setModel(new ConcurrentListModel());
        this._labeledComponent = new LabeledComponent(null, ComponentFactory.createScrollPane(this._list));
        this.addButtons(action, this._labeledComponent);
        this._labeledComponent.setFooterComponent(new ListFinder((JList)this._list, ResourceKey.INSTANCE_SEARCH_FOR));
        this._labeledComponent.setBorder(ComponentUtilities.getAlignBorder());
        this.add((Component)this._labeledComponent, "Center");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createHeader(), "North");
        this.add((Component)jPanel, "North");
        this.setSelectable(this._list);
        this._project.getKnowledgeBase().addKnowledgeBaseListener(this.kbListener);
    }

    private void updateLabel() {
        BrowserSlotPattern browserSlotPattern;
        Cls cls = this.getSoleAllowedCls();
        BrowserSlotPattern browserSlotPattern2 = browserSlotPattern = cls == null ? null : cls.getBrowserSlotPattern();
        String string = browserSlotPattern == null ? null : (browserSlotPattern.isSimple() ? browserSlotPattern.getFirstSlot().getBrowserText() : "multiple slots");
        this._labeledComponent.setHeaderLabel(string);
    }

    private HeaderComponent createHeader() {
        JLabel jLabel = ComponentFactory.createLabel();
        String string = LocalizedText.getText(ResourceKey.INSTANCE_BROWSER_TITLE);
        String string2 = LocalizedText.getText(ResourceKey.CLASS_EDITOR_FOR_CLASS_LABEL);
        this._header = new HeaderComponent(string, string2, jLabel);
        this._header.setColor(Colors.getInstanceColor());
        return this._header;
    }

    private void fixRenderer() {
        FrameRenderer frameRenderer = (FrameRenderer)this._list.getCellRenderer();
        frameRenderer.setDisplayType(this._showSubclassInstances);
    }

    protected void addButtons(Action action, LabeledComponent labeledComponent) {
        labeledComponent.addHeaderButton(action);
        labeledComponent.addHeaderButton(this.createReferencersAction());
        labeledComponent.addHeaderButton(this.createCreateAction());
        labeledComponent.addHeaderButton(this.createCopyAction());
        labeledComponent.addHeaderButton(this.createDeleteAction());
        labeledComponent.addHeaderButton(this.createConfigureAction());
    }

    private void addClsListeners() {
        for (Cls cls : this._clses) {
            cls.addClsListener(this._clsListener);
            cls.addFrameListener(this._clsFrameListener);
        }
    }

    protected Action createCreateAction() {
        this._createAction = new CreateAction(ResourceKey.INSTANCE_CREATE){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCreate() {
                if (!DirectInstancesList.this._clses.isEmpty()) {
                    Object object;
                    KnowledgeBase knowledgeBase = DirectInstancesList.this._project.getKnowledgeBase();
                    Instance instance = knowledgeBase.createInstance(null, DirectInstancesList.this._clses);
                    if (instance instanceof Cls && (object = (Cls)instance).getDirectSuperclassCount() == 0) {
                        object.addDirectSuperclass(knowledgeBase.getRootCls());
                    }
                    object = DirectInstancesList.this;
                    synchronized (object) {
                        if (DirectInstancesList.this.background != null) {
                            DirectInstancesList.this.background.setDeferredSelection(instance);
                        }
                    }
                }
            }
        };
        return this._createAction;
    }

    protected Action createConfigureAction() {
        return new ConfigureAction(){

            public void loadPopupMenu(JPopupMenu jPopupMenu) {
                jPopupMenu.add(DirectInstancesList.this.createSetDisplaySlotAction());
                jPopupMenu.add(DirectInstancesList.this.createShowAllInstancesAction());
            }
        };
    }

    protected JMenuItem createShowAllInstancesAction() {
        AbstractAction abstractAction = new AbstractAction("Show Subclass Instances"){

            public void actionPerformed(ActionEvent actionEvent) {
                DirectInstancesList.this.setShowAllInstances(!DirectInstancesList.this._showSubclassInstances);
            }
        };
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(abstractAction);
        jCheckBoxMenuItem.setSelected(this._showSubclassInstances);
        return jCheckBoxMenuItem;
    }

    private void setShowAllInstances(boolean bl) {
        this._showSubclassInstances = bl;
        this.reload();
        this.fixRenderer();
    }

    protected Cls getSoleAllowedCls() {
        Cls cls = this._clses.size() == 1 ? CollectionUtilities.getFirstItem(this._clses) : null;
        return cls;
    }

    protected JMenu createSetDisplaySlotAction() {
        JMenu jMenu = ComponentFactory.createMenu("Set Display Slot");
        boolean bl = false;
        Cls cls = this.getSoleAllowedCls();
        if (cls != null) {
            Object object2;
            BrowserSlotPattern browserSlotPattern = cls.getBrowserSlotPattern();
            Slot slot = browserSlotPattern != null && browserSlotPattern.isSimple() ? browserSlotPattern.getFirstSlot() : null;
            for (Object object2 : cls.getVisibleTemplateSlots()) {
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(this.createSetDisplaySlotAction((Slot)object2));
                if (object2.equals(slot)) {
                    jRadioButtonMenuItem.setSelected(true);
                }
                jMenu.add(jRadioButtonMenuItem);
                bl = true;
            }
            object2 = new JRadioButtonMenuItem(this.createSetDisplaySlotMultipleAction());
            if (slot == null) {
                ((AbstractButton)object2).setSelected(true);
            }
            jMenu.add((JMenuItem)object2);
        }
        jMenu.setEnabled(bl);
        return jMenu;
    }

    protected Action createSetDisplaySlotAction(final Slot slot) {
        return new AbstractAction(slot.getBrowserText(), slot.getIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                DirectInstancesList.this.getSoleAllowedCls().setDirectBrowserSlot(slot);
                DirectInstancesList.this.updateLabel();
                DirectInstancesList.this.repaint();
            }
        };
    }

    protected Action createSetDisplaySlotMultipleAction() {
        return new AbstractAction("Multiple Slots..."){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserSlotPattern browserSlotPattern;
                Cls cls = DirectInstancesList.this.getSoleAllowedCls();
                BrowserSlotPattern browserSlotPattern2 = DirectInstancesList.this.getSoleAllowedCls().getBrowserSlotPattern();
                MultiSlotPanel multiSlotPanel = new MultiSlotPanel(browserSlotPattern2, cls);
                int n = ModalDialog.showDialog(DirectInstancesList.this, multiSlotPanel, "Multislot Display Pattern", 11);
                if (n == 1 && (browserSlotPattern = multiSlotPanel.getBrowserTextPattern()) != null) {
                    cls.setDirectBrowserSlotPattern(browserSlotPattern);
                }
                DirectInstancesList.this.updateLabel();
                DirectInstancesList.this.repaint();
            }
        };
    }

    protected Action createDeleteAction() {
        this._deleteAction = new DeleteInstancesAction(this);
        return this._deleteAction;
    }

    protected Action createCopyAction() {
        this._copyAction = new MakeCopiesAction(ResourceKey.INSTANCE_COPY, (Selectable)this){

            protected Instance copy(Instance instance, boolean bl) {
                Instance instance2 = super.copy(instance, bl);
                DirectInstancesList.this.setSelectedInstance(instance2);
                return instance2;
            }
        };
        return this._copyAction;
    }

    protected Action createReferencersAction() {
        return new ReferencersAction(ResourceKey.INSTANCE_VIEW_REFERENCES, (Selectable)this);
    }

    protected Action createViewAction() {
        return new ViewAction(ResourceKey.INSTANCE_VIEW, (Selectable)this){

            public void onView(Object object) {
                DirectInstancesList.this._project.show((Instance)object);
            }
        };
    }

    @Override
    public void dispose() {
        this.removeClsListeners();
        this._project.getKnowledgeBase().removeKnowledgeBaseListener(this.kbListener);
        if (this.background != null) {
            this.background.cancel();
            this.background = null;
        }
    }

    public JComponent getDragComponent() {
        return this._list;
    }

    private ConcurrentListModel getModel() {
        return (ConcurrentListModel)this._list.getModel();
    }

    private boolean isSelectionEditable() {
        boolean bl = true;
        for (Instance instance : this.getSelection()) {
            if (instance.isEditable()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    @Override
    public void onSelectionChange() {
        boolean bl = this.isSelectionEditable();
        ComponentUtilities.setDragAndDropEnabled(this._list, bl);
        this.updateButtons();
    }

    private void removeClsListeners() {
        for (Cls cls : this._clses) {
            cls.removeClsListener(this._clsListener);
            cls.removeFrameListener(this._clsFrameListener);
        }
    }

    public void setClses(Collection<Cls> collection) {
        this.removeClsListeners();
        this._clses = new ArrayList<Cls>(collection);
        this.reload();
        this.updateButtons();
        this.addClsListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        DirectInstancesList directInstancesList = this;
        synchronized (directInstancesList) {
            if (this.background != null) {
                this.background.cancel();
                this.background = null;
            }
        }
        directInstancesList = this._list.getSelectedValue();
        LinkedHashSet<Instance> linkedHashSet = new LinkedHashSet<Instance>();
        for (Cls object2 : this._clses) {
            linkedHashSet.addAll(this.getInstances(object2));
        }
        this.getModel().clear();
        DirectInstancesList directInstancesList2 = this;
        synchronized (directInstancesList2) {
            if (this.background != null) {
                this.background.cancel();
            }
            this.background = new AddInstancesRunner(new ArrayList<Instance>(linkedHashSet));
            Thread thread = new Thread((Runnable)this.background, "Calculate Instances For Panel");
            thread.start();
            if (linkedHashSet.contains(directInstancesList) && directInstancesList instanceof Instance) {
                this.background.setDeferredSelection((Instance)((Object)directInstancesList));
            }
        }
        if (!linkedHashSet.isEmpty()) {
            this._list.setSelectedIndex(0);
        }
        this.reloadHeader(this._clses);
        this.updateLabel();
    }

    private void reloadHeader(Collection<Cls> collection) {
        StringBuffer stringBuffer = new StringBuffer();
        Icon icon = null;
        for (Cls object2 : collection) {
            if (icon == null) {
                icon = object2.getIcon();
            }
            if (stringBuffer.length() != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(object2.getName());
        }
        JLabel jLabel = (JLabel)this._header.getComponent();
        jLabel.setText(stringBuffer.toString());
        jLabel.setIcon(icon);
    }

    private Collection<Instance> getInstances(Cls cls) {
        Collection<Instance> collection = this._showSubclassInstances ? cls.getInstances() : cls.getDirectInstances();
        if (!this._project.getDisplayHiddenFrames()) {
            collection = DirectInstancesList.removeHiddenInstances(collection);
        }
        return collection;
    }

    private static Collection<Instance> removeHiddenInstances(Collection<Instance> collection) {
        ArrayList<Instance> arrayList = new ArrayList<Instance>(collection);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Instance instance = (Instance)iterator.next();
            if (instance.isVisible()) continue;
            iterator.remove();
        }
        return arrayList;
    }

    public synchronized void setSelectedInstance(Instance instance) {
        if (this.background != null && !this.getModel().contains(instance)) {
            this.background.setDeferredSelection(instance);
        } else {
            this._list.setSelectedValue(instance);
        }
    }

    private void updateButtons() {
        Cls cls = CollectionUtilities.getFirstItem(this._clses);
        this._createAction.setEnabled(cls == null ? false : cls.isConcrete());
        Instance instance = (Instance)this.getSoleSelection();
        boolean bl = instance != null && instance instanceof SimpleInstance;
        this._copyAction.setAllowed(bl);
    }

    public void setListRenderer(ListCellRenderer listCellRenderer) {
        this._list.setCellRenderer(listCellRenderer);
        if (listCellRenderer instanceof FrameRenderer) {
            ((FrameRenderer)listCellRenderer).setDisplayType(this._showSubclassInstances);
        }
    }

    @Deprecated
    public void setShowDisplaySlotPanel(boolean bl) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AddInstancesRunner
    implements Runnable {
        private List<Instance> instances;
        private List<AbstractEvent> changes = new ArrayList<AbstractEvent>();
        private Instance deferredSelection;
        private boolean sorted;
        private boolean cancelled = false;

        public AddInstancesRunner(List<Instance> list) {
            this.instances = list;
            this.sorted = SORT_LIMIT < 0 || list.size() < SORT_LIMIT;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                this.waitToProcessEvents();
                this.addOneInstance(this.getNextInstance());
                AddInstancesRunner addInstancesRunner = this;
                synchronized (addInstancesRunner) {
                    if (this.cancelled) {
                        return;
                    }
                }
                this.handleChanges();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitToProcessEvents() {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                Log.getLogger().log(Level.SEVERE, "Interrupt caught - why?", interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.getLogger().log(Level.SEVERE, "Programmer error", invocationTargetException);
            }
            AddInstancesRunner addInstancesRunner = this;
            synchronized (addInstancesRunner) {
                if (this.instances.isEmpty() && !this.cancelled && this.changes.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Log.getLogger().log(Level.SEVERE, "Interrupted thread - why?", interruptedException);
                    }
                }
            }
        }

        private void addOneInstance(final Instance instance) {
            if (instance == null) {
                return;
            }
            if (!DirectInstancesList.this.getModel().contains(instance)) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            if (!AddInstancesRunner.this.cancelled) {
                                AddInstancesRunner.this.insertInstanceInList(instance);
                            }
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    Log.getLogger().log(Level.SEVERE, "Exception caught talking to swing", interruptedException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Log.getLogger().log(Level.SEVERE, "Exception caught talking to swing", invocationTargetException);
                }
            }
        }

        private synchronized Instance getNextInstance() {
            if (this.instances.isEmpty() || this.cancelled) {
                return null;
            }
            Instance instance = this.instances.get(0);
            this.instances.remove(0);
            return instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleChanges() {
            Instance instance;
            boolean bl;
            final ArrayList<AbstractEvent> arrayList = new ArrayList<AbstractEvent>();
            AddInstancesRunner addInstancesRunner = this;
            synchronized (addInstancesRunner) {
                bl = this.changes.isEmpty();
                arrayList.addAll(this.changes);
                this.changes.clear();
                instance = this.deferredSelection;
                this.deferredSelection = null;
            }
            if (!bl || instance != null) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            if (AddInstancesRunner.this.cancelled) {
                                return;
                            }
                            for (AbstractEvent abstractEvent : arrayList) {
                                AbstractEvent abstractEvent2;
                                if (abstractEvent instanceof ClsEvent) {
                                    abstractEvent2 = (ClsEvent)abstractEvent;
                                    if (abstractEvent2.getEventType() == 305) {
                                        Instance instance2 = ((ClsEvent)abstractEvent2).getInstance();
                                        AddInstancesRunner.this.insertInstanceInList(instance2);
                                        AddInstancesRunner.this.instances.remove(instance2);
                                        continue;
                                    }
                                    if (abstractEvent2.getEventType() != 306) continue;
                                    Instance instance3 = ((ClsEvent)abstractEvent2).getInstance();
                                    DirectInstancesList.this.getModel().removeValue(instance3);
                                    AddInstancesRunner.this.instances.remove(instance3);
                                    continue;
                                }
                                if (abstractEvent instanceof FrameEvent) {
                                    abstractEvent2 = (FrameEvent)abstractEvent;
                                    Frame frame = ((FrameEvent)abstractEvent2).getFrame();
                                    if (abstractEvent2.getEventType() != 110 || !DirectInstancesList.this.getModel().contains(frame) || !(frame instanceof Instance)) continue;
                                    DirectInstancesList.this.getModel().removeValue(frame);
                                    DirectInstancesList.this.updateButtons();
                                    continue;
                                }
                                if (!(abstractEvent instanceof KnowledgeBaseEvent) || (abstractEvent2 = (KnowledgeBaseEvent)abstractEvent).getEventType() != 101) continue;
                                boolean bl = DirectInstancesList.this._list.getSelection().contains(((KnowledgeBaseEvent)abstractEvent2).getFrame()) && instance == null;
                                AddInstancesRunner.this.instances.remove(((KnowledgeBaseEvent)abstractEvent2).getFrame());
                                DirectInstancesList.this.getModel().removeValue(((KnowledgeBaseEvent)abstractEvent2).getFrame());
                                AddInstancesRunner.this.insertInstanceInList((Instance)((KnowledgeBaseEvent)abstractEvent2).getNewFrame());
                                if (!bl) continue;
                                DirectInstancesList.this._list.setSelectedValue(((KnowledgeBaseEvent)abstractEvent2).getNewFrame());
                            }
                            if (instance != null) {
                                if (AddInstancesRunner.this.instances.contains(instance)) {
                                    AddInstancesRunner.this.insertInstanceInList(instance);
                                    AddInstancesRunner.this.instances.remove(instance);
                                }
                                DirectInstancesList.this._list.setSelectedValue(instance, true);
                                DirectInstancesList.this.updateButtons();
                            }
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    Log.getLogger().log(Level.SEVERE, "Interrupted Thread - why?", interruptedException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Log.getLogger().log(Level.WARNING, "Exception processing updates to instance list", invocationTargetException);
                }
            }
        }

        private void insertInstanceInList(Instance instance) {
            if (this.sorted) {
                List list = DirectInstancesList.this.getModel().toList();
                int n = Collections.binarySearch(list, instance, new FrameComparator());
                if (n >= 0) {
                    DirectInstancesList.this.getModel().addValue(instance, n);
                } else if (n < 0) {
                    DirectInstancesList.this.getModel().addValue(instance, -n - 1);
                }
            } else {
                DirectInstancesList.this.getModel().addValue(instance);
            }
        }

        public synchronized void addChange(AbstractEvent abstractEvent) {
            if (abstractEvent.isReplacementEvent() && abstractEvent.getEventType() != 101) {
                return;
            }
            this.changes.add(abstractEvent);
            this.notifyAll();
        }

        public synchronized void setDeferredSelection(Instance instance) {
            this.deferredSelection = instance;
        }

        public synchronized void cancel() {
            this.cancelled = true;
            this.notifyAll();
        }
    }
}

