/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.ListenerCollection;
import edu.stanford.smi.protege.util.ListenerList;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.SelectionEventDispatcher;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Graphics;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JPanel;

public abstract class AbstractWidget
extends JPanel {
    private WidgetDescriptor _descriptor;
    private boolean _isDesignTime;
    private Project _project;
    private ListenerCollection _selectionListeners = new ListenerList(new SelectionEventDispatcher());

    public AbstractWidget() {
        this.setLayout(new BorderLayout());
        this.setName(StringUtilities.getClassName(this));
    }

    public void dispose() {
    }

    public void setup(WidgetDescriptor widgetDescriptor, boolean bl, Project project) {
        this._descriptor = widgetDescriptor;
        this._isDesignTime = bl;
        this._project = project;
    }

    public WidgetDescriptor getDescriptor() {
        return this._descriptor;
    }

    public KnowledgeBase getKnowledgeBase() {
        return this._project.getKnowledgeBase();
    }

    public Project getProject() {
        return this._project;
    }

    public PropertyList getPropertyList() {
        return this._descriptor.getPropertyList();
    }

    public void setPropertyList(PropertyList propertyList) {
        Assert.assertTrue("design time", this.isDesignTime());
        this._descriptor.setPropertyList(propertyList);
    }

    public String getStringProperty(String string, String string2) {
        String string3 = this.getPropertyList().getString(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public boolean isDesignTime() {
        return this._isDesignTime;
    }

    public boolean isRuntime() {
        return !this._isDesignTime;
    }

    public void show(Cls cls, Slot slot) {
        this.getProject().show(cls, slot);
    }

    public void showInstance(Instance instance) {
        this.getProject().show(instance);
    }

    public String getLabel() {
        return this._descriptor.getLabel();
    }

    public void setLabel(String string) {
        this._descriptor.setLabel(string);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this._selectionListeners.add(this, selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this._selectionListeners.remove(this, selectionListener);
    }

    public void notifySelectionListeners() {
        this._selectionListeners.postEvent(this, 1);
    }

    public void clearSelection() {
    }

    public Collection getSelection() {
        return Collections.EMPTY_LIST;
    }

    public static boolean equals(Object object, Object object2) {
        return SystemUtilities.equals(object, object2);
    }

    protected void beginTransaction(String string) {
        this.getKnowledgeBase().beginTransaction(string);
    }

    protected void beginTransaction(String string, String string2) {
        this.getKnowledgeBase().beginTransaction(string, string2);
    }

    protected void endTransaction() {
        this.getKnowledgeBase().commitTransaction();
    }

    protected void commitTransaction() {
        this.getKnowledgeBase().commitTransaction();
    }

    protected void rollbackTransaction() {
        this.getKnowledgeBase().rollbackTransaction();
    }

    public void paint(Graphics graphics) {
        ComponentUtilities.enableTextAntialiasing(graphics);
        super.paint(graphics);
    }
}

