/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.event.KnowledgeBaseAdapter;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.event.ServerProjectAdapter;
import edu.stanford.smi.protege.event.ServerProjectNotificationEvent;
import edu.stanford.smi.protege.event.ServerProjectStatusChangeEvent;
import edu.stanford.smi.protege.event.TransactionAdapter;
import edu.stanford.smi.protege.event.TransactionEvent;
import edu.stanford.smi.protege.exception.TransactionException;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.EventDispatchFrameStore;
import edu.stanford.smi.protege.model.framestore.EventGeneratorFrameStore;
import edu.stanford.smi.protege.model.framestore.EventSinkFrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStoreManager;
import edu.stanford.smi.protege.server.RemoteProjectManager;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.ServerProject;
import edu.stanford.smi.protege.server.Server_Test;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.test.APITestCase;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.LockStepper;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import junit.framework.Assert;

public class DBServer_Test
extends APITestCase {
    private static final String HOST = "localhost";
    private static final String NAME = "//localhost/" + Server.getBoundName();
    public static final String DBTYPE_PROPERTY = "junit.server.db.dbtype";
    public static final String DBPROJECT_PROPERTY = "junit.server.db.file.dbproject";
    public static final String DB_SERVER_METAPROJECT_PROPERTY = "junit.server.db.file.metaproject";
    public static final String DB_CLIENT_PROJECT_PROPERTY = "junit.server.db.client_project";
    private static final String USER = "Ray Fergerson";
    private static final String PASSWORD = "claudia";
    private static String clientProject;
    private static boolean configured;
    private static int counter;
    private boolean informedNotConfigured = false;

    public void setUp() throws Exception {
        super.setUp();
        if (clientProject == null) {
            if (!this.informedNotConfigured) {
                System.out.println("Server/Database tests not configured");
                this.informedNotConfigured = true;
            }
            configured = false;
        }
        Properties properties = DBServer_Test.getJunitProperties();
        String string = properties.getProperty(DB_SERVER_METAPROJECT_PROPERTY);
        try {
            Server_Test.setMetaProject(string);
            Server_Test.startServer();
            Naming.lookup(NAME);
        }
        catch (NotBoundException notBoundException) {
            DBServer_Test.fail((String)"Could not bind to server (is rmiregistry running?)");
        }
        this.cleanProject();
    }

    public void createDatabaseProject() {
        Properties properties = DBServer_Test.getJunitProperties();
        String string = properties.getProperty(DBTYPE_PROPERTY);
        String string2 = properties.getProperty(DBPROJECT_PROPERTY);
        if (string == null) {
            System.out.println("Server+Database Test not configured");
            return;
        }
        for (APITestCase.DBType dBType : APITestCase.DBType.values()) {
            if (!dBType.toString().equals(string)) continue;
            DBServer_Test.setDBType(dBType);
            break;
        }
        DBServer_Test.setDatabaseProject();
        ArrayList arrayList = new ArrayList();
        this.getProject().setProjectFilePath(string2);
        this.getProject().save(arrayList);
        DBServer_Test.closeProject();
    }

    public DefaultKnowledgeBase getKb() {
        RemoteProjectManager remoteProjectManager = RemoteProjectManager.getInstance();
        Project project = remoteProjectManager.getProject(HOST, USER, PASSWORD, clientProject, true);
        return (DefaultKnowledgeBase)project.getKnowledgeBase();
    }

    public void cleanProject() {
        boolean bl = true;
        DefaultKnowledgeBase defaultKnowledgeBase = this.getKb();
        while (bl) {
            bl = false;
            for (Frame frame : defaultKnowledgeBase.getFrames()) {
                if (frame.isSystem()) continue;
                if (frame instanceof Cls) {
                    Cls cls = (Cls)frame;
                    if (cls.getInstanceCount() != 0) continue;
                    cls.delete();
                    bl = true;
                    continue;
                }
                frame.delete();
                bl = true;
            }
        }
        defaultKnowledgeBase.getProject().dispose();
    }

    private String newName() {
        return "A" + counter++;
    }

    public TransactionMonitor getTransactionMonitor() {
        Server server = Server.getInstance();
        ServerProject serverProject = server.getServerProject(clientProject);
        ServerFrameStore serverFrameStore = (ServerFrameStore)serverProject.getDomainKbFrameStore(null);
        return serverFrameStore.getTransactionStatusMonitor();
    }

    public void getUpdatesFromOtherThread(KnowledgeBase knowledgeBase) {
        knowledgeBase.createCls(this.newName(), Collections.singleton(knowledgeBase.getRootCls()));
    }

    public static void main(String[] stringArray) throws Exception {
        DBServer_Test dBServer_Test = new DBServer_Test();
        dBServer_Test.createDatabaseProject();
    }

    public void testTransaction01() throws Exception {
        if (!configured) {
            return;
        }
        try {
            final LockStepper<Test01Stages> lockStepper = new LockStepper<Test01Stages>(Test01Stages.testStarted);
            DefaultKnowledgeBase defaultKnowledgeBase = this.getKb();
            RemoteClientFrameStore.setTransactionIsolationLevel(defaultKnowledgeBase, TransactionIsolationLevel.READ_COMMITTED);
            new Thread("Second Transaction With Writes Thread"){

                public void run() {
                    try {
                        String string = "My transaction";
                        DefaultKnowledgeBase defaultKnowledgeBase = DBServer_Test.this.getKb();
                        RemoteClientFrameStore.setTransactionIsolationLevel(defaultKnowledgeBase, TransactionIsolationLevel.READ_COMMITTED);
                        Cls cls = (Cls)lockStepper.waitForStage(Test01Stages.mainThreadStarted);
                        defaultKnowledgeBase.beginTransaction(string);
                        Cls cls2 = defaultKnowledgeBase.createCls(DBServer_Test.this.newName(), Collections.singleton(cls));
                        lockStepper.stageAchieved(Test01Stages.transactionOpenWithWrite, cls2);
                        lockStepper.waitForStage(Test01Stages.readComplete);
                        defaultKnowledgeBase.commitTransaction();
                        defaultKnowledgeBase.getProject().dispose();
                        lockStepper.stageAchieved(Test01Stages.testComplete, null);
                    }
                    catch (Throwable throwable) {
                        lockStepper.exceptionOffMainThread(Test01Stages.testComplete, throwable);
                    }
                }
            }.start();
            Cls cls = defaultKnowledgeBase.createCls(this.newName(), Collections.singleton(defaultKnowledgeBase.getSystemFrames().getRootCls()));
            lockStepper.stageAchieved(Test01Stages.mainThreadStarted, cls);
            lockStepper.waitForStage(Test01Stages.transactionOpenWithWrite);
            this.getUpdatesFromOtherThread(defaultKnowledgeBase);
            Collection collection = defaultKnowledgeBase.getSubclasses(cls);
            if (collection != null && !collection.isEmpty()) {
                DBServer_Test.fail((String)"Should not see subclasses being created by other thread.");
            }
            lockStepper.stageAchieved(Test01Stages.readComplete, null);
            lockStepper.waitForStage(Test01Stages.testComplete);
            defaultKnowledgeBase.getProject().dispose();
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Test failed, e");
            throw exception;
        }
    }

    public void testTransaction02_1() throws Exception {
        this.doTest02(true, true);
    }

    public void testTransaction02_2() throws Exception {
        this.doTest02(true, false);
    }

    public void testTransaction02_3() throws Exception {
        this.doTest02(false, true);
    }

    public void testTransaction02_4() throws Exception {
        this.doTest02(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTest02(boolean bl, final boolean bl2) throws Exception {
        if (!configured) {
            return;
        }
        try {
            DefaultKnowledgeBase defaultKnowledgeBase = this.getKb();
            RemoteClientFrameStore.setTransactionIsolationLevel(defaultKnowledgeBase, TransactionIsolationLevel.REPEATABLE_READ);
            final LockStepper<Test02Stages> lockStepper = new LockStepper<Test02Stages>(Test02Stages.testStarted);
            final Cls cls = defaultKnowledgeBase.createCls(this.newName(), Collections.singleton(defaultKnowledgeBase.getSystemFrames().getRootCls()));
            new Thread("Second Transaction with Writes Thread doTest02(" + bl + "," + bl2 + ")"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        DefaultKnowledgeBase defaultKnowledgeBase = DBServer_Test.this.getKb();
                        try {
                            defaultKnowledgeBase.beginTransaction("transaction will modify testCls after other transaction reads testCls");
                            lockStepper.waitForStage(Test02Stages.firstReadComplete);
                            defaultKnowledgeBase.createCls(DBServer_Test.this.newName(), Collections.singleton(cls));
                            Assert.assertTrue((defaultKnowledgeBase.getSubclasses(cls).size() == 1 ? 1 : 0) != 0);
                            lockStepper.stageAchieved(Test02Stages.writeComplete, null);
                            lockStepper.waitForStage(Test02Stages.secondReadComplete);
                        }
                        finally {
                            if (bl2) {
                                defaultKnowledgeBase.commitTransaction();
                            } else {
                                defaultKnowledgeBase.rollbackTransaction();
                            }
                        }
                        if (bl2) {
                            Assert.assertTrue((defaultKnowledgeBase.getSubclasses(cls).size() == 1 ? 1 : 0) != 0);
                        } else {
                            Assert.assertTrue((boolean)defaultKnowledgeBase.getSubclasses(cls).isEmpty());
                        }
                        lockStepper.stageAchieved(Test02Stages.otherTransactionClosed, null);
                        lockStepper.waitForStage(Test02Stages.thirdReadComplete);
                        defaultKnowledgeBase.getProject().dispose();
                        lockStepper.stageAchieved(Test02Stages.testComplete, null);
                    }
                    catch (Throwable throwable) {
                        lockStepper.exceptionOffMainThread(Test02Stages.testComplete, throwable);
                    }
                }
            }.start();
            try {
                defaultKnowledgeBase.beginTransaction("Repeatable Read");
                DBServer_Test.assertTrue((boolean)defaultKnowledgeBase.getSubclasses(cls).isEmpty());
                lockStepper.stageAchieved(Test02Stages.firstReadComplete, null);
                lockStepper.waitForStage(Test02Stages.writeComplete);
                this.getUpdatesFromOtherThread(defaultKnowledgeBase);
                DBServer_Test.assertTrue((boolean)defaultKnowledgeBase.getSubclasses(cls).isEmpty());
                lockStepper.stageAchieved(Test02Stages.secondReadComplete, null);
                lockStepper.waitForStage(Test02Stages.otherTransactionClosed);
                this.getUpdatesFromOtherThread(defaultKnowledgeBase);
                DBServer_Test.assertTrue((boolean)defaultKnowledgeBase.getSubclasses(cls).isEmpty());
            }
            finally {
                if (bl) {
                    defaultKnowledgeBase.commitTransaction();
                } else {
                    defaultKnowledgeBase.rollbackTransaction();
                }
            }
            if (bl2) {
                DBServer_Test.assertTrue((defaultKnowledgeBase.getSubclasses(cls).size() == 1 ? 1 : 0) != 0);
            } else {
                DBServer_Test.assertTrue((boolean)defaultKnowledgeBase.getSubclasses(cls).isEmpty());
            }
            lockStepper.stageAchieved(Test02Stages.thirdReadComplete, null);
            lockStepper.waitForStage(Test02Stages.testComplete);
            defaultKnowledgeBase.getProject().dispose();
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Test faiiled", exception);
            throw exception;
        }
    }

    public void testTransaction03() {
        if (!configured) {
            return;
        }
        DefaultKnowledgeBase defaultKnowledgeBase = this.getKb();
        TransactionMonitor transactionMonitor = this.getTransactionMonitor();
        DBServer_Test.assertTrue((boolean)transactionMonitor.getSessions().isEmpty());
        defaultKnowledgeBase.beginTransaction("Outer");
        DBServer_Test.assertTrue((transactionMonitor.getSessions().size() == 1 ? 1 : 0) != 0);
        RemoteSession remoteSession = transactionMonitor.getSessions().iterator().next();
        defaultKnowledgeBase.beginTransaction("First Inner");
        DBServer_Test.assertTrue((transactionMonitor.getNesting(remoteSession) == 2 ? 1 : 0) != 0);
        defaultKnowledgeBase.rollbackTransaction();
        DBServer_Test.assertTrue((transactionMonitor.getNesting(remoteSession) == 1 ? 1 : 0) != 0);
        defaultKnowledgeBase.beginTransaction("Second Inner");
        DBServer_Test.assertTrue((transactionMonitor.getNesting(remoteSession) == 2 ? 1 : 0) != 0);
        defaultKnowledgeBase.commitTransaction();
        DBServer_Test.assertTrue((transactionMonitor.getNesting(remoteSession) == 1 ? 1 : 0) != 0);
        defaultKnowledgeBase.commitTransaction();
        DBServer_Test.assertTrue((transactionMonitor.getNesting(remoteSession) == 0 ? 1 : 0) != 0);
        defaultKnowledgeBase.getProject().dispose();
    }

    public void testTransaction04() throws TransactionException {
        if (!configured) {
            return;
        }
        DefaultKnowledgeBase defaultKnowledgeBase = this.getKb();
        RemoteClientFrameStore.setTransactionIsolationLevel(defaultKnowledgeBase, TransactionIsolationLevel.REPEATABLE_READ);
        final LockStepper<Test04Stages> lockStepper = new LockStepper<Test04Stages>(Test04Stages.testStarted);
        Cls cls = defaultKnowledgeBase.createCls(this.newName(), Collections.singleton(defaultKnowledgeBase.getSystemFrames().getRootCls()));
        final Cls cls2 = defaultKnowledgeBase.createCls(this.newName(), Collections.singleton(cls));
        Cls cls3 = defaultKnowledgeBase.createCls(this.newName(), Collections.singleton(cls2));
        new Thread("Second knowledge base which writes a sub-subclass"){

            public void run() {
                try {
                    DefaultKnowledgeBase defaultKnowledgeBase = DBServer_Test.this.getKb();
                    RemoteClientFrameStore.setTransactionIsolationLevel(defaultKnowledgeBase, TransactionIsolationLevel.REPEATABLE_READ);
                    defaultKnowledgeBase.beginTransaction("Transaction in other thread");
                    lockStepper.waitForStage(Test04Stages.firstRead);
                    Cls cls = defaultKnowledgeBase.createCls(DBServer_Test.this.newName(), Collections.singleton(cls2));
                    lockStepper.stageAchieved(Test04Stages.write, cls);
                    lockStepper.waitForStage(Test04Stages.secondRead);
                    defaultKnowledgeBase.commitTransaction();
                    lockStepper.stageAchieved(Test04Stages.firstCommit, null);
                    lockStepper.waitForStage(Test04Stages.preComplete);
                    defaultKnowledgeBase.getProject().dispose();
                    lockStepper.stageAchieved(Test04Stages.testCompleted, null);
                }
                catch (Exception exception) {
                    lockStepper.exceptionOffMainThread(Test04Stages.testCompleted, exception);
                }
            }
        }.start();
        defaultKnowledgeBase.beginTransaction("First knowledge base which does some reading");
        Collection collection = defaultKnowledgeBase.getSubclasses(cls);
        DBServer_Test.assertTrue((boolean)collection.contains(cls3));
        lockStepper.stageAchieved(Test04Stages.firstRead, null);
        Cls cls4 = (Cls)lockStepper.waitForStage(Test04Stages.write);
        LocalizeUtils.localize(cls4, defaultKnowledgeBase);
        this.getUpdatesFromOtherThread(defaultKnowledgeBase);
        collection = defaultKnowledgeBase.getDirectSubclasses(cls2);
        DBServer_Test.assertTrue((collection.size() == 1 ? 1 : 0) != 0);
        DBServer_Test.assertTrue((!collection.contains(cls4) ? 1 : 0) != 0);
        lockStepper.stageAchieved(Test04Stages.secondRead, null);
        lockStepper.waitForStage(Test04Stages.firstCommit);
        this.getUpdatesFromOtherThread(defaultKnowledgeBase);
        collection = defaultKnowledgeBase.getDirectSubclasses(cls2);
        DBServer_Test.assertTrue((collection.size() == 1 ? 1 : 0) != 0);
        DBServer_Test.assertTrue((!collection.contains(cls4) ? 1 : 0) != 0);
        defaultKnowledgeBase.commitTransaction();
        collection = defaultKnowledgeBase.getDirectSubclasses(cls2);
        DBServer_Test.assertTrue((collection.size() == 2 ? 1 : 0) != 0);
        DBServer_Test.assertTrue((boolean)collection.contains(cls4));
        lockStepper.stageAchieved(Test04Stages.preComplete, null);
        lockStepper.waitForStage(Test04Stages.testCompleted);
        defaultKnowledgeBase.getProject().dispose();
    }

    public void testTransaction05() throws TransactionException {
        if (!configured) {
            return;
        }
        DefaultKnowledgeBase defaultKnowledgeBase = this.getKb();
        RemoteClientFrameStore.setTransactionIsolationLevel(defaultKnowledgeBase, TransactionIsolationLevel.READ_COMMITTED);
        final LockStepper<Test05Stages> lockStepper = new LockStepper<Test05Stages>(Test05Stages.testStarted);
        Cls cls = defaultKnowledgeBase.createCls(this.newName(), Collections.singleton(defaultKnowledgeBase.getSystemFrames().getRootCls()));
        final Cls cls2 = defaultKnowledgeBase.createCls(this.newName(), Collections.singleton(cls));
        Cls cls3 = defaultKnowledgeBase.createCls(this.newName(), Collections.singleton(cls2));
        new Thread("Second knowledge base which writes a sub-subclass"){

            public void run() {
                try {
                    DefaultKnowledgeBase defaultKnowledgeBase = DBServer_Test.this.getKb();
                    RemoteClientFrameStore.setTransactionIsolationLevel(defaultKnowledgeBase, TransactionIsolationLevel.READ_COMMITTED);
                    defaultKnowledgeBase.beginTransaction("Transaction in other thread");
                    lockStepper.waitForStage(Test05Stages.firstRead);
                    Cls cls = defaultKnowledgeBase.createCls(DBServer_Test.this.newName(), Collections.singleton(cls2));
                    lockStepper.stageAchieved(Test05Stages.write, cls);
                    lockStepper.waitForStage(Test05Stages.secondRead);
                    defaultKnowledgeBase.commitTransaction();
                    lockStepper.stageAchieved(Test05Stages.firstCommit, null);
                    lockStepper.waitForStage(Test05Stages.preComplete);
                    defaultKnowledgeBase.getProject().dispose();
                    lockStepper.stageAchieved(Test05Stages.testCompleted, null);
                }
                catch (Exception exception) {
                    lockStepper.exceptionOffMainThread(Test05Stages.testCompleted, exception);
                }
            }
        }.start();
        defaultKnowledgeBase.beginTransaction("First knowledge base which does some reading");
        Collection collection = defaultKnowledgeBase.getSubclasses(cls);
        DBServer_Test.assertTrue((boolean)collection.contains(cls3));
        lockStepper.stageAchieved(Test05Stages.firstRead, null);
        Cls cls4 = (Cls)lockStepper.waitForStage(Test05Stages.write);
        LocalizeUtils.localize(cls4, defaultKnowledgeBase);
        this.getUpdatesFromOtherThread(defaultKnowledgeBase);
        collection = defaultKnowledgeBase.getDirectSubclasses(cls2);
        DBServer_Test.assertTrue((collection.size() == 1 ? 1 : 0) != 0);
        DBServer_Test.assertTrue((!collection.contains(cls4) ? 1 : 0) != 0);
        lockStepper.stageAchieved(Test05Stages.secondRead, null);
        lockStepper.waitForStage(Test05Stages.firstCommit);
        this.getUpdatesFromOtherThread(defaultKnowledgeBase);
        collection = defaultKnowledgeBase.getDirectSubclasses(cls2);
        DBServer_Test.assertTrue((collection.size() == 2 ? 1 : 0) != 0);
        DBServer_Test.assertTrue((boolean)collection.contains(cls4));
        defaultKnowledgeBase.commitTransaction();
        this.getUpdatesFromOtherThread(defaultKnowledgeBase);
        collection = defaultKnowledgeBase.getDirectSubclasses(cls2);
        DBServer_Test.assertTrue((collection.size() == 2 ? 1 : 0) != 0);
        DBServer_Test.assertTrue((boolean)collection.contains(cls4));
        lockStepper.stageAchieved(Test05Stages.preComplete, null);
        lockStepper.waitForStage(Test05Stages.testCompleted);
        defaultKnowledgeBase.getProject().dispose();
    }

    public void testTransaction06() throws TransactionException {
        if (!configured) {
            return;
        }
        final LockStepper<Test06Stages> lockStepper = new LockStepper<Test06Stages>(Test06Stages.start);
        DefaultKnowledgeBase defaultKnowledgeBase = this.getKb();
        RemoteClientFrameStore.setTransactionIsolationLevel(defaultKnowledgeBase, TransactionIsolationLevel.REPEATABLE_READ);
        final Cls cls = defaultKnowledgeBase.createCls(this.newName(), Collections.singleton(defaultKnowledgeBase.getRootCls()));
        final Cls cls2 = defaultKnowledgeBase.createCls(this.newName(), Collections.singleton(cls));
        final Cls cls3 = defaultKnowledgeBase.createCls(this.newName(), Collections.singleton(cls));
        final Slot slot = defaultKnowledgeBase.createSlot(this.newName(), defaultKnowledgeBase.getSystemFrames().getStandardSlotMetaCls());
        defaultKnowledgeBase.setDirectOwnSlotValues(cls, slot, Collections.singleton(cls2));
        List list = defaultKnowledgeBase.getDirectOwnSlotValues(cls, slot);
        DBServer_Test.assertTrue((boolean)list.contains(cls2));
        DBServer_Test.assertTrue((!list.contains(cls3) ? 1 : 0) != 0);
        new Thread("Non-transaction write thread"){

            public void run() {
                try {
                    DefaultKnowledgeBase defaultKnowledgeBase = DBServer_Test.this.getKb();
                    RemoteClientFrameStore.setTransactionIsolationLevel(defaultKnowledgeBase, TransactionIsolationLevel.REPEATABLE_READ);
                    lockStepper.waitForStage(Test06Stages.inTransaction);
                    defaultKnowledgeBase.setDirectOwnSlotValues(cls, slot, Collections.singleton(cls3));
                    List list = defaultKnowledgeBase.getDirectOwnSlotValues(cls, slot);
                    LocalizeUtils.localize(cls2, defaultKnowledgeBase);
                    LocalizeUtils.localize(cls3, defaultKnowledgeBase);
                    Assert.assertTrue((!list.contains(cls2) ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)list.contains(cls3));
                    lockStepper.stageAchieved(Test06Stages.write, null);
                    lockStepper.waitForStage(Test06Stages.preComplete);
                    lockStepper.stageAchieved(Test06Stages.completed, null);
                }
                catch (Exception exception) {
                    lockStepper.exceptionOffMainThread(Test06Stages.completed, exception);
                }
            }
        }.start();
        defaultKnowledgeBase.beginTransaction("A lone transaction");
        list = defaultKnowledgeBase.getDirectOwnSlotValues(cls, slot);
        LocalizeUtils.localize(cls2, defaultKnowledgeBase);
        LocalizeUtils.localize(cls3, defaultKnowledgeBase);
        DBServer_Test.assertTrue((boolean)list.contains(cls2));
        DBServer_Test.assertTrue((!list.contains(cls3) ? 1 : 0) != 0);
        lockStepper.stageAchieved(Test06Stages.inTransaction, null);
        lockStepper.waitForStage(Test06Stages.write);
        this.getUpdatesFromOtherThread(defaultKnowledgeBase);
        list = defaultKnowledgeBase.getDirectOwnSlotValues(cls, slot);
        LocalizeUtils.localize(cls2, defaultKnowledgeBase);
        LocalizeUtils.localize(cls3, defaultKnowledgeBase);
        DBServer_Test.assertTrue((boolean)list.contains(cls2));
        DBServer_Test.assertTrue((!list.contains(cls3) ? 1 : 0) != 0);
        defaultKnowledgeBase.commitTransaction();
        list = defaultKnowledgeBase.getDirectOwnSlotValues(cls, slot);
        DBServer_Test.assertTrue((!list.contains(cls2) ? 1 : 0) != 0);
        DBServer_Test.assertTrue((boolean)list.contains(cls3));
        lockStepper.stageAchieved(Test06Stages.preComplete, null);
        lockStepper.waitForStage(Test06Stages.completed);
    }

    public void testTransaction07() {
        if (!configured) {
            return;
        }
        final LockStepper<Test07Stages> lockStepper = new LockStepper<Test07Stages>(Test07Stages.START);
        new Thread("Client Accessing the server"){

            public void run() {
                try {
                    DefaultKnowledgeBase defaultKnowledgeBase = DBServer_Test.this.getKb();
                    RemoteClientFrameStore.setTransactionIsolationLevel(defaultKnowledgeBase, TransactionIsolationLevel.REPEATABLE_READ);
                    Cls cls = defaultKnowledgeBase.getSystemFrames().getRootCls();
                    lockStepper.stageAchieved(Test07Stages.CLIENT_CONNECTED, null);
                    lockStepper.waitForStage(Test07Stages.LISTENERS_INSTALLED_GO);
                    defaultKnowledgeBase.beginTransaction("Starting outer transaction");
                    defaultKnowledgeBase.createCls("A", Collections.singleton(cls));
                    DBServer_Test.this.assertEventFired(701);
                    assert (DBServer_Test.this.getEventFired(601) == null);
                    defaultKnowledgeBase.beginTransaction("Starting inner transaction");
                    defaultKnowledgeBase.createSlot("f");
                    assert (DBServer_Test.this.getEventFired(603) == null);
                    defaultKnowledgeBase.commitTransaction();
                    assert (DBServer_Test.this.getEventFired(603) == null);
                    assert (DBServer_Test.this.getEventFired(601) == null);
                    defaultKnowledgeBase.commitTransaction();
                    DBServer_Test.this.assertEventFired(601);
                    DBServer_Test.this.assertEventFired(603);
                    lockStepper.stageAchieved(Test07Stages.COMPLETED, null);
                }
                catch (Exception exception) {
                    lockStepper.exceptionOffMainThread(Test07Stages.COMPLETED, exception);
                }
            }
        }.start();
        lockStepper.waitForStage(Test07Stages.CLIENT_CONNECTED);
        KnowledgeBase knowledgeBase = Server.getInstance().getProject(clientProject).getKnowledgeBase();
        knowledgeBase.setDispatchEventsEnabled(true);
        knowledgeBase.getFrameStoreManager().getFrameStoreFromClass(EventDispatchFrameStore.class).setPassThrough(true);
        this.clearEvents();
        knowledgeBase.addTransactionListener(new TransactionAdapter(){

            public void transactionBegin(TransactionEvent transactionEvent) {
                DBServer_Test.this.recordEventFired(transactionEvent);
            }
        });
        knowledgeBase.addKnowledgeBaseListener(new KnowledgeBaseAdapter(){

            public void clsCreated(KnowledgeBaseEvent knowledgeBaseEvent) {
                DBServer_Test.this.recordEventFired(knowledgeBaseEvent);
            }

            public void slotCreated(KnowledgeBaseEvent knowledgeBaseEvent) {
                DBServer_Test.this.recordEventFired(knowledgeBaseEvent);
            }
        });
        lockStepper.stageAchieved(Test07Stages.LISTENERS_INSTALLED_GO, null);
        lockStepper.waitForStage(Test07Stages.COMPLETED);
    }

    public void testEnableEventGeneration() {
        if (!configured) {
            return;
        }
        final LockStepper<EventGenerationStages> lockStepper = new LockStepper<EventGenerationStages>(EventGenerationStages.START);
        Server server = Server.getInstance();
        final KnowledgeBase knowledgeBase = server.getProject(clientProject).getKnowledgeBase();
        DBServer_Test.assertTrue((boolean)knowledgeBase.getProject().isMultiUserServer());
        DBServer_Test.assertFalse((boolean)knowledgeBase.getProject().isMultiUserClient());
        this.checkEventFrameStores(knowledgeBase, true, false);
        new Thread("First Client"){

            public void run() {
                try {
                    DefaultKnowledgeBase defaultKnowledgeBase = DBServer_Test.this.getKb();
                    Assert.assertTrue((boolean)defaultKnowledgeBase.getProject().isMultiUserClient());
                    Assert.assertFalse((boolean)defaultKnowledgeBase.getProject().isMultiUserServer());
                    DBServer_Test.this.checkEventFrameStores(defaultKnowledgeBase, false, false);
                    TestListener testListener = new TestListener();
                    defaultKnowledgeBase.addKnowledgeBaseListener(testListener);
                    lockStepper.waitForStage(EventGenerationStages.LISTENERS_INSTALLED);
                    Cls cls = defaultKnowledgeBase.createCls("A", new ArrayList());
                    List<Cls> list = testListener.getCreatedClassesAndClear();
                    Assert.assertEquals((int)1, (int)list.size());
                    Assert.assertTrue((boolean)list.contains(cls));
                    lockStepper.stageAchieved(EventGenerationStages.FIRST_CLASS_ADDED, null);
                    lockStepper.waitForStage(EventGenerationStages.FIRST_CLASS_CHECKED);
                    defaultKnowledgeBase.setGenerateEventsEnabled(false);
                    DBServer_Test.this.checkEventFrameStores(defaultKnowledgeBase, false, true);
                    DBServer_Test.this.checkEventFrameStores(knowledgeBase, true, false);
                    Cls cls2 = defaultKnowledgeBase.createCls("B", new ArrayList());
                    list = testListener.getCreatedClassesAndClear();
                    Assert.assertEquals((int)0, (int)list.size());
                    lockStepper.stageAchieved(EventGenerationStages.SECOND_CLASS_ADDED, null);
                    lockStepper.waitForStage(EventGenerationStages.SECOND_CLASS_CHECKED);
                    defaultKnowledgeBase.setGenerateEventsEnabled(true);
                    DBServer_Test.this.checkEventFrameStores(defaultKnowledgeBase, false, false);
                    DBServer_Test.this.checkEventFrameStores(knowledgeBase, true, false);
                    Cls cls3 = defaultKnowledgeBase.createCls("C", new ArrayList());
                    list = testListener.getCreatedClassesAndClear();
                    Assert.assertEquals((int)1, (int)list.size());
                    Assert.assertTrue((boolean)list.contains(cls3));
                    lockStepper.stageAchieved(EventGenerationStages.THIRD_CLASS_ADDED, null);
                    lockStepper.waitForStage(EventGenerationStages.THIRD_CLASS_CHECKED);
                    defaultKnowledgeBase.getProject().dispose();
                    lockStepper.stageAchieved(EventGenerationStages.COMPLETED, null);
                }
                catch (Exception exception) {
                    lockStepper.exceptionOffMainThread(EventGenerationStages.COMPLETED, exception);
                }
            }
        }.start();
        new Thread("Second Client"){

            public void run() {
                try {
                    DefaultKnowledgeBase defaultKnowledgeBase = DBServer_Test.this.getKb();
                    DBServer_Test.this.checkEventFrameStores(defaultKnowledgeBase, false, false);
                    TestListener testListener = new TestListener();
                    defaultKnowledgeBase.addKnowledgeBaseListener(testListener);
                    lockStepper.stageAchieved(EventGenerationStages.LISTENERS_INSTALLED, null);
                    lockStepper.waitForStage(EventGenerationStages.FIRST_CLASS_ADDED);
                    DBServer_Test.this.checkEventFrameStores(defaultKnowledgeBase, false, false);
                    defaultKnowledgeBase.flushEvents();
                    List<Cls> list = testListener.getCreatedClassesAndClear();
                    Assert.assertEquals((int)1, (int)list.size());
                    Assert.assertTrue((boolean)list.iterator().next().getName().equals("A"));
                    lockStepper.stageAchieved(EventGenerationStages.FIRST_CLASS_CHECKED, null);
                    lockStepper.waitForStage(EventGenerationStages.SECOND_CLASS_ADDED);
                    DBServer_Test.this.checkEventFrameStores(defaultKnowledgeBase, false, false);
                    defaultKnowledgeBase.flushEvents();
                    list = testListener.getCreatedClassesAndClear();
                    Assert.assertEquals((int)1, (int)list.size());
                    Assert.assertTrue((boolean)list.iterator().next().getName().equals("B"));
                    lockStepper.stageAchieved(EventGenerationStages.SECOND_CLASS_CHECKED, null);
                    lockStepper.waitForStage(EventGenerationStages.THIRD_CLASS_ADDED);
                    DBServer_Test.this.checkEventFrameStores(defaultKnowledgeBase, false, false);
                    defaultKnowledgeBase.flushEvents();
                    list = testListener.getCreatedClassesAndClear();
                    Assert.assertEquals((int)1, (int)list.size());
                    Assert.assertTrue((boolean)list.iterator().next().getName().equals("C"));
                    defaultKnowledgeBase.getProject().dispose();
                    lockStepper.stageAchieved(EventGenerationStages.THIRD_CLASS_CHECKED, null);
                }
                catch (Exception exception) {
                    lockStepper.exceptionOffMainThread(EventGenerationStages.COMPLETED, exception);
                }
            }
        }.start();
        lockStepper.waitForStage(EventGenerationStages.COMPLETED);
    }

    private void checkEventFrameStores(KnowledgeBase knowledgeBase, boolean bl, boolean bl2) {
        FrameStoreManager frameStoreManager = knowledgeBase.getFrameStoreManager();
        EventGeneratorFrameStore eventGeneratorFrameStore = frameStoreManager.getFrameStoreFromClass(EventGeneratorFrameStore.class);
        EventSinkFrameStore eventSinkFrameStore = frameStoreManager.getFrameStoreFromClass(EventSinkFrameStore.class);
        if (bl) {
            DBServer_Test.assertNotNull((Object)eventGeneratorFrameStore);
        } else {
            DBServer_Test.assertNull((Object)eventGeneratorFrameStore);
        }
        if (bl2) {
            DBServer_Test.assertNotNull((Object)eventSinkFrameStore);
        } else {
            DBServer_Test.assertNull((Object)eventSinkFrameStore);
        }
    }

    static {
        Properties properties = DBServer_Test.getJunitProperties();
        if (properties != null) {
            clientProject = properties.getProperty(DB_CLIENT_PROJECT_PROPERTY);
        }
        configured = true;
        counter = 0;
    }

    public class ProjectShutdownListener
    extends ServerProjectAdapter {
        private String lastMessage;
        private ServerProject.ProjectStatus oldStatus;
        private ServerProject.ProjectStatus newStatus;

        public void projectNotificationReceived(ServerProjectNotificationEvent serverProjectNotificationEvent) {
            this.lastMessage = serverProjectNotificationEvent.getMessage();
        }

        public void projectStatusChanged(ServerProjectStatusChangeEvent serverProjectStatusChangeEvent) {
            this.oldStatus = serverProjectStatusChangeEvent.getOldStatus();
            this.newStatus = serverProjectStatusChangeEvent.getNewStatus();
        }

        public String getLastMessage() {
            return this.lastMessage;
        }

        public ServerProject.ProjectStatus getOldStatus() {
            return this.oldStatus;
        }

        public ServerProject.ProjectStatus getNewStatus() {
            return this.newStatus;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestListener
    extends KnowledgeBaseAdapter {
        private List<Cls> createdClasses = new ArrayList<Cls>();

        private TestListener() {
        }

        @Override
        public void clsCreated(KnowledgeBaseEvent knowledgeBaseEvent) {
            this.createdClasses.add(knowledgeBaseEvent.getCls());
        }

        public List<Cls> getCreatedClassesAndClear() {
            List<Cls> list = this.createdClasses;
            this.createdClasses = new ArrayList<Cls>();
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventGenerationStages {
        START,
        LISTENERS_INSTALLED,
        FIRST_CLASS_ADDED,
        FIRST_CLASS_CHECKED,
        SECOND_CLASS_ADDED,
        SECOND_CLASS_CHECKED,
        THIRD_CLASS_ADDED,
        THIRD_CLASS_CHECKED,
        COMPLETED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Test07Stages {
        START,
        CLIENT_CONNECTED,
        LISTENERS_INSTALLED_GO,
        COMPLETED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Test06Stages {
        start,
        inTransaction,
        write,
        preComplete,
        completed;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Test05Stages {
        testStarted,
        firstRead,
        write,
        secondRead,
        firstCommit,
        preComplete,
        testCompleted;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Test04Stages {
        testStarted,
        firstRead,
        write,
        secondRead,
        firstCommit,
        preComplete,
        testCompleted;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Test02Stages {
        testStarted,
        firstReadComplete,
        writeComplete,
        secondReadComplete,
        otherTransactionClosed,
        thirdReadComplete,
        testComplete;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Test01Stages {
        testStarted,
        mainThreadStarted,
        transactionOpenWithWrite,
        readComplete,
        testComplete;

    }
}

