/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultCls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase_Test;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.SystemFrames;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.framestore.SimpleFrameStore;
import edu.stanford.smi.protege.test.APITestCase;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;

public class DatabaseKnowledgeBase_Test
extends APITestCase {
    public void testDBModficationSlots() throws Exception {
        for (APITestCase.DBType dBType : APITestCase.DBType.values()) {
            DatabaseKnowledgeBase_Test.setDBType(dBType);
            if (!DatabaseKnowledgeBase_Test.dbConfigured()) continue;
            DefaultKnowledgeBase_Test defaultKnowledgeBase_Test = new DefaultKnowledgeBase_Test();
            DefaultKnowledgeBase_Test.setDatabaseProject();
            try {
                defaultKnowledgeBase_Test.testModificationSlots();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw exception;
            }
        }
    }

    public void testGetDBFramesWithValue() {
        for (APITestCase.DBType dBType : APITestCase.DBType.values()) {
            DatabaseKnowledgeBase_Test.setDBType(dBType);
            if (!DatabaseKnowledgeBase_Test.dbConfigured()) continue;
            DatabaseKnowledgeBase_Test.setDatabaseProject();
            Slot slot = this.createMultiValuedSlot(ValueType.STRING);
            Slot slot2 = this.createMultiValuedSlot(ValueType.INSTANCE);
            Cls cls = this.createCls();
            cls.addDirectTemplateSlot(slot);
            cls.addDirectTemplateSlot(slot2);
            Instance instance = this.createInstance(cls);
            Instance instance2 = this.createInstance(cls);
            Instance instance3 = this.createInstance(cls);
            instance.addOwnSlotValue(slot, "abc");
            instance2.addOwnSlotValue(slot, "abc");
            instance3.addOwnSlotValue(slot, "abc");
            instance2.addOwnSlotValue(slot2, instance);
            DatabaseKnowledgeBase_Test.assertEquals((String)"string match", (int)3, (int)this.getDomainKB().getFramesWithValue(slot, null, false, "abc").size());
            DatabaseKnowledgeBase_Test.assertEquals((String)"frame match", (int)1, (int)this.getDomainKB().getFramesWithValue(slot2, null, false, instance).size());
        }
    }

    public void testGetMatchingDBReferences() {
        for (APITestCase.DBType dBType : APITestCase.DBType.values()) {
            DatabaseKnowledgeBase_Test.setDBType(dBType);
            if (!DatabaseKnowledgeBase_Test.dbConfigured()) continue;
            DatabaseKnowledgeBase_Test.setDatabaseProject();
            Slot slot = this.createMultiValuedSlot(ValueType.STRING);
            Cls cls = this.createCls();
            cls.addDirectTemplateSlot(slot);
            Instance instance = this.createInstance(cls);
            instance.addOwnSlotValue(slot, "zabcy");
            Instance instance2 = this.createInstance(cls);
            instance2.addOwnSlotValue(slot, "abcz");
            Instance instance3 = this.createInstance(cls);
            instance3.addOwnSlotValue(slot, "qqq");
            DatabaseKnowledgeBase_Test.assertEquals((String)"exact", (int)0, (int)this.getMatchCount("z"));
            DatabaseKnowledgeBase_Test.assertEquals((String)"starts", (int)1, (int)this.getMatchCount("z*"));
            DatabaseKnowledgeBase_Test.assertEquals((String)"contains", (int)2, (int)this.getMatchCount("*z*"));
            DatabaseKnowledgeBase_Test.assertEquals((String)"contains insensitive", (int)2, (int)this.getMatchCount("*Z*"));
            DatabaseKnowledgeBase_Test.assertEquals((String)"contains 2", (int)2, (int)this.getMatchCount("*abc*"));
        }
    }

    private int getMatchCount(String string) {
        return this.getDomainKB().getMatchingReferences(string, -1).size();
    }

    public void testMatchOnPercentInDB() {
        for (APITestCase.DBType dBType : APITestCase.DBType.values()) {
            DatabaseKnowledgeBase_Test.setDBType(dBType);
            if (!DatabaseKnowledgeBase_Test.dbConfigured()) continue;
            DatabaseKnowledgeBase_Test.setDatabaseProject();
            String string = "foo %";
            String string2 = "foo abc";
            Slot slot = this.getDomainKB().getSlot(":NAME");
            this.createCls(string);
            this.createCls(string2);
            Collection<Frame> collection = this.getDomainKB().getMatchingFrames(slot, null, false, string, -1);
            DatabaseKnowledgeBase_Test.assertEquals((String)"matching size", (int)1, (int)collection.size());
            Collection<Reference> collection2 = this.getDomainKB().getReferences(string, -1);
            DatabaseKnowledgeBase_Test.assertEquals((String)"references size", (int)1, (int)collection2.size());
        }
    }

    public void testMatchOnQuoteInDB() {
        for (APITestCase.DBType dBType : APITestCase.DBType.values()) {
            DatabaseKnowledgeBase_Test.setDBType(dBType);
            if (!DatabaseKnowledgeBase_Test.dbConfigured()) continue;
            DatabaseKnowledgeBase_Test.setDatabaseProject();
            String string = "foo's";
            Slot slot = this.getDomainKB().getSlot(":NAME");
            this.createCls(string);
            Collection<Frame> collection = this.getDomainKB().getMatchingFrames(slot, null, false, string, -1);
            DatabaseKnowledgeBase_Test.assertEquals((String)"matching size", (int)1, (int)collection.size());
            Collection<Reference> collection2 = this.getDomainKB().getReferences(string, -1);
            DatabaseKnowledgeBase_Test.assertEquals((String)"references size", (int)1, (int)collection2.size());
        }
    }

    public void testGetDBDirectInstances() {
        for (APITestCase.DBType dBType : APITestCase.DBType.values()) {
            DatabaseKnowledgeBase_Test.setDBType(dBType);
            if (!DatabaseKnowledgeBase_Test.dbConfigured()) continue;
            DatabaseKnowledgeBase_Test.setDatabaseProject();
            Cls cls = this.createCls();
            String string = cls.getName();
            this.createInstance(cls);
            this.createInstance(cls);
            this.createInstance(cls);
            DatabaseKnowledgeBase_Test.assertEquals((String)"direct instance count", (int)3, (int)cls.getDirectInstanceCount());
            DatabaseKnowledgeBase_Test.saveAndReload();
            cls = this.getCls(string);
            this.createInstance(cls);
            DatabaseKnowledgeBase_Test.assertEquals((String)"direct instance count after reload", (int)4, (int)cls.getDirectInstanceCount());
        }
    }

    public void testSwizzleCaseSensitivity() {
        for (APITestCase.DBType dBType : APITestCase.DBType.values()) {
            DatabaseKnowledgeBase_Test.setDBType(dBType);
            if (!DatabaseKnowledgeBase_Test.dbConfigured()) continue;
            DatabaseKnowledgeBase_Test.setDatabaseProject();
            KnowledgeBase knowledgeBase = this.getDomainKB();
            String string = "PrEFiX";
            String string2 = UUID.randomUUID().toString();
            SystemFrames systemFrames = knowledgeBase.getSystemFrames();
            Instance instance = this.createInstance(systemFrames.getRootCls());
            Slot slot = this.createSlot();
            Cls cls = this.createCls(string + string2);
            instance.addOwnSlotValue(slot, cls);
            Cls cls2 = this.createCls(string.toLowerCase() + string2);
            instance.addOwnSlotValue(slot, cls2);
            SimpleFrameStore simpleFrameStore = knowledgeBase.getFrameStoreManager().getFrameStoreFromClass(SimpleFrameStore.class);
            DatabaseKnowledgeBase_Test.assertTrue((simpleFrameStore != null ? 1 : 0) != 0);
            simpleFrameStore.setDirectOwnSlotValues(cls, systemFrames.getDirectTypesSlot(), Collections.singleton(systemFrames.getStandardSlotMetaCls()));
            knowledgeBase.flushCache();
            DatabaseKnowledgeBase_Test.assertTrue((boolean)(knowledgeBase.getFrame(string + string2) instanceof Cls));
            DatabaseKnowledgeBase_Test.assertTrue((boolean)(knowledgeBase.getFrame(string.toLowerCase() + string2) instanceof Cls));
            int n = 0;
            for (Object e : instance.getOwnSlotValues(slot)) {
                DatabaseKnowledgeBase_Test.assertTrue((boolean)(e instanceof Cls));
                ++n;
            }
            DatabaseKnowledgeBase_Test.assertTrue((n == 2 ? 1 : 0) != 0);
            simpleFrameStore.swizzleInstance(cls);
            knowledgeBase.flushCache();
            DatabaseKnowledgeBase_Test.assertTrue((boolean)(knowledgeBase.getFrame(string + string2) instanceof Slot));
            DatabaseKnowledgeBase_Test.assertTrue((boolean)(knowledgeBase.getFrame(string.toLowerCase() + string2) instanceof Cls));
            n = 0;
            for (Object e : instance.getOwnSlotValues(slot)) {
                if (((Frame)e).getName().equals(string.toLowerCase() + string2)) {
                    DatabaseKnowledgeBase_Test.assertTrue((boolean)(e instanceof Cls));
                } else {
                    DatabaseKnowledgeBase_Test.assertTrue((boolean)(e instanceof Slot));
                }
                ++n;
            }
            DatabaseKnowledgeBase_Test.assertTrue((n == 2 ? 1 : 0) != 0);
        }
    }

    public void testRenameCaseSensitivity() {
        for (APITestCase.DBType dBType : APITestCase.DBType.values()) {
            DatabaseKnowledgeBase_Test.setDBType(dBType);
            if (!DatabaseKnowledgeBase_Test.dbConfigured()) continue;
            DatabaseKnowledgeBase_Test.setDatabaseProject();
            KnowledgeBase knowledgeBase = this.getDomainKB();
            String string = "PrEFiX";
            String string2 = UUID.randomUUID().toString();
            SystemFrames systemFrames = knowledgeBase.getSystemFrames();
            Instance instance = this.createInstance(systemFrames.getRootCls());
            Slot slot = this.createSlot();
            Cls cls = this.createCls(string + string2);
            instance.addOwnSlotValue(slot, cls);
            Cls cls2 = this.createCls(string.toLowerCase() + string2);
            instance.addOwnSlotValue(slot, cls2);
            SimpleFrameStore simpleFrameStore = knowledgeBase.getFrameStoreManager().getFrameStoreFromClass(SimpleFrameStore.class);
            DatabaseKnowledgeBase_Test.assertTrue((simpleFrameStore != null ? 1 : 0) != 0);
            simpleFrameStore.setDirectOwnSlotValues(cls, systemFrames.getDirectTypesSlot(), Collections.singleton(systemFrames.getStandardSlotMetaCls()));
            knowledgeBase.flushCache();
            boolean bl = false;
            boolean bl2 = false;
            for (Object e : instance.getOwnSlotValues(slot)) {
                if (((Frame)e).getName().equals(cls.getName())) {
                    bl = true;
                    continue;
                }
                if (!((Frame)e).getName().equals(cls2.getName())) continue;
                bl2 = true;
            }
            DatabaseKnowledgeBase_Test.assertTrue((boolean)bl);
            DatabaseKnowledgeBase_Test.assertTrue((boolean)bl2);
            simpleFrameStore.replaceFrame(cls, new DefaultCls(knowledgeBase, new FrameID(string2)));
            knowledgeBase.flushCache();
            bl = false;
            bl2 = false;
            for (Object e : instance.getOwnSlotValues(slot)) {
                if (((Frame)e).getName().equals(string2)) {
                    bl = true;
                    continue;
                }
                if (!((Frame)e).getName().equals(cls2.getName())) continue;
                bl2 = true;
            }
            DatabaseKnowledgeBase_Test.assertTrue((boolean)bl);
            DatabaseKnowledgeBase_Test.assertTrue((boolean)bl2);
        }
    }
}

