/*
 * Decompiled with CFR 0.152.
 */
package org.evactor.process.analyse.trend;

import akka.actor.Actor;
import org.evactor.bus.ProcessorEventBus;
import org.evactor.bus.UseProcessorEventBus$class;
import org.evactor.model.events.Event;
import org.evactor.model.events.ValueEvent;
import org.evactor.monitor.Monitored;
import org.evactor.monitor.Monitored$class;
import org.evactor.monitor.Monitoring;
import org.evactor.process.CategoryProcessor;
import org.evactor.process.analyse.window.TimeWindow;
import org.evactor.process.analyse.window.TimeWindow$class;
import org.evactor.process.analyse.window.Window$class;
import org.evactor.publish.Publication;
import org.evactor.publish.Publisher;
import org.evactor.publish.Publisher$class;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedMap;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\u0001\u0003\u00015\u0011QCU3he\u0016\u001c8/[8o'V\u0014\u0017I\\1msN,'O\u0003\u0002\u0004\t\u0005)AO]3oI*\u0011QAB\u0001\bC:\fG._:f\u0015\t9\u0001\"A\u0004qe>\u001cWm]:\u000b\u0005%Q\u0011aB3wC\u000e$xN\u001d\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M1\u0001A\u0004\n\u0019=\u0011\u0002\"a\u0004\t\u000e\u0003\u0019I!!\u0005\u0004\u0003#\r\u000bG/Z4pef\u0004&o\\2fgN|'\u000f\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u00051q/\u001b8e_^L!a\u0006\u000b\u0003\u0015QKW.Z,j]\u0012|w\u000f\u0005\u0002\u001a95\t!D\u0003\u0002\u001c\u0011\u00059\u0001/\u001e2mSND\u0017BA\u000f\u001b\u0005%\u0001VO\u00197jg\",'\u000f\u0005\u0002 E5\t\u0001E\u0003\u0002\"\u0011\u00059Qn\u001c8ji>\u0014\u0018BA\u0012!\u0005%iuN\\5u_J,G\r\u0005\u0002&U5\taE\u0003\u0002(Q\u0005)\u0011m\u0019;pe*\t\u0011&\u0001\u0003bW.\f\u0017BA\u0016'\u00051\t5\r^8s\u0019><w-\u001b8h\u0011!i\u0003A!b\u0001\n\u0003q\u0013a\u00039vE2L7-\u0019;j_:,\u0012a\f\t\u00033AJ!!\r\u000e\u0003\u0017A+(\r\\5dCRLwN\u001c\u0005\tg\u0001\u0011\t\u0011)A\u0005_\u0005a\u0001/\u001e2mS\u000e\fG/[8oA!AQ\u0007\u0001BC\u0002\u0013\u0005c'\u0001\u0006dCR,wm\u001c:jKN,\u0012a\u000e\t\u0004qy\neBA\u001d=\u001b\u0005Q$\"A\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uR\u0014A\u0002)sK\u0012,g-\u0003\u0002@\u0001\n\u00191+\u001a;\u000b\u0005uR\u0004C\u0001\u001dC\u0013\t\u0019\u0005I\u0001\u0004TiJLgn\u001a\u0005\n\u000b\u0002\u0011\t\u0011)A\u0005o\u0019\u000b1bY1uK\u001e|'/[3tA%\u0011Q\u0007\u0005\u0005\t\u0011\u0002\u0011)\u0019!C\u0001\u0013\u00069Q.\u001b8TSj,W#\u0001&\u0011\u0005eZ\u0015B\u0001';\u0005\u0011auN\\4\t\u00119\u0003!\u0011!Q\u0001\n)\u000b\u0001\"\\5o'&TX\r\t\u0005\t!\u0002\u0011)\u0019!C\u0001\u0013\u0006IA/[7fMJ\fW.\u001a\u0005\t%\u0002\u0011\t\u0011)A\u0005\u0015\u0006QA/[7fMJ\fW.\u001a\u0011\t\u000bQ\u0003A\u0011A+\u0002\rqJg.\u001b;?)\u00151\u0006,\u0017.\\!\t9\u0006!D\u0001\u0003\u0011\u0015i3\u000b1\u00010\u0011\u0015)4\u000b1\u00018\u0011\u0015A5\u000b1\u0001K\u0011\u0015\u00016\u000b1\u0001K\u000b\u0011i\u0006\u0001\u00010\u0003\u0003M\u0003\"a\u00183\u000e\u0003\u0001T!!\u00192\u0002\r\u00154XM\u001c;t\u0015\t\u0019\u0007\"A\u0003n_\u0012,G.\u0003\u0002fA\n)QI^3oi\"9q\r\u0001b\u0001\n\u0003I\u0015!B:uCJ$\bBB5\u0001A\u0003%!*\u0001\u0004ti\u0006\u0014H\u000f\t\u0005\tW\u0002\u0011\r\u0011\"\u0005\u0003Y\u0006QQM^3oi\u000e{WO\u001c;\u0016\u00035\u00042!\u000f8K\u0013\ty'HA\u0003BeJ\f\u0017\u0010\u0003\u0004r\u0001\u0001\u0006I!\\\u0001\fKZ,g\u000e^\"pk:$\b\u0005C\u0004t\u0001\u0001\u0007I\u0011A%\u0002\u0013%$XM]1uS>t\u0007bB;\u0001\u0001\u0004%\tA^\u0001\u000eSR,'/\u0019;j_:|F%Z9\u0015\u0005]T\bCA\u001dy\u0013\tI(H\u0001\u0003V]&$\bbB>u\u0003\u0003\u0005\rAS\u0001\u0004q\u0012\n\u0004BB?\u0001A\u0003&!*\u0001\u0006ji\u0016\u0014\u0018\r^5p]\u0002B\u0001b \u0001A\u0002\u0013\u0005\u0011\u0011A\u0001\rGV\u0014(/\u001a8u\u0007>,gMZ\u000b\u0003\u0003\u0007\u00012!OA\u0003\u0013\r\t9A\u000f\u0002\u0007\t>,(\r\\3\t\u0013\u0005-\u0001\u00011A\u0005\u0002\u00055\u0011\u0001E2veJ,g\u000e^\"pK\u001a4w\fJ3r)\r9\u0018q\u0002\u0005\nw\u0006%\u0011\u0011!a\u0001\u0003\u0007A\u0001\"a\u0005\u0001A\u0003&\u00111A\u0001\u000eGV\u0014(/\u001a8u\u0007>,gM\u001a\u0011\t\u000f\u0005]\u0001\u0001\"\u0011\u0002\u001a\u0005A\u0001O]3Ti\u0006\u0014H\u000fF\u0001x\u0011\u001d\ti\u0002\u0001C!\u00033\t\u0001\u0002]8tiN#x\u000e\u001d\u0005\u0007\u000f\u0001!\t&!\t\u0015\u0007]\f\u0019\u0003C\u0004\u0002&\u0005}\u0001\u0019\u00010\u0002\u000b\u00154XM\u001c;\t\u000f\u0005%\u0002\u0001\"\u0001\u0002,\u0005aQn\u001c<f\u0007>,h\u000e^3sgR\u0019q/!\f\t\u000f\u0005=\u0012q\u0005a\u0001\u0015\u0006\u0019an\\<\t\u000f\u0005M\u0002\u0001\"\u0001\u00026\u0005aA.Z1tiN\u000bX/\u0019:fgR!\u00111AA\u001c\u0011!\tI$!\rA\u0002\u0005m\u0012AA=t!\u0015\ti$!\u0014K\u001d\u0011\ty$!\u0013\u000f\t\u0005\u0005\u0013qI\u0007\u0003\u0003\u0007R1!!\u0012\r\u0003\u0019a$o\\8u}%\t1(C\u0002\u0002Li\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002P\u0005E#\u0001\u0002'jgRT1!a\u0013;\u0011!\t)\u0006\u0001Q\u0005\n\u0005e\u0011\u0001B:u_BDq!!\u0017\u0001\t#\nI\"A\u0004uS6,w.\u001e;")
public class RegressionSubAnalyser
extends CategoryProcessor
implements TimeWindow,
Publisher,
Monitored {
    private final Publication publication;
    private final long minSize;
    private final long timeframe;
    private final long start;
    private final long[] eventCount;
    private long iteration;
    private double currentCoeff;
    private final Option<Monitoring> monitor;
    private final Function1<String, String> org$evactor$monitor$Monitored$$label;
    private final ProcessorEventBus bus;

    @Override
    public Option<Monitoring> monitor() {
        return this.monitor;
    }

    @Override
    public Function1<String, String> org$evactor$monitor$Monitored$$label() {
        return this.org$evactor$monitor$Monitored$$label;
    }

    @Override
    public void org$evactor$monitor$Monitored$_setter_$monitor_$eq(Option x$1) {
        this.monitor = x$1;
    }

    @Override
    public void org$evactor$monitor$Monitored$_setter_$org$evactor$monitor$Monitored$$label_$eq(Function1 x$1) {
        this.org$evactor$monitor$Monitored$$label = x$1;
    }

    @Override
    public void incr(String key) {
        Monitored$class.incr(this, key);
    }

    @Override
    public void incr(String key, int i) {
        Monitored$class.incr(this, key, i);
    }

    @Override
    public void addLabel(String key, String value) {
        Monitored$class.addLabel(this, key, value);
    }

    @Override
    public void addLabel(String value) {
        Monitored$class.addLabel(this, value);
    }

    @Override
    public void removeLabel(String key) {
        Monitored$class.removeLabel(this, key);
    }

    @Override
    public void removeLabel() {
        Monitored$class.removeLabel(this);
    }

    @Override
    public void addMetric(String key, int value) {
        Monitored$class.addMetric(this, key, value);
    }

    @Override
    public void removeMetric(String key) {
        Monitored$class.removeMetric(this, key);
    }

    @Override
    public void addGauge(String key, double value) {
        Monitored$class.addGauge(this, key, value);
    }

    @Override
    public void removeGauge(String key) {
        Monitored$class.removeGauge(this, key);
    }

    @Override
    public <T> T time(String key, Function0<T> f) {
        return (T)Monitored$class.time(this, key, f);
    }

    @Override
    public void publish(Event event) {
        Publisher$class.publish(this, event);
    }

    @Override
    public ProcessorEventBus bus() {
        return this.bus;
    }

    @Override
    public void org$evactor$bus$UseProcessorEventBus$_setter_$bus_$eq(ProcessorEventBus x$1) {
        this.bus = x$1;
    }

    @Override
    public void org$evactor$process$analyse$window$TimeWindow$$super$preStart() {
        Actor.class.preStart((Actor)this);
    }

    @Override
    public void org$evactor$process$analyse$window$TimeWindow$$super$postStop() {
        super.postStop();
    }

    @Override
    public Map<Object, Object> getInactive(SortedMap<Object, Object> activities) {
        return TimeWindow$class.getInactive(this, activities);
    }

    @Override
    public Publication publication() {
        return this.publication;
    }

    @Override
    public Set<String> categories() {
        return super.categories();
    }

    public long minSize() {
        return this.minSize;
    }

    @Override
    public long timeframe() {
        return this.timeframe;
    }

    public long start() {
        return this.start;
    }

    public long[] eventCount() {
        return this.eventCount;
    }

    public long iteration() {
        return this.iteration;
    }

    public void iteration_$eq(long x$1) {
        this.iteration = x$1;
    }

    public double currentCoeff() {
        return this.currentCoeff;
    }

    public void currentCoeff_$eq(double x$1) {
        this.currentCoeff = x$1;
    }

    @Override
    public void preStart() {
        this.log().debug("Starting sub counter with categories {} and timeframe {} ms", this.categories(), (Object)BoxesRunTime.boxToLong((long)this.timeframe()));
        TimeWindow$class.preStart(this);
    }

    @Override
    public void postStop() {
        this.log().debug("Stopping sub counter with categories {} and timeframe {} ms", this.categories(), (Object)BoxesRunTime.boxToLong((long)this.timeframe()));
        this.removeLabel();
        TimeWindow$class.postStop(this);
    }

    @Override
    public void process(Event event) {
        List listToCheck;
        long now = System.currentTimeMillis();
        this.moveCounters(now);
        int i = (int)((now - event.timestamp()) / (this.timeframe() / 10L));
        if (i < 10 && i >= 0) {
            this.eventCount()[i] = this.eventCount()[i] + 1L;
        }
        if (BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps(this.eventCount()).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) > this.minSize() && now > this.start() + this.timeframe() / 2L && (listToCheck = Predef$.MODULE$.longArrayOps(this.eventCount()).toList().drop(1).reverse().dropWhile((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$1) {
                return this.apply$mcZJ$sp(x$1);
            }

            public boolean apply$mcZJ$sp(long x$1) {
                return x$1 == 0L;
            }
        })).size() > 6) {
            double coeff = this.leastSquares((List<Object>)listToCheck);
            if (this.currentCoeff() != coeff) {
                this.publish(new ValueEvent(this.uuid(), this.currentTime(), this.categories(), BoxesRunTime.boxToDouble((double)coeff)));
                this.currentCoeff_$eq(coeff);
            }
        }
    }

    public void moveCounters(long now) {
        if (now > this.iteration() + this.timeframe() / 10L) {
            int iterations = (int)((now - this.iteration()) / (this.timeframe() / 10L));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(iterations - 1), 10).foreach$mVc$sp((Function1)new Serializable(this, iterations){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RegressionSubAnalyser $outer;
                private final int iterations$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    if (9 - i + this.iterations$1 < 10) {
                        this.$outer.eventCount()[9 - i + this.iterations$1] = this.$outer.eventCount()[9 - i];
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.iterations$1 = iterations$1;
                }
            });
            int max = iterations < 10 ? iterations : 10;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), max).foreach$mVc$sp((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RegressionSubAnalyser $outer;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.$outer.eventCount()[i] = 0L;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.iteration_$eq(this.iteration() + this.timeframe() / 10L * (long)(iterations + 1));
        }
    }

    public double leastSquares(List<Object> ys) {
        Range xs = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), ys.size() + 1);
        long totalSum = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)xs.zip(ys, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    int x = tuple2._1$mcI$sp();
                    long y = tuple2._2$mcJ$sp();
                    long l = (long)x * y;
                    return l;
                }
                throw new MatchError(tuple2);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long numerator = totalSum - (long)xs.sum((Numeric)Numeric.IntIsIntegral$.MODULE$) * BoxesRunTime.unboxToLong((Object)ys.sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (long)xs.size();
        int denominator = BoxesRunTime.unboxToInt((Object)((TraversableOnce)xs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int x) {
                return this.apply$mcII$sp(x);
            }

            public int apply$mcII$sp(int x) {
                return x * x;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) - xs.sum((Numeric)Numeric.IntIsIntegral$.MODULE$) * xs.sum((Numeric)Numeric.IntIsIntegral$.MODULE$) / xs.size();
        return (double)numerator / (double)denominator;
    }

    private void stop() {
        this.context().stop(this.context().self());
    }

    @Override
    public void timeout() {
        this.moveCounters(System.currentTimeMillis());
        if (BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps(this.eventCount()).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) == 0L) {
            this.stop();
        }
    }

    public RegressionSubAnalyser(Publication publication, Set<String> categories, long minSize, long timeframe) {
        this.publication = publication;
        this.minSize = minSize;
        this.timeframe = timeframe;
        super(categories);
        Window$class.$init$(this);
        TimeWindow$class.$init$(this);
        UseProcessorEventBus$class.$init$(this);
        Publisher$class.$init$(this);
        Monitored$class.$init$(this);
        this.start = System.currentTimeMillis();
        this.eventCount = new long[10];
        this.iteration = this.start();
        this.currentCoeff = 0.0;
    }
}

