/*
 * Decompiled with CFR 0.152.
 */
package org.everit.authnr.qdsl.util.ri.ecm.internal;

import aQute.bnd.annotation.headers.ProvideCapability;
import java.util.Hashtable;
import org.everit.authentication.context.AuthenticationContext;
import org.everit.authnr.qdsl.util.AuthnrQdslUtil;
import org.everit.authnr.qdsl.util.ri.AuthnrQdslUtilImpl;
import org.everit.authorization.qdsl.util.AuthorizationQdslUtil;
import org.everit.osgi.ecm.annotation.Activate;
import org.everit.osgi.ecm.annotation.Component;
import org.everit.osgi.ecm.annotation.ConfigurationPolicy;
import org.everit.osgi.ecm.annotation.Deactivate;
import org.everit.osgi.ecm.annotation.ManualService;
import org.everit.osgi.ecm.annotation.ServiceRef;
import org.everit.osgi.ecm.annotation.attribute.StringAttribute;
import org.everit.osgi.ecm.annotation.attribute.StringAttributes;
import org.everit.osgi.ecm.component.ComponentContext;
import org.osgi.framework.ServiceRegistration;

@Component(componentId="org.everit.authnr.qdsl.util.ri.ecm.AuthnrQdslUtil", configurationPolicy=ConfigurationPolicy.FACTORY, label="Everit Authenticated Authorization QDSL Util RI", description="Component that registers an AuthnrQdslUtil OSGi service.")
@StringAttributes(value={@StringAttribute(attributeId="service.description", defaultValue={"Default Authenticated Authorization QDSL Util"}, priority=1.0f, label="Service Description", description="The description of this component configuration. It is used to easily identify the service registered by this component.")})
@ManualService(value={AuthnrQdslUtil.class})
@ProvideCapability(ns="org.everit.osgi.ecm.component", value="class=${@class}")
public class AuthnrQdslUtilComponent {
    public static final int P1_SERVICE_DESCRIPTION = 1;
    public static final int P2_AUTHENTICATION_CONTEXT = 2;
    public static final int P3_AUTHORIZATION_QDSL_UTIL = 3;
    private AuthenticationContext authenticationContext;
    private AuthorizationQdslUtil authorizationQdslUtil;
    private ServiceRegistration<AuthnrQdslUtil> serviceRegistration;

    @Activate
    public void activate(ComponentContext<AuthnrQdslUtilComponent> componentContext) {
        AuthnrQdslUtilImpl authnrQdslUtil = new AuthnrQdslUtilImpl(this.authenticationContext, this.authorizationQdslUtil);
        Hashtable serviceProperties = new Hashtable(componentContext.getProperties());
        this.serviceRegistration = componentContext.registerService(AuthnrQdslUtil.class, (Object)authnrQdslUtil, serviceProperties);
    }

    @Deactivate
    public void deactivate() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    @ServiceRef(attributeId="authenticationContext.target", defaultValue={""}, attributePriority=2.0f, label="Authentication Context target", description="OSGi service filter to identify the AuthenticationContext service.")
    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    @ServiceRef(attributeId="authorizationQdslUtil.target", defaultValue={""}, attributePriority=3.0f, label="Authorization QDSL Util target", description="OSGi service filter to identify the AuthorizationQdslUtil service.")
    public void setAuthorizationQdslUtil(AuthorizationQdslUtil authorizationQdslUtil) {
        this.authorizationQdslUtil = authorizationQdslUtil;
    }
}

